/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Checkable;
import com.rey.material.R;
import com.rey.material.app.ThemeManager;
import com.rey.material.drawable.RippleDrawable;
import com.rey.material.util.ColorUtil;
import com.rey.material.util.ThemeUtil;
import com.rey.material.util.ViewUtil;
import com.rey.material.widget.RippleManager;

public class Switch
extends View
implements Checkable,
ThemeManager.OnThemeChangedListener {
    private RippleManager mRippleManager;
    protected int mStyleId;
    protected int mCurrentStyle = Integer.MIN_VALUE;
    private boolean mRunning = false;
    private Paint mPaint;
    private RectF mDrawRect;
    private RectF mTempRect;
    private Path mTrackPath;
    private int mTrackSize = -1;
    private ColorStateList mTrackColors;
    private Paint.Cap mTrackCap = Paint.Cap.ROUND;
    private int mThumbRadius = -1;
    private ColorStateList mThumbColors;
    private float mThumbPosition;
    private int mMaxAnimDuration = -1;
    private Interpolator mInterpolator;
    private int mGravity = 16;
    private boolean mChecked = false;
    private float mMemoX;
    private float mStartX;
    private float mFlingVelocity;
    private long mStartTime;
    private int mAnimDuration;
    private float mStartPosition;
    private int[] mTempStates = new int[2];
    private int mShadowSize = -1;
    private int mShadowOffset = -1;
    private Path mShadowPath;
    private Paint mShadowPaint;
    private static final int COLOR_SHADOW_START = 0x4C000000;
    private static final int COLOR_SHADOW_END = 0;
    private boolean mIsRtl = false;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            Switch.this.update();
        }
    };

    public Switch(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public Switch(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public Switch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public Switch(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mPaint = new Paint(1);
        this.mDrawRect = new RectF();
        this.mTempRect = new RectF();
        this.mTrackPath = new Path();
        this.mFlingVelocity = ViewConfiguration.get((Context)context).getScaledMinimumFlingVelocity();
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
        this.mStyleId = ThemeManager.getStyleId(context, attrs, defStyleAttr, defStyleRes);
    }

    public void applyStyle(int resId) {
        ViewUtil.applyStyle(this, resId);
        this.applyStyle(this.getContext(), null, 0, resId);
    }

    protected void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.getRippleManager().onCreate(this, context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Switch, defStyleAttr, defStyleRes);
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int resId;
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.Switch_sw_trackSize) {
                this.mTrackSize = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.Switch_sw_trackColor) {
                this.mTrackColors = a.getColorStateList(attr2);
                continue;
            }
            if (attr2 == R.styleable.Switch_sw_trackCap) {
                int cap = a.getInteger(attr2, 0);
                if (cap == 0) {
                    this.mTrackCap = Paint.Cap.BUTT;
                    continue;
                }
                if (cap == 1) {
                    this.mTrackCap = Paint.Cap.ROUND;
                    continue;
                }
                this.mTrackCap = Paint.Cap.SQUARE;
                continue;
            }
            if (attr2 == R.styleable.Switch_sw_thumbColor) {
                this.mThumbColors = a.getColorStateList(attr2);
                continue;
            }
            if (attr2 == R.styleable.Switch_sw_thumbRadius) {
                this.mThumbRadius = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.Switch_sw_thumbElevation) {
                this.mShadowSize = a.getDimensionPixelSize(attr2, 0);
                this.mShadowOffset = this.mShadowSize / 2;
                continue;
            }
            if (attr2 == R.styleable.Switch_sw_animDuration) {
                this.mMaxAnimDuration = a.getInt(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.Switch_android_gravity) {
                this.mGravity = a.getInt(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.Switch_android_checked) {
                this.setCheckedImmediately(a.getBoolean(attr2, this.mChecked));
                continue;
            }
            if (attr2 != R.styleable.Switch_sw_interpolator || (resId = a.getResourceId(R.styleable.Switch_sw_interpolator, 0)) == 0) continue;
            this.mInterpolator = AnimationUtils.loadInterpolator((Context)context, (int)resId);
        }
        a.recycle();
        if (this.mTrackSize < 0) {
            this.mTrackSize = ThemeUtil.dpToPx(context, 2);
        }
        if (this.mThumbRadius < 0) {
            this.mThumbRadius = ThemeUtil.dpToPx(context, 8);
        }
        if (this.mShadowSize < 0) {
            this.mShadowSize = ThemeUtil.dpToPx(context, 2);
            this.mShadowOffset = this.mShadowSize / 2;
        }
        if (this.mMaxAnimDuration < 0) {
            this.mMaxAnimDuration = context.getResources().getInteger(0x10E0001);
        }
        if (this.mInterpolator == null) {
            this.mInterpolator = new DecelerateInterpolator();
        }
        if (this.mTrackColors == null) {
            int[][] states = new int[][]{{-16842912}, {0x10100A0}};
            int[] colors = new int[]{ColorUtil.getColor(ThemeUtil.colorControlNormal(context, -16777216), 0.5f), ColorUtil.getColor(ThemeUtil.colorControlActivated(context, -16777216), 0.5f)};
            this.mTrackColors = new ColorStateList((int[][])states, colors);
        }
        if (this.mThumbColors == null) {
            int[][] states = new int[][]{{-16842912}, {0x10100A0}};
            int[] colors = new int[]{0xFAFAFA, ThemeUtil.colorControlActivated(context, -16777216)};
            this.mThumbColors = new ColorStateList((int[][])states, colors);
        }
        this.mPaint.setStrokeCap(this.mTrackCap);
        this.buildShadow();
        this.invalidate();
    }

    @Override
    public void onThemeChanged(ThemeManager.OnThemeChangedEvent event) {
        int style2 = ThemeManager.getInstance().getCurrentStyle(this.mStyleId);
        if (this.mCurrentStyle != style2) {
            this.mCurrentStyle = style2;
            this.applyStyle(this.mCurrentStyle);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mStyleId != 0) {
            ThemeManager.getInstance().registerOnThemeChangedListener(this);
            this.onThemeChanged(null);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        RippleManager.cancelRipple(this);
        if (this.mStyleId != 0) {
            ThemeManager.getInstance().unregisterOnThemeChangedListener(this);
        }
    }

    public void setBackgroundDrawable(Drawable drawable) {
        Drawable background = this.getBackground();
        if (background instanceof RippleDrawable && !(drawable instanceof RippleDrawable)) {
            ((RippleDrawable)background).setBackgroundDrawable(drawable);
        } else {
            super.setBackgroundDrawable(drawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RippleManager getRippleManager() {
        if (this.mRippleManager != null) return this.mRippleManager;
        Class<RippleManager> clazz = RippleManager.class;
        synchronized (RippleManager.class) {
            if (this.mRippleManager != null) return this.mRippleManager;
            this.mRippleManager = new RippleManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mRippleManager;
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        RippleManager rippleManager = this.getRippleManager();
        if (l == rippleManager) {
            super.setOnClickListener(l);
        } else {
            rippleManager.setOnClickListener(l);
            this.setOnClickListener(rippleManager);
        }
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    public void setChecked(boolean checked) {
        float desPos;
        if (this.mChecked != checked) {
            this.mChecked = checked;
            if (this.mOnCheckedChangeListener != null) {
                this.mOnCheckedChangeListener.onCheckedChanged(this, this.mChecked);
            }
        }
        float f = desPos = this.mChecked ? 1.0f : 0.0f;
        if (this.mThumbPosition != desPos) {
            this.startAnimation();
        }
    }

    public void setCheckedImmediately(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            if (this.mOnCheckedChangeListener != null) {
                this.mOnCheckedChangeListener.onCheckedChanged(this, this.mChecked);
            }
        }
        this.mThumbPosition = this.mChecked ? 1.0f : 0.0f;
        this.invalidate();
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        if (this.isEnabled()) {
            this.setChecked(!this.mChecked);
        }
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        boolean rtl;
        boolean bl = rtl = layoutDirection == 1;
        if (this.mIsRtl != rtl) {
            this.mIsRtl = rtl;
            this.invalidate();
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        super.onTouchEvent(event);
        this.getRippleManager().onTouchEvent(event);
        float x = event.getX();
        if (this.mIsRtl) {
            x = 2.0f * this.mDrawRect.centerX() - x;
        }
        switch (event.getAction()) {
            case 0: {
                this.mStartX = this.mMemoX = x;
                this.mStartTime = SystemClock.uptimeMillis();
                break;
            }
            case 2: {
                float offset = (x - this.mMemoX) / (this.mDrawRect.width() - (float)(this.mThumbRadius * 2));
                this.mThumbPosition = Math.min(1.0f, Math.max(0.0f, this.mThumbPosition + offset));
                this.mMemoX = x;
                this.invalidate();
                break;
            }
            case 1: {
                float velocity = (x - this.mStartX) / (float)(SystemClock.uptimeMillis() - this.mStartTime) * 1000.0f;
                if (Math.abs(velocity) >= this.mFlingVelocity) {
                    this.setChecked(velocity > 0.0f);
                    break;
                }
                if (!this.mChecked && this.mThumbPosition < 0.1f || this.mChecked && this.mThumbPosition > 0.9f) {
                    this.toggle();
                    break;
                }
                this.setChecked(this.mThumbPosition > 0.5f);
                break;
            }
            case 3: {
                this.setChecked(this.mThumbPosition > 0.5f);
            }
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        switch (widthMode) {
            case 0: {
                widthSize = this.getSuggestedMinimumWidth();
                break;
            }
            case -2147483648: {
                widthSize = Math.min(widthSize, this.getSuggestedMinimumWidth());
            }
        }
        switch (heightMode) {
            case 0: {
                heightSize = this.getSuggestedMinimumHeight();
                break;
            }
            case -2147483648: {
                heightSize = Math.min(heightSize, this.getSuggestedMinimumHeight());
            }
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    public int getSuggestedMinimumWidth() {
        return this.mThumbRadius * 4 + Math.max(this.mShadowSize, this.getPaddingLeft()) + Math.max(this.mShadowSize, this.getPaddingRight());
    }

    public int getSuggestedMinimumHeight() {
        return this.mThumbRadius * 2 + Math.max(this.mShadowSize - this.mShadowOffset, this.getPaddingTop()) + Math.max(this.mShadowSize + this.mShadowOffset, this.getPaddingBottom());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mDrawRect.left = Math.max(this.mShadowSize, this.getPaddingLeft());
        this.mDrawRect.right = w - Math.max(this.mShadowSize, this.getPaddingRight());
        int height = this.mThumbRadius * 2;
        int align = this.mGravity & 0x70;
        switch (align) {
            case 48: {
                this.mDrawRect.top = Math.max(this.mShadowSize - this.mShadowOffset, this.getPaddingTop());
                this.mDrawRect.bottom = this.mDrawRect.top + (float)height;
                break;
            }
            case 80: {
                this.mDrawRect.bottom = h - Math.max(this.mShadowSize + this.mShadowOffset, this.getPaddingBottom());
                this.mDrawRect.top = this.mDrawRect.bottom - (float)height;
                break;
            }
            default: {
                this.mDrawRect.top = (float)(h - height) / 2.0f;
                this.mDrawRect.bottom = this.mDrawRect.top + (float)height;
            }
        }
    }

    private int getTrackColor(boolean checked) {
        this.mTempStates[0] = this.isEnabled() ? 16842910 : -16842910;
        this.mTempStates[1] = checked ? 0x10100A0 : -16842912;
        return this.mTrackColors.getColorForState(this.mTempStates, 0);
    }

    private int getThumbColor(boolean checked) {
        this.mTempStates[0] = this.isEnabled() ? 16842910 : -16842910;
        this.mTempStates[1] = checked ? 0x10100A0 : -16842912;
        return this.mThumbColors.getColorForState(this.mTempStates, 0);
    }

    private void buildShadow() {
        if (this.mShadowSize <= 0) {
            return;
        }
        if (this.mShadowPaint == null) {
            this.mShadowPaint = new Paint(5);
            this.mShadowPaint.setStyle(Paint.Style.FILL);
            this.mShadowPaint.setDither(true);
        }
        float startRatio = (float)this.mThumbRadius / (float)(this.mThumbRadius + this.mShadowSize + this.mShadowOffset);
        this.mShadowPaint.setShader((Shader)new RadialGradient(0.0f, 0.0f, (float)(this.mThumbRadius + this.mShadowSize), new int[]{0x4C000000, 0x4C000000, 0}, new float[]{0.0f, startRatio, 1.0f}, Shader.TileMode.CLAMP));
        if (this.mShadowPath == null) {
            this.mShadowPath = new Path();
            this.mShadowPath.setFillType(Path.FillType.EVEN_ODD);
        } else {
            this.mShadowPath.reset();
        }
        float radius = this.mThumbRadius + this.mShadowSize;
        this.mTempRect.set(-radius, -radius, radius, radius);
        this.mShadowPath.addOval(this.mTempRect, Path.Direction.CW);
        radius = this.mThumbRadius - 1;
        this.mTempRect.set(-radius, -radius - (float)this.mShadowOffset, radius, radius - (float)this.mShadowOffset);
        this.mShadowPath.addOval(this.mTempRect, Path.Direction.CW);
    }

    private void getTrackPath(float x, float y, float radius) {
        float halfStroke = (float)this.mTrackSize / 2.0f;
        this.mTrackPath.reset();
        if (this.mTrackCap != Paint.Cap.ROUND) {
            this.mTempRect.set(x - radius + 1.0f, y - radius + 1.0f, x + radius - 1.0f, y + radius - 1.0f);
            float angle = (float)(Math.asin(halfStroke / (radius - 1.0f)) / Math.PI * 180.0);
            if (x - radius > this.mDrawRect.left) {
                this.mTrackPath.moveTo(this.mDrawRect.left, y - halfStroke);
                this.mTrackPath.arcTo(this.mTempRect, 180.0f + angle, -angle * 2.0f);
                this.mTrackPath.lineTo(this.mDrawRect.left, y + halfStroke);
                this.mTrackPath.close();
            }
            if (x + radius < this.mDrawRect.right) {
                this.mTrackPath.moveTo(this.mDrawRect.right, y - halfStroke);
                this.mTrackPath.arcTo(this.mTempRect, -angle, angle * 2.0f);
                this.mTrackPath.lineTo(this.mDrawRect.right, y + halfStroke);
                this.mTrackPath.close();
            }
        } else {
            float angle2;
            float angle = (float)(Math.asin(halfStroke / (radius - 1.0f)) / Math.PI * 180.0);
            if (x - radius > this.mDrawRect.left) {
                angle2 = (float)(Math.acos(Math.max(0.0f, (this.mDrawRect.left + halfStroke - x + radius) / halfStroke)) / Math.PI * 180.0);
                this.mTempRect.set(this.mDrawRect.left, y - halfStroke, this.mDrawRect.left + (float)this.mTrackSize, y + halfStroke);
                this.mTrackPath.arcTo(this.mTempRect, 180.0f - angle2, angle2 * 2.0f);
                this.mTempRect.set(x - radius + 1.0f, y - radius + 1.0f, x + radius - 1.0f, y + radius - 1.0f);
                this.mTrackPath.arcTo(this.mTempRect, 180.0f + angle, -angle * 2.0f);
                this.mTrackPath.close();
            }
            if (x + radius < this.mDrawRect.right) {
                angle2 = (float)Math.acos(Math.max(0.0f, (x + radius - this.mDrawRect.right + halfStroke) / halfStroke));
                this.mTrackPath.moveTo((float)((double)(this.mDrawRect.right - halfStroke) + Math.cos(angle2) * (double)halfStroke), (float)((double)y + Math.sin(angle2) * (double)halfStroke));
                angle2 = (float)((double)angle2 / Math.PI * 180.0);
                this.mTempRect.set(this.mDrawRect.right - (float)this.mTrackSize, y - halfStroke, this.mDrawRect.right, y + halfStroke);
                this.mTrackPath.arcTo(this.mTempRect, angle2, -angle2 * 2.0f);
                this.mTempRect.set(x - radius + 1.0f, y - radius + 1.0f, x + radius - 1.0f, y + radius - 1.0f);
                this.mTrackPath.arcTo(this.mTempRect, -angle, angle * 2.0f);
                this.mTrackPath.close();
            }
        }
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        float x = (this.mDrawRect.width() - (float)(this.mThumbRadius * 2)) * this.mThumbPosition + this.mDrawRect.left + (float)this.mThumbRadius;
        if (this.mIsRtl) {
            x = 2.0f * this.mDrawRect.centerX() - x;
        }
        float y = this.mDrawRect.centerY();
        this.getTrackPath(x, y, this.mThumbRadius);
        this.mPaint.setColor(ColorUtil.getMiddleColor(this.getTrackColor(false), this.getTrackColor(true), this.mThumbPosition));
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawPath(this.mTrackPath, this.mPaint);
        if (this.mShadowSize > 0) {
            int saveCount = canvas.save();
            canvas.translate(x, y + (float)this.mShadowOffset);
            canvas.drawPath(this.mShadowPath, this.mShadowPaint);
            canvas.restoreToCount(saveCount);
        }
        this.mPaint.setColor(ColorUtil.getMiddleColor(this.getThumbColor(false), this.getThumbColor(true), this.mThumbPosition));
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle(x, y, (float)this.mThumbRadius, this.mPaint);
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mStartPosition = this.mThumbPosition;
        this.mAnimDuration = (int)((float)this.mMaxAnimDuration * (this.mChecked ? 1.0f - this.mStartPosition : this.mStartPosition));
    }

    private void startAnimation() {
        if (this.getHandler() != null) {
            this.resetAnimation();
            this.mRunning = true;
            this.getHandler().postAtTime(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        } else {
            this.mThumbPosition = this.mChecked ? 1.0f : 0.0f;
        }
        this.invalidate();
    }

    private void stopAnimation() {
        this.mRunning = false;
        float f = this.mThumbPosition = this.mChecked ? 1.0f : 0.0f;
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.mUpdater);
        }
        this.invalidate();
    }

    private void update() {
        long curTime = SystemClock.uptimeMillis();
        float progress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mAnimDuration);
        float value = this.mInterpolator.getInterpolation(progress);
        float f = this.mThumbPosition = this.mChecked ? this.mStartPosition * (1.0f - value) + value : this.mStartPosition * (1.0f - value);
        if (progress == 1.0f) {
            this.stopAnimation();
        }
        if (this.mRunning) {
            if (this.getHandler() != null) {
                this.getHandler().postAtTime(this.mUpdater, SystemClock.uptimeMillis() + 16L);
            } else {
                this.stopAnimation();
            }
        }
        this.invalidate();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.checked = this.isChecked();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setChecked(ss.checked);
        this.requestLayout();
    }

    static class SavedState
    extends View.BaseSavedState {
        boolean checked;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.checked = (Boolean)in.readValue(null);
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeValue((Object)this.checked);
        }

        public String toString() {
            return "Switch.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " checked=" + this.checked + "}";
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(Switch var1, boolean var2);
    }
}

