/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.util;

import android.annotation.SuppressLint;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AutoCompleteTextView;
import android.widget.TextView;
import com.rey.material.R;
import com.rey.material.util.TypefaceUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class ViewUtil {
    public static final long FRAME_DURATION = 16L;
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);

    @SuppressLint(value={"NewApi"})
    public static int generateViewId() {
        if (Build.VERSION.SDK_INT < 17) {
            int newValue;
            int result;
            do {
                if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
                newValue = 1;
            } while (!sNextGeneratedId.compareAndSet(result, newValue));
            return result;
        }
        return View.generateViewId();
    }

    public static boolean hasState(int[] states, int state) {
        if (states == null) {
            return false;
        }
        for (int state1 : states) {
            if (state1 != state) continue;
            return true;
        }
        return false;
    }

    public static void setBackground(View v, Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 16) {
            v.setBackground(drawable);
        } else {
            v.setBackgroundDrawable(drawable);
        }
    }

    public static void applyStyle(View v, int resId) {
        ViewUtil.applyStyle(v, null, 0, resId);
    }

    public static void applyStyle(View v, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = v.getContext().obtainStyledAttributes(attrs, R.styleable.View, defStyleAttr, defStyleRes);
        int leftPadding = -1;
        int topPadding = -1;
        int rightPadding = -1;
        int bottomPadding = -1;
        int startPadding = Integer.MIN_VALUE;
        int endPadding = Integer.MIN_VALUE;
        int padding = -1;
        boolean startPaddingDefined = false;
        boolean endPaddingDefined = false;
        boolean leftPaddingDefined = false;
        boolean rightPaddingDefined = false;
        int count = a.getIndexCount();
        block42: for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.View_android_background) {
                Drawable bg = a.getDrawable(attr2);
                ViewUtil.setBackground(v, bg);
                continue;
            }
            if (attr2 == R.styleable.View_android_backgroundTint) {
                if (Build.VERSION.SDK_INT < 21) continue;
                v.setBackgroundTintList(a.getColorStateList(attr2));
                continue;
            }
            if (attr2 == R.styleable.View_android_backgroundTintMode) {
                if (Build.VERSION.SDK_INT < 21) continue;
                int value = a.getInt(attr2, 3);
                switch (value) {
                    case 3: {
                        v.setBackgroundTintMode(PorterDuff.Mode.SRC_OVER);
                        break;
                    }
                    case 5: {
                        v.setBackgroundTintMode(PorterDuff.Mode.SRC_IN);
                        break;
                    }
                    case 9: {
                        v.setBackgroundTintMode(PorterDuff.Mode.SRC_ATOP);
                        break;
                    }
                    case 14: {
                        v.setBackgroundTintMode(PorterDuff.Mode.MULTIPLY);
                        break;
                    }
                    case 15: {
                        v.setBackgroundTintMode(PorterDuff.Mode.SCREEN);
                        break;
                    }
                    case 16: {
                        v.setBackgroundTintMode(PorterDuff.Mode.ADD);
                    }
                }
                continue;
            }
            if (attr2 == R.styleable.View_android_elevation) {
                if (Build.VERSION.SDK_INT < 21) continue;
                v.setElevation((float)a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.View_android_padding) {
                padding = a.getDimensionPixelSize(attr2, -1);
                leftPaddingDefined = true;
                rightPaddingDefined = true;
                continue;
            }
            if (attr2 == R.styleable.View_android_paddingLeft) {
                leftPadding = a.getDimensionPixelSize(attr2, -1);
                leftPaddingDefined = true;
                continue;
            }
            if (attr2 == R.styleable.View_android_paddingTop) {
                topPadding = a.getDimensionPixelSize(attr2, -1);
                continue;
            }
            if (attr2 == R.styleable.View_android_paddingRight) {
                rightPadding = a.getDimensionPixelSize(attr2, -1);
                rightPaddingDefined = true;
                continue;
            }
            if (attr2 == R.styleable.View_android_paddingBottom) {
                bottomPadding = a.getDimensionPixelSize(attr2, -1);
                continue;
            }
            if (attr2 == R.styleable.View_android_paddingStart) {
                if (Build.VERSION.SDK_INT < 17) continue;
                startPadding = a.getDimensionPixelSize(attr2, Integer.MIN_VALUE);
                startPaddingDefined = startPadding != Integer.MIN_VALUE;
                continue;
            }
            if (attr2 == R.styleable.View_android_paddingEnd) {
                if (Build.VERSION.SDK_INT < 17) continue;
                endPadding = a.getDimensionPixelSize(attr2, Integer.MIN_VALUE);
                endPaddingDefined = endPadding != Integer.MIN_VALUE;
                continue;
            }
            if (attr2 == R.styleable.View_android_fadeScrollbars) {
                v.setScrollbarFadingEnabled(a.getBoolean(attr2, true));
                continue;
            }
            if (attr2 == R.styleable.View_android_fadingEdgeLength) {
                v.setFadingEdgeLength(a.getDimensionPixelOffset(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.View_android_minHeight) {
                v.setMinimumHeight(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.View_android_minWidth) {
                v.setMinimumWidth(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.View_android_requiresFadingEdge) {
                v.setVerticalFadingEdgeEnabled(a.getBoolean(attr2, true));
                continue;
            }
            if (attr2 == R.styleable.View_android_scrollbarDefaultDelayBeforeFade) {
                if (Build.VERSION.SDK_INT < 16) continue;
                v.setScrollBarDefaultDelayBeforeFade(a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.View_android_scrollbarFadeDuration) {
                if (Build.VERSION.SDK_INT < 16) continue;
                v.setScrollBarFadeDuration(a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.View_android_scrollbarSize) {
                if (Build.VERSION.SDK_INT < 16) continue;
                v.setScrollBarSize(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.View_android_scrollbarStyle) {
                int value = a.getInteger(attr2, 0);
                switch (value) {
                    case 0: {
                        v.setScrollBarStyle(0);
                        break;
                    }
                    case 0x1000000: {
                        v.setScrollBarStyle(0x1000000);
                        break;
                    }
                    case 0x2000000: {
                        v.setScrollBarStyle(0x2000000);
                        break;
                    }
                    case 0x3000000: {
                        v.setScrollBarStyle(0x3000000);
                    }
                }
                continue;
            }
            if (attr2 == R.styleable.View_android_soundEffectsEnabled) {
                v.setSoundEffectsEnabled(a.getBoolean(attr2, true));
                continue;
            }
            if (attr2 == R.styleable.View_android_textAlignment) {
                if (Build.VERSION.SDK_INT < 17) continue;
                int value = a.getInteger(attr2, 0);
                switch (value) {
                    case 0: {
                        v.setTextAlignment(0);
                        break;
                    }
                    case 1: {
                        v.setTextAlignment(1);
                        break;
                    }
                    case 2: {
                        v.setTextAlignment(2);
                        break;
                    }
                    case 3: {
                        v.setTextAlignment(3);
                        break;
                    }
                    case 4: {
                        v.setTextAlignment(4);
                        break;
                    }
                    case 5: {
                        v.setTextAlignment(5);
                        break;
                    }
                    case 6: {
                        v.setTextAlignment(6);
                    }
                }
                continue;
            }
            if (attr2 == R.styleable.View_android_textDirection) {
                if (Build.VERSION.SDK_INT < 17) continue;
                int value = a.getInteger(attr2, 0);
                switch (value) {
                    case 0: {
                        v.setTextDirection(0);
                        break;
                    }
                    case 1: {
                        v.setTextDirection(1);
                        break;
                    }
                    case 2: {
                        v.setTextDirection(2);
                        break;
                    }
                    case 3: {
                        v.setTextDirection(3);
                        break;
                    }
                    case 4: {
                        v.setTextDirection(4);
                        break;
                    }
                    case 5: {
                        v.setTextDirection(5);
                    }
                }
                continue;
            }
            if (attr2 == R.styleable.View_android_visibility) {
                int value = a.getInteger(attr2, 0);
                switch (value) {
                    case 0: {
                        v.setVisibility(0);
                        break;
                    }
                    case 1: {
                        v.setVisibility(4);
                        break;
                    }
                    case 2: {
                        v.setVisibility(8);
                    }
                }
                continue;
            }
            if (attr2 != R.styleable.View_android_layoutDirection || Build.VERSION.SDK_INT < 17) continue;
            int value = a.getInteger(attr2, 0);
            switch (value) {
                case 0: {
                    v.setLayoutDirection(0);
                    continue block42;
                }
                case 1: {
                    v.setLayoutDirection(1);
                    continue block42;
                }
                case 2: {
                    v.setLayoutDirection(2);
                    continue block42;
                }
                case 3: {
                    v.setLayoutDirection(3);
                }
            }
        }
        if (padding >= 0) {
            v.setPadding(padding, padding, padding, padding);
        } else if (Build.VERSION.SDK_INT < 17) {
            if (startPaddingDefined) {
                leftPadding = startPadding;
            }
            if (endPaddingDefined) {
                rightPadding = endPadding;
            }
            v.setPadding(leftPadding >= 0 ? leftPadding : v.getPaddingLeft(), topPadding >= 0 ? topPadding : v.getPaddingTop(), rightPadding >= 0 ? rightPadding : v.getPaddingRight(), bottomPadding >= 0 ? bottomPadding : v.getPaddingBottom());
        } else {
            if (leftPaddingDefined || rightPaddingDefined) {
                v.setPadding(leftPaddingDefined ? leftPadding : v.getPaddingLeft(), topPadding >= 0 ? topPadding : v.getPaddingTop(), rightPaddingDefined ? rightPadding : v.getPaddingRight(), bottomPadding >= 0 ? bottomPadding : v.getPaddingBottom());
            }
            if (startPaddingDefined || endPaddingDefined) {
                v.setPaddingRelative(startPaddingDefined ? startPadding : v.getPaddingStart(), topPadding >= 0 ? topPadding : v.getPaddingTop(), endPaddingDefined ? endPadding : v.getPaddingEnd(), bottomPadding >= 0 ? bottomPadding : v.getPaddingBottom());
            }
        }
        a.recycle();
        if (v instanceof TextView) {
            ViewUtil.applyStyle((TextView)v, attrs, defStyleAttr, defStyleRes);
        }
    }

    public static void applyFont(TextView v, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = v.getContext().obtainStyledAttributes(attrs, new int[]{R.attr.tv_fontFamily}, defStyleAttr, defStyleRes);
        String fontFamily = a.getString(0);
        if (fontFamily != null) {
            Typeface typeface = TypefaceUtil.load(v.getContext(), fontFamily, 0);
            v.setTypeface(typeface);
        }
        a.recycle();
    }

    private static void applyStyle(TextView v, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int attr2;
        int i;
        int n;
        String fontFamily = null;
        int typefaceIndex = -1;
        int styleIndex = -1;
        int shadowColor = 0;
        float dx = 0.0f;
        float dy = 0.0f;
        float r = 0.0f;
        Drawable drawableLeft = null;
        Drawable drawableTop = null;
        Drawable drawableRight = null;
        Drawable drawableBottom = null;
        Drawable drawableStart = null;
        Drawable drawableEnd = null;
        boolean drawableDefined = false;
        boolean drawableRelativeDefined = false;
        TypedArray a = v.getContext().obtainStyledAttributes(attrs, R.styleable.TextViewAppearance, defStyleAttr, defStyleRes);
        TypedArray appearance = null;
        int ap = a.getResourceId(R.styleable.TextViewAppearance_android_textAppearance, -1);
        a.recycle();
        if (ap != -1) {
            appearance = v.getContext().obtainStyledAttributes(ap, R.styleable.TextAppearance);
        }
        if (appearance != null) {
            n = appearance.getIndexCount();
            for (i = 0; i < n; ++i) {
                attr2 = appearance.getIndex(i);
                if (attr2 == R.styleable.TextAppearance_android_textColorHighlight) {
                    v.setHighlightColor(appearance.getColor(attr2, 0));
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_textColor) {
                    v.setTextColor(appearance.getColorStateList(attr2));
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_textColorHint) {
                    v.setHintTextColor(appearance.getColorStateList(attr2));
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_textColorLink) {
                    v.setLinkTextColor(appearance.getColorStateList(attr2));
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_textSize) {
                    v.setTextSize(0, (float)appearance.getDimensionPixelSize(attr2, 0));
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_typeface) {
                    typefaceIndex = appearance.getInt(attr2, -1);
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_fontFamily) {
                    fontFamily = appearance.getString(attr2);
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_tv_fontFamily) {
                    fontFamily = appearance.getString(attr2);
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_textStyle) {
                    styleIndex = appearance.getInt(attr2, -1);
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_textAllCaps) {
                    if (Build.VERSION.SDK_INT < 14) continue;
                    v.setAllCaps(appearance.getBoolean(attr2, false));
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_shadowColor) {
                    shadowColor = appearance.getInt(attr2, 0);
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_shadowDx) {
                    dx = appearance.getFloat(attr2, 0.0f);
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_shadowDy) {
                    dy = appearance.getFloat(attr2, 0.0f);
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_shadowRadius) {
                    r = appearance.getFloat(attr2, 0.0f);
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_elegantTextHeight) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    v.setElegantTextHeight(appearance.getBoolean(attr2, false));
                    continue;
                }
                if (attr2 == R.styleable.TextAppearance_android_letterSpacing) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    v.setLetterSpacing(appearance.getFloat(attr2, 0.0f));
                    continue;
                }
                if (attr2 != R.styleable.TextAppearance_android_fontFeatureSettings || Build.VERSION.SDK_INT < 21) continue;
                v.setFontFeatureSettings(appearance.getString(attr2));
            }
            appearance.recycle();
        }
        a = v.getContext().obtainStyledAttributes(attrs, R.styleable.TextView, defStyleAttr, defStyleRes);
        n = a.getIndexCount();
        for (i = 0; i < n; ++i) {
            attr2 = a.getIndex(i);
            if (attr2 == R.styleable.TextView_android_drawableLeft) {
                drawableLeft = a.getDrawable(attr2);
                drawableDefined = true;
                continue;
            }
            if (attr2 == R.styleable.TextView_android_drawableTop) {
                drawableTop = a.getDrawable(attr2);
                drawableDefined = true;
                continue;
            }
            if (attr2 == R.styleable.TextView_android_drawableRight) {
                drawableRight = a.getDrawable(attr2);
                drawableDefined = true;
                continue;
            }
            if (attr2 == R.styleable.TextView_android_drawableBottom) {
                drawableBottom = a.getDrawable(attr2);
                drawableDefined = true;
                continue;
            }
            if (attr2 == R.styleable.TextView_android_drawableStart) {
                drawableStart = a.getDrawable(attr2);
                drawableRelativeDefined = true;
                continue;
            }
            if (attr2 == R.styleable.TextView_android_drawableEnd) {
                drawableEnd = a.getDrawable(attr2);
                drawableRelativeDefined = true;
                continue;
            }
            if (attr2 == R.styleable.TextView_android_drawablePadding) {
                v.setCompoundDrawablePadding(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_maxLines) {
                v.setMaxLines(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_maxHeight) {
                v.setMaxHeight(a.getDimensionPixelSize(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_lines) {
                v.setLines(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_height) {
                v.setHeight(a.getDimensionPixelSize(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_minLines) {
                v.setMinLines(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_minHeight) {
                v.setMinHeight(a.getDimensionPixelSize(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_maxEms) {
                v.setMaxEms(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_maxWidth) {
                v.setMaxWidth(a.getDimensionPixelSize(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_ems) {
                v.setEms(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_width) {
                v.setWidth(a.getDimensionPixelSize(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_minEms) {
                v.setMinEms(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_minWidth) {
                v.setMinWidth(a.getDimensionPixelSize(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_gravity) {
                v.setGravity(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_scrollHorizontally) {
                v.setHorizontallyScrolling(a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_includeFontPadding) {
                v.setIncludeFontPadding(a.getBoolean(attr2, true));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_cursorVisible) {
                v.setCursorVisible(a.getBoolean(attr2, true));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_textScaleX) {
                v.setTextScaleX(a.getFloat(attr2, 1.0f));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_shadowColor) {
                shadowColor = a.getInt(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TextView_android_shadowDx) {
                dx = a.getFloat(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.TextView_android_shadowDy) {
                dy = a.getFloat(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.TextView_android_shadowRadius) {
                r = a.getFloat(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.TextView_android_textColorHighlight) {
                v.setHighlightColor(a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_textColor) {
                v.setTextColor(a.getColorStateList(attr2));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_textColorHint) {
                v.setHintTextColor(a.getColorStateList(attr2));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_textColorLink) {
                v.setLinkTextColor(a.getColorStateList(attr2));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_textSize) {
                v.setTextSize(0, (float)a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_typeface) {
                typefaceIndex = a.getInt(attr2, -1);
                continue;
            }
            if (attr2 == R.styleable.TextView_android_textStyle) {
                styleIndex = a.getInt(attr2, -1);
                continue;
            }
            if (attr2 == R.styleable.TextView_android_fontFamily) {
                fontFamily = a.getString(attr2);
                continue;
            }
            if (attr2 == R.styleable.TextView_tv_fontFamily) {
                fontFamily = a.getString(attr2);
                continue;
            }
            if (attr2 == R.styleable.TextView_android_textAllCaps) {
                if (Build.VERSION.SDK_INT < 14) continue;
                v.setAllCaps(a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_elegantTextHeight) {
                if (Build.VERSION.SDK_INT < 21) continue;
                v.setElegantTextHeight(a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_letterSpacing) {
                if (Build.VERSION.SDK_INT < 21) continue;
                v.setLetterSpacing(a.getFloat(attr2, 0.0f));
                continue;
            }
            if (attr2 != R.styleable.TextView_android_fontFeatureSettings || Build.VERSION.SDK_INT < 21) continue;
            v.setFontFeatureSettings(a.getString(attr2));
        }
        a.recycle();
        if (shadowColor != 0) {
            v.setShadowLayer(r, dx, dy, shadowColor);
        }
        if (drawableDefined) {
            Drawable[] drawables = v.getCompoundDrawables();
            if (drawableStart != null) {
                drawables[0] = drawableStart;
            } else if (drawableLeft != null) {
                drawables[0] = drawableLeft;
            }
            if (drawableTop != null) {
                drawables[1] = drawableTop;
            }
            if (drawableEnd != null) {
                drawables[2] = drawableEnd;
            } else if (drawableRight != null) {
                drawables[2] = drawableRight;
            }
            if (drawableBottom != null) {
                drawables[3] = drawableBottom;
            }
            v.setCompoundDrawablesWithIntrinsicBounds(drawables[0], drawables[1], drawables[2], drawables[3]);
        }
        if (drawableRelativeDefined && Build.VERSION.SDK_INT >= 17) {
            Drawable[] drawables = v.getCompoundDrawablesRelative();
            if (drawableStart != null) {
                drawables[0] = drawableStart;
            }
            if (drawableEnd != null) {
                drawables[2] = drawableEnd;
            }
            v.setCompoundDrawablesRelativeWithIntrinsicBounds(drawables[0], drawables[1], drawables[2], drawables[3]);
        }
        Typeface tf = null;
        if (fontFamily != null && (tf = TypefaceUtil.load(v.getContext(), fontFamily, styleIndex)) != null) {
            v.setTypeface(tf);
        }
        if (tf != null) {
            switch (typefaceIndex) {
                case 1: {
                    tf = Typeface.SANS_SERIF;
                    break;
                }
                case 2: {
                    tf = Typeface.SERIF;
                    break;
                }
                case 3: {
                    tf = Typeface.MONOSPACE;
                }
            }
            v.setTypeface(tf, styleIndex);
        }
        if (v instanceof AutoCompleteTextView) {
            ViewUtil.applyStyle((AutoCompleteTextView)v, attrs, defStyleAttr, defStyleRes);
        }
    }

    private static void applyStyle(AutoCompleteTextView v, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = v.getContext().obtainStyledAttributes(attrs, R.styleable.AutoCompleteTextView, defStyleAttr, defStyleRes);
        int n = a.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.AutoCompleteTextView_android_completionHint) {
                v.setCompletionHint((CharSequence)a.getString(attr2));
                continue;
            }
            if (attr2 == R.styleable.AutoCompleteTextView_android_completionThreshold) {
                v.setThreshold(a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.AutoCompleteTextView_android_dropDownAnchor) {
                v.setDropDownAnchor(a.getResourceId(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.AutoCompleteTextView_android_dropDownHeight) {
                v.setDropDownHeight(a.getLayoutDimension(attr2, -2));
                continue;
            }
            if (attr2 == R.styleable.AutoCompleteTextView_android_dropDownWidth) {
                v.setDropDownWidth(a.getLayoutDimension(attr2, -2));
                continue;
            }
            if (attr2 == R.styleable.AutoCompleteTextView_android_dropDownHorizontalOffset) {
                v.setDropDownHorizontalOffset(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.AutoCompleteTextView_android_dropDownVerticalOffset) {
                v.setDropDownVerticalOffset(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 != R.styleable.AutoCompleteTextView_android_popupBackground) continue;
            v.setDropDownBackgroundDrawable(a.getDrawable(attr2));
        }
        a.recycle();
    }
}

