/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.util;

import android.graphics.Color;

public class ColorUtil {
    private static int getMiddleValue(int prev, int next, float factor) {
        return Math.round((float)prev + (float)(next - prev) * factor);
    }

    public static int getMiddleColor(int prevColor, int curColor, float factor) {
        if (prevColor == curColor) {
            return curColor;
        }
        if (factor == 0.0f) {
            return prevColor;
        }
        if (factor == 1.0f) {
            return curColor;
        }
        int a = ColorUtil.getMiddleValue(Color.alpha((int)prevColor), Color.alpha((int)curColor), factor);
        int r = ColorUtil.getMiddleValue(Color.red((int)prevColor), Color.red((int)curColor), factor);
        int g = ColorUtil.getMiddleValue(Color.green((int)prevColor), Color.green((int)curColor), factor);
        int b = ColorUtil.getMiddleValue(Color.blue((int)prevColor), Color.blue((int)curColor), factor);
        return Color.argb((int)a, (int)r, (int)g, (int)b);
    }

    public static int getColor(int baseColor, float alphaPercent) {
        int alpha = Math.round((float)Color.alpha((int)baseColor) * alphaPercent);
        return baseColor & 0xFFFFFF | alpha << 24;
    }
}

