/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.rey.material.R;
import com.rey.material.drawable.RippleDrawable;
import com.rey.material.util.ColorUtil;
import com.rey.material.util.ThemeUtil;
import com.rey.material.util.TypefaceUtil;
import com.rey.material.widget.RippleManager;

public class Slider
extends View {
    private RippleManager mRippleManager;
    private Paint mPaint;
    private RectF mDrawRect;
    private RectF mTempRect;
    private Path mLeftTrackPath;
    private Path mRightTrackPath;
    private Path mMarkPath;
    private int mMinValue = 0;
    private int mMaxValue = 100;
    private int mStepValue = 1;
    private boolean mDiscreteMode = false;
    private int mPrimaryColor;
    private int mSecondaryColor;
    private int mTrackSize;
    private Paint.Cap mTrackCap;
    private int mThumbBorderSize;
    private int mThumbRadius;
    private int mThumbFocusRadius;
    private float mThumbPosition;
    private Typeface mTypeface;
    private int mTextSize;
    private int mTextColor;
    private int mGravity = 17;
    private int mTravelAnimationDuration;
    private int mTransformAnimationDuration;
    private Interpolator mInterpolator;
    private int mTouchSlop;
    private PointF mMemoPoint;
    private boolean mIsDragging;
    private float mThumbCurrentRadius;
    private float mThumbFillPercent;
    private int mTextHeight;
    private int mMemoValue;
    private String mValueText;
    private ThumbRadiusAnimator mThumbRadiusAnimator;
    private ThumbStrokeAnimator mThumbStrokeAnimator;
    private ThumbMoveAnimator mThumbMoveAnimator;
    private boolean mIsRtl = false;
    private OnPositionChangeListener mOnPositionChangeListener;

    public Slider(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public Slider(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public Slider(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public Slider(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mPaint = new Paint(1);
        this.mDrawRect = new RectF();
        this.mTempRect = new RectF();
        this.mLeftTrackPath = new Path();
        this.mRightTrackPath = new Path();
        this.mThumbRadiusAnimator = new ThumbRadiusAnimator();
        this.mThumbStrokeAnimator = new ThumbStrokeAnimator();
        this.mThumbMoveAnimator = new ThumbMoveAnimator();
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mMemoPoint = new PointF();
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
    }

    public void applyStyle(int resId) {
        this.applyStyle(this.getContext(), null, 0, resId);
    }

    private void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.getRippleManager().onCreate(this, context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Slider, defStyleAttr, defStyleRes);
        this.mDiscreteMode = a.getBoolean(R.styleable.Slider_sl_discreteMode, this.mDiscreteMode);
        this.mPrimaryColor = a.getColor(R.styleable.Slider_sl_primaryColor, ThemeUtil.colorControlActivated(context, -16777216));
        this.mSecondaryColor = a.getColor(R.styleable.Slider_sl_secondaryColor, ThemeUtil.colorControlNormal(context, -16777216));
        this.mTrackSize = a.getDimensionPixelSize(R.styleable.Slider_sl_trackSize, ThemeUtil.dpToPx(context, 2));
        int cap = a.getInteger(R.styleable.Slider_sl_trackCap, 0);
        this.mTrackCap = cap == 0 ? Paint.Cap.BUTT : (cap == 1 ? Paint.Cap.ROUND : Paint.Cap.SQUARE);
        this.mThumbBorderSize = a.getDimensionPixelSize(R.styleable.Slider_sl_thumbBorderSize, ThemeUtil.dpToPx(context, 2));
        this.mThumbRadius = a.getDimensionPixelSize(R.styleable.Slider_sl_thumbRadius, ThemeUtil.dpToPx(context, 10));
        this.mThumbFocusRadius = a.getDimensionPixelSize(R.styleable.Slider_sl_thumbFocusRadius, ThemeUtil.dpToPx(context, 14));
        this.mTravelAnimationDuration = a.getInteger(R.styleable.Slider_sl_travelAnimDuration, context.getResources().getInteger(0x10E0001));
        this.mTransformAnimationDuration = a.getInteger(R.styleable.Slider_sl_travelAnimDuration, context.getResources().getInteger(0x10E0000));
        int resId = a.getResourceId(R.styleable.Slider_sl_interpolator, 0);
        this.mInterpolator = resId != 0 ? AnimationUtils.loadInterpolator((Context)context, (int)resId) : new DecelerateInterpolator();
        this.mGravity = a.getInt(R.styleable.Slider_android_gravity, 16);
        this.mMinValue = a.getInteger(R.styleable.Slider_sl_minValue, this.mMinValue);
        this.mMaxValue = a.getInteger(R.styleable.Slider_sl_maxValue, this.mMaxValue);
        this.mStepValue = a.getInteger(R.styleable.Slider_sl_stepValue, this.mStepValue);
        this.setValue(a.getInteger(R.styleable.Slider_sl_value, this.getValue()), false);
        String familyName = a.getString(R.styleable.Slider_sl_fontFamily);
        int style2 = a.getInteger(R.styleable.Slider_sl_textStyle, 0);
        this.mTypeface = TypefaceUtil.load(context, familyName, style2);
        this.mTextColor = a.getColor(R.styleable.Slider_sl_textColor, -1);
        this.mTextSize = a.getDimensionPixelSize(R.styleable.Slider_sl_textSize, context.getResources().getDimensionPixelOffset(R.dimen.abc_text_size_small_material));
        this.setEnabled(a.getBoolean(R.styleable.Slider_android_enabled, true));
        a.recycle();
        this.mPaint.setTextSize((float)this.mTextSize);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setTypeface(this.mTypeface);
        this.measureText();
    }

    private void measureText() {
        Rect temp = new Rect();
        String text = String.valueOf(this.mMaxValue);
        this.mPaint.setTextSize((float)this.mTextSize);
        float width = this.mPaint.measureText(text);
        float maxWidth = (float)((double)this.mThumbRadius * Math.sqrt(2.0) * 2.0 - (double)ThemeUtil.dpToPx(this.getContext(), 8));
        if (width > maxWidth) {
            float textSize = (float)this.mTextSize * maxWidth / width;
            this.mPaint.setTextSize(textSize);
        }
        this.mPaint.getTextBounds(text, 0, text.length(), temp);
        this.mTextHeight = temp.height();
    }

    private String getValueText() {
        int value = this.getValue();
        if (this.mValueText == null || this.mMemoValue != value) {
            this.mMemoValue = value;
            this.mValueText = String.valueOf(this.mMemoValue);
        }
        return this.mValueText;
    }

    public int getMinValue() {
        return this.mMinValue;
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public int getStepValue() {
        return this.mStepValue;
    }

    public void setValueRange(int min, int max, boolean animation) {
        if (max < min || min == this.mMinValue && max == this.mMaxValue) {
            return;
        }
        float oldValue = this.getExactValue();
        float oldPosition = this.getPosition();
        this.mMinValue = min;
        this.mMaxValue = max;
        this.setValue(oldValue, animation);
        if (this.mOnPositionChangeListener != null && oldPosition == this.getPosition() && oldValue != this.getExactValue()) {
            this.mOnPositionChangeListener.onPositionChanged(this, false, oldPosition, oldPosition, Math.round(oldValue), this.getValue());
        }
    }

    public int getValue() {
        return Math.round(this.getExactValue());
    }

    public float getExactValue() {
        return (float)(this.mMaxValue - this.mMinValue) * this.getPosition() + (float)this.mMinValue;
    }

    public float getPosition() {
        return this.mThumbMoveAnimator.isRunning() ? this.mThumbMoveAnimator.getPosition() : this.mThumbPosition;
    }

    public void setPosition(float pos, boolean animation) {
        this.setPosition(pos, animation, animation, false);
    }

    private void setPosition(float pos, boolean moveAnimation, boolean transformAnimation, boolean fromUser) {
        boolean change = this.getPosition() != pos;
        int oldValue = this.getValue();
        float oldPos = this.getPosition();
        if (!moveAnimation || !this.mThumbMoveAnimator.startAnimation(pos)) {
            this.mThumbPosition = pos;
            if (transformAnimation) {
                if (!this.mIsDragging) {
                    this.mThumbRadiusAnimator.startAnimation(this.mThumbRadius);
                }
                this.mThumbStrokeAnimator.startAnimation(pos == 0.0f ? 0 : 1);
            } else {
                this.mThumbCurrentRadius = this.mThumbRadius;
                this.mThumbFillPercent = this.mThumbPosition == 0.0f ? 0.0f : 1.0f;
                this.invalidate();
            }
        }
        int newValue = this.getValue();
        float newPos = this.getPosition();
        if (change && this.mOnPositionChangeListener != null) {
            this.mOnPositionChangeListener.onPositionChanged(this, fromUser, oldPos, newPos, oldValue, newValue);
        }
    }

    public void setValue(float value, boolean animation) {
        value = Math.min((float)this.mMaxValue, Math.max(value, (float)this.mMinValue));
        this.setPosition((value - (float)this.mMinValue) / (float)(this.mMaxValue - this.mMinValue), animation);
    }

    public void setOnPositionChangeListener(OnPositionChangeListener listener) {
        this.mOnPositionChangeListener = listener;
    }

    public void setBackgroundDrawable(Drawable drawable) {
        Drawable background = this.getBackground();
        if (background instanceof RippleDrawable && !(drawable instanceof RippleDrawable)) {
            ((RippleDrawable)background).setBackgroundDrawable(drawable);
        } else {
            super.setBackgroundDrawable(drawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RippleManager getRippleManager() {
        if (this.mRippleManager != null) return this.mRippleManager;
        Class<RippleManager> clazz = RippleManager.class;
        synchronized (RippleManager.class) {
            if (this.mRippleManager != null) return this.mRippleManager;
            this.mRippleManager = new RippleManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mRippleManager;
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        RippleManager rippleManager = this.getRippleManager();
        if (l == rippleManager) {
            super.setOnClickListener(l);
        } else {
            rippleManager.setOnClickListener(l);
            this.setOnClickListener(rippleManager);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        switch (widthMode) {
            case 0: {
                widthSize = this.getSuggestedMinimumWidth();
                break;
            }
            case -2147483648: {
                widthSize = Math.min(widthSize, this.getSuggestedMinimumWidth());
            }
        }
        switch (heightMode) {
            case 0: {
                heightSize = this.getSuggestedMinimumHeight();
                break;
            }
            case -2147483648: {
                heightSize = Math.min(heightSize, this.getSuggestedMinimumHeight());
            }
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    public int getSuggestedMinimumWidth() {
        return (this.mDiscreteMode ? (int)((double)this.mThumbRadius * Math.sqrt(2.0)) : this.mThumbFocusRadius) * 4 + this.getPaddingLeft() + this.getPaddingRight();
    }

    public int getSuggestedMinimumHeight() {
        return (this.mDiscreteMode ? (int)((double)this.mThumbRadius * (4.0 + Math.sqrt(2.0))) : this.mThumbFocusRadius * 2) + this.getPaddingTop() + this.getPaddingBottom();
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        boolean rtl;
        boolean bl = rtl = layoutDirection == 1;
        if (this.mIsRtl != rtl) {
            this.mIsRtl = rtl;
            this.invalidate();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mDrawRect.left = this.getPaddingLeft() + this.mThumbRadius;
        this.mDrawRect.right = w - this.getPaddingRight() - this.mThumbRadius;
        int align = this.mGravity & 0x70;
        if (this.mDiscreteMode) {
            int fullHeight = (int)((double)this.mThumbRadius * (4.0 + Math.sqrt(2.0)));
            int height = this.mThumbRadius * 2;
            switch (align) {
                case 48: {
                    this.mDrawRect.top = Math.max(this.getPaddingTop(), fullHeight - height);
                    this.mDrawRect.bottom = this.mDrawRect.top + (float)height;
                    break;
                }
                case 80: {
                    this.mDrawRect.bottom = h - this.getPaddingBottom();
                    this.mDrawRect.top = this.mDrawRect.bottom - (float)height;
                    break;
                }
                default: {
                    this.mDrawRect.top = Math.max((float)(h - height) / 2.0f, (float)(fullHeight - height));
                    this.mDrawRect.bottom = this.mDrawRect.top + (float)height;
                    break;
                }
            }
        } else {
            int height = this.mThumbFocusRadius * 2;
            switch (align) {
                case 48: {
                    this.mDrawRect.top = this.getPaddingTop();
                    this.mDrawRect.bottom = this.mDrawRect.top + (float)height;
                    break;
                }
                case 80: {
                    this.mDrawRect.bottom = h - this.getPaddingBottom();
                    this.mDrawRect.top = this.mDrawRect.bottom - (float)height;
                    break;
                }
                default: {
                    this.mDrawRect.top = (float)(h - height) / 2.0f;
                    this.mDrawRect.bottom = this.mDrawRect.top + (float)height;
                }
            }
        }
    }

    private boolean isThumbHit(float x, float y, float radius) {
        float cx = this.mDrawRect.width() * this.mThumbPosition + this.mDrawRect.left;
        float cy = this.mDrawRect.centerY();
        return x >= cx - radius && x <= cx + radius && y >= cy - radius && y < cy + radius;
    }

    private double distance(float x1, float y1, float x2, float y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    private float correctPosition(float position) {
        int higherValue;
        int stepOffset;
        int lowerValue;
        if (!this.mDiscreteMode) {
            return position;
        }
        int totalOffset = this.mMaxValue - this.mMinValue;
        int valueOffset = Math.round((float)totalOffset * position);
        position = valueOffset - (lowerValue = (stepOffset = valueOffset / this.mStepValue) * this.mStepValue) < (higherValue = Math.min(totalOffset, (stepOffset + 1) * this.mStepValue)) - valueOffset ? (float)lowerValue / (float)totalOffset : (float)higherValue / (float)totalOffset;
        return position;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        super.onTouchEvent(event);
        this.getRippleManager().onTouchEvent(event);
        if (!this.isEnabled()) {
            return false;
        }
        float x = event.getX();
        float y = event.getY();
        if (this.mIsRtl) {
            x = 2.0f * this.mDrawRect.centerX() - x;
        }
        switch (event.getAction()) {
            case 0: {
                this.mIsDragging = this.isThumbHit(x, y, this.mThumbRadius) && !this.mThumbMoveAnimator.isRunning();
                this.mMemoPoint.set(x, y);
                if (!this.mIsDragging) break;
                this.mThumbRadiusAnimator.startAnimation(this.mDiscreteMode ? 0 : this.mThumbFocusRadius);
                break;
            }
            case 2: {
                if (!this.mIsDragging) break;
                if (this.mDiscreteMode) {
                    float position = this.correctPosition(Math.min(1.0f, Math.max(0.0f, (x - this.mDrawRect.left) / this.mDrawRect.width())));
                    this.setPosition(position, true, true, true);
                    break;
                }
                float offset = (x - this.mMemoPoint.x) / this.mDrawRect.width();
                float position = Math.min(1.0f, Math.max(0.0f, this.mThumbPosition + offset));
                this.setPosition(position, false, true, true);
                this.mMemoPoint.x = x;
                this.invalidate();
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    this.mIsDragging = false;
                    this.setPosition(this.getPosition(), true, true, true);
                    break;
                }
                if (!(this.distance(this.mMemoPoint.x, this.mMemoPoint.y, x, y) <= (double)this.mTouchSlop)) break;
                float position = this.correctPosition(Math.min(1.0f, Math.max(0.0f, (x - this.mDrawRect.left) / this.mDrawRect.width())));
                this.setPosition(position, true, true, true);
                break;
            }
            case 3: {
                if (!this.mIsDragging) break;
                this.mIsDragging = false;
                this.setPosition(this.getPosition(), true, true, true);
            }
        }
        return true;
    }

    private void getTrackPath(float x, float y, float radius) {
        float halfStroke = (float)this.mTrackSize / 2.0f;
        this.mLeftTrackPath.reset();
        this.mRightTrackPath.reset();
        if (radius - 1.0f < halfStroke) {
            if (this.mTrackCap != Paint.Cap.ROUND) {
                if (x > this.mDrawRect.left) {
                    this.mLeftTrackPath.moveTo(this.mDrawRect.left, y - halfStroke);
                    this.mLeftTrackPath.lineTo(x, y - halfStroke);
                    this.mLeftTrackPath.lineTo(x, y + halfStroke);
                    this.mLeftTrackPath.lineTo(this.mDrawRect.left, y + halfStroke);
                    this.mLeftTrackPath.close();
                }
                if (x < this.mDrawRect.right) {
                    this.mRightTrackPath.moveTo(this.mDrawRect.right, y + halfStroke);
                    this.mRightTrackPath.lineTo(x, y + halfStroke);
                    this.mRightTrackPath.lineTo(x, y - halfStroke);
                    this.mRightTrackPath.lineTo(this.mDrawRect.right, y - halfStroke);
                    this.mRightTrackPath.close();
                }
            } else {
                if (x > this.mDrawRect.left) {
                    this.mTempRect.set(this.mDrawRect.left, y - halfStroke, this.mDrawRect.left + (float)this.mTrackSize, y + halfStroke);
                    this.mLeftTrackPath.arcTo(this.mTempRect, 90.0f, 180.0f);
                    this.mLeftTrackPath.lineTo(x, y - halfStroke);
                    this.mLeftTrackPath.lineTo(x, y + halfStroke);
                    this.mLeftTrackPath.close();
                }
                if (x < this.mDrawRect.right) {
                    this.mTempRect.set(this.mDrawRect.right - (float)this.mTrackSize, y - halfStroke, this.mDrawRect.right, y + halfStroke);
                    this.mRightTrackPath.arcTo(this.mTempRect, 270.0f, 180.0f);
                    this.mRightTrackPath.lineTo(x, y + halfStroke);
                    this.mRightTrackPath.lineTo(x, y - halfStroke);
                    this.mRightTrackPath.close();
                }
            }
        } else if (this.mTrackCap != Paint.Cap.ROUND) {
            this.mTempRect.set(x - radius + 1.0f, y - radius + 1.0f, x + radius - 1.0f, y + radius - 1.0f);
            float angle = (float)(Math.asin(halfStroke / (radius - 1.0f)) / Math.PI * 180.0);
            if (x - radius > this.mDrawRect.left) {
                this.mLeftTrackPath.moveTo(this.mDrawRect.left, y - halfStroke);
                this.mLeftTrackPath.arcTo(this.mTempRect, 180.0f + angle, -angle * 2.0f);
                this.mLeftTrackPath.lineTo(this.mDrawRect.left, y + halfStroke);
                this.mLeftTrackPath.close();
            }
            if (x + radius < this.mDrawRect.right) {
                this.mRightTrackPath.moveTo(this.mDrawRect.right, y - halfStroke);
                this.mRightTrackPath.arcTo(this.mTempRect, -angle, angle * 2.0f);
                this.mRightTrackPath.lineTo(this.mDrawRect.right, y + halfStroke);
                this.mRightTrackPath.close();
            }
        } else {
            float angle2;
            float angle = (float)(Math.asin(halfStroke / (radius - 1.0f)) / Math.PI * 180.0);
            if (x - radius > this.mDrawRect.left) {
                angle2 = (float)(Math.acos(Math.max(0.0f, (this.mDrawRect.left + halfStroke - x + radius) / halfStroke)) / Math.PI * 180.0);
                this.mTempRect.set(this.mDrawRect.left, y - halfStroke, this.mDrawRect.left + (float)this.mTrackSize, y + halfStroke);
                this.mLeftTrackPath.arcTo(this.mTempRect, 180.0f - angle2, angle2 * 2.0f);
                this.mTempRect.set(x - radius + 1.0f, y - radius + 1.0f, x + radius - 1.0f, y + radius - 1.0f);
                this.mLeftTrackPath.arcTo(this.mTempRect, 180.0f + angle, -angle * 2.0f);
                this.mLeftTrackPath.close();
            }
            if (x + radius < this.mDrawRect.right) {
                angle2 = (float)Math.acos(Math.max(0.0f, (x + radius - this.mDrawRect.right + halfStroke) / halfStroke));
                this.mRightTrackPath.moveTo((float)((double)(this.mDrawRect.right - halfStroke) + Math.cos(angle2) * (double)halfStroke), (float)((double)y + Math.sin(angle2) * (double)halfStroke));
                angle2 = (float)((double)angle2 / Math.PI * 180.0);
                this.mTempRect.set(this.mDrawRect.right - (float)this.mTrackSize, y - halfStroke, this.mDrawRect.right, y + halfStroke);
                this.mRightTrackPath.arcTo(this.mTempRect, angle2, -angle2 * 2.0f);
                this.mTempRect.set(x - radius + 1.0f, y - radius + 1.0f, x + radius - 1.0f, y + radius - 1.0f);
                this.mRightTrackPath.arcTo(this.mTempRect, -angle, angle * 2.0f);
                this.mRightTrackPath.close();
            }
        }
    }

    private Path getMarkPath(Path path, float cx, float cy, float radius, float factor) {
        if (path == null) {
            path = new Path();
        } else {
            path.reset();
        }
        float x1 = cx - radius;
        float y1 = cy;
        float x2 = cx + radius;
        float y2 = cy;
        float x3 = cx;
        float y3 = cy + radius;
        float nCx = cx;
        float nCy = cy - radius * factor;
        float angle = (float)(Math.atan2(y2 - nCy, x2 - nCx) * 180.0 / Math.PI);
        float nRadius = (float)this.distance(nCx, nCy, x1, y1);
        this.mTempRect.set(nCx - nRadius, nCy - nRadius, nCx + nRadius, nCy + nRadius);
        path.moveTo(x1, y1);
        path.arcTo(this.mTempRect, 180.0f - angle, 180.0f + angle * 2.0f);
        if (factor > 0.9f) {
            path.lineTo(x3, y3);
        } else {
            float x4 = (x2 + x3) / 2.0f;
            float y4 = (y2 + y3) / 2.0f;
            double d1 = this.distance(x2, y2, x4, y4);
            double d2 = d1 / Math.tan(Math.PI * (double)(1.0f - factor) / 4.0);
            nCx = (float)((double)x4 - Math.cos(0.7853981633974483) * d2);
            nCy = (float)((double)y4 - Math.sin(0.7853981633974483) * d2);
            angle = (float)(Math.atan2(y2 - nCy, x2 - nCx) * 180.0 / Math.PI);
            float angle2 = (float)(Math.atan2(y3 - nCy, x3 - nCx) * 180.0 / Math.PI);
            nRadius = (float)this.distance(nCx, nCy, x2, y2);
            this.mTempRect.set(nCx - nRadius, nCy - nRadius, nCx + nRadius, nCy + nRadius);
            path.arcTo(this.mTempRect, angle, angle2 - angle);
            nCx = cx * 2.0f - nCx;
            angle = (float)(Math.atan2(y3 - nCy, x3 - nCx) * 180.0 / Math.PI);
            angle2 = (float)(Math.atan2(y1 - nCy, x1 - nCx) * 180.0 / Math.PI);
            this.mTempRect.set(nCx - nRadius, nCy - nRadius, nCx + nRadius, nCy + nRadius);
            path.arcTo(this.mTempRect, angle + 0.7853982f, angle2 - angle);
        }
        path.close();
        return path;
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        float x = this.mDrawRect.width() * this.mThumbPosition + this.mDrawRect.left;
        if (this.mIsRtl) {
            x = 2.0f * this.mDrawRect.centerX() - x;
        }
        float y = this.mDrawRect.centerY();
        int filledPrimaryColor = ColorUtil.getMiddleColor(this.mSecondaryColor, this.isEnabled() ? this.mPrimaryColor : this.mSecondaryColor, this.mThumbFillPercent);
        this.getTrackPath(x, y, this.mThumbCurrentRadius);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mIsRtl ? filledPrimaryColor : this.mSecondaryColor);
        canvas.drawPath(this.mRightTrackPath, this.mPaint);
        this.mPaint.setColor(this.mIsRtl ? this.mSecondaryColor : filledPrimaryColor);
        canvas.drawPath(this.mLeftTrackPath, this.mPaint);
        this.mPaint.setColor(filledPrimaryColor);
        if (this.mDiscreteMode) {
            float radius;
            float factor = 1.0f - this.mThumbCurrentRadius / (float)this.mThumbRadius;
            if (factor > 0.0f) {
                this.mMarkPath = this.getMarkPath(this.mMarkPath, x, y, this.mThumbRadius, factor);
                this.mPaint.setStyle(Paint.Style.FILL);
                int saveCount = canvas.save();
                canvas.translate(0.0f, (float)(-this.mThumbRadius * 2) * factor);
                canvas.drawPath(this.mMarkPath, this.mPaint);
                this.mPaint.setColor(ColorUtil.getColor(this.mTextColor, factor));
                canvas.drawText(this.getValueText(), x, y + (float)this.mTextHeight / 2.0f - (float)this.mThumbRadius * factor, this.mPaint);
                canvas.restoreToCount(saveCount);
            }
            float f = radius = this.isEnabled() ? this.mThumbCurrentRadius : this.mThumbCurrentRadius - (float)this.mThumbBorderSize;
            if (radius > 0.0f) {
                this.mPaint.setColor(filledPrimaryColor);
                canvas.drawCircle(x, y, radius, this.mPaint);
            }
        } else {
            float radius;
            float f = radius = this.isEnabled() ? this.mThumbCurrentRadius : this.mThumbCurrentRadius - (float)this.mThumbBorderSize;
            if (this.mThumbFillPercent == 1.0f) {
                this.mPaint.setStyle(Paint.Style.FILL);
            } else {
                float strokeWidth = (radius - (float)this.mThumbBorderSize) * this.mThumbFillPercent + (float)this.mThumbBorderSize;
                radius -= strokeWidth / 2.0f;
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setStrokeWidth(strokeWidth);
            }
            canvas.drawCircle(x, y, radius, this.mPaint);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.position = this.getPosition();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setPosition(ss.position, false);
        this.requestLayout();
    }

    static class SavedState
    extends View.BaseSavedState {
        float position;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.position = in.readFloat();
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeFloat(this.position);
        }

        public String toString() {
            return "Slider.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " pos=" + this.position + "}";
        }
    }

    class ThumbMoveAnimator
    implements Runnable {
        boolean mRunning = false;
        long mStartTime;
        float mStartFillPercent;
        float mStartRadius;
        float mStartPosition;
        float mPosition;
        float mFillPercent;
        int mDuration;

        ThumbMoveAnimator() {
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public float getPosition() {
            return this.mPosition;
        }

        public void resetAnimation() {
            this.mStartTime = SystemClock.uptimeMillis();
            this.mStartPosition = Slider.this.mThumbPosition;
            this.mStartFillPercent = Slider.this.mThumbFillPercent;
            this.mStartRadius = Slider.this.mThumbCurrentRadius;
            this.mFillPercent = this.mPosition == 0.0f ? 0.0f : 1.0f;
            this.mDuration = Slider.this.mDiscreteMode && !Slider.this.mIsDragging ? Slider.this.mTransformAnimationDuration * 2 + Slider.this.mTravelAnimationDuration : Slider.this.mTravelAnimationDuration;
        }

        public boolean startAnimation(float position) {
            if (Slider.this.mThumbPosition == position) {
                return false;
            }
            this.mPosition = position;
            if (Slider.this.getHandler() != null) {
                this.resetAnimation();
                this.mRunning = true;
                Slider.this.getHandler().postAtTime((Runnable)this, SystemClock.uptimeMillis() + 16L);
                Slider.this.invalidate();
                return true;
            }
            Slider.this.mThumbPosition = position;
            Slider.this.invalidate();
            return false;
        }

        public void stopAnimation() {
            this.mRunning = false;
            Slider.this.mThumbCurrentRadius = Slider.this.mDiscreteMode && Slider.this.mIsDragging ? 0.0f : (float)Slider.this.mThumbRadius;
            Slider.this.mThumbFillPercent = this.mFillPercent;
            Slider.this.mThumbPosition = this.mPosition;
            if (Slider.this.getHandler() != null) {
                Slider.this.getHandler().removeCallbacks((Runnable)this);
            }
            Slider.this.invalidate();
        }

        @Override
        public void run() {
            long curTime = SystemClock.uptimeMillis();
            float progress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mDuration);
            float value = Slider.this.mInterpolator.getInterpolation(progress);
            if (Slider.this.mDiscreteMode) {
                if (Slider.this.mIsDragging) {
                    Slider.this.mThumbPosition = (this.mPosition - this.mStartPosition) * value + this.mStartPosition;
                    Slider.this.mThumbFillPercent = (this.mFillPercent - this.mStartFillPercent) * value + this.mStartFillPercent;
                } else {
                    float p1 = (float)Slider.this.mTravelAnimationDuration / (float)this.mDuration;
                    float p2 = (float)(Slider.this.mTravelAnimationDuration + Slider.this.mTransformAnimationDuration) / (float)this.mDuration;
                    if (progress < p1) {
                        value = Slider.this.mInterpolator.getInterpolation(progress / p1);
                        Slider.this.mThumbCurrentRadius = this.mStartRadius * (1.0f - value);
                        Slider.this.mThumbPosition = (this.mPosition - this.mStartPosition) * value + this.mStartPosition;
                        Slider.this.mThumbFillPercent = (this.mFillPercent - this.mStartFillPercent) * value + this.mStartFillPercent;
                    } else if (progress > p2) {
                        Slider.this.mThumbCurrentRadius = (float)Slider.this.mThumbRadius * (progress - p2) / (1.0f - p2);
                    }
                }
            } else {
                Slider.this.mThumbPosition = (this.mPosition - this.mStartPosition) * value + this.mStartPosition;
                Slider.this.mThumbFillPercent = (this.mFillPercent - this.mStartFillPercent) * value + this.mStartFillPercent;
                if ((double)progress < 0.2) {
                    Slider.this.mThumbCurrentRadius = Math.max((float)Slider.this.mThumbRadius + (float)Slider.this.mThumbBorderSize * progress * 5.0f, Slider.this.mThumbCurrentRadius);
                } else if ((double)progress >= 0.8) {
                    Slider.this.mThumbCurrentRadius = (float)Slider.this.mThumbRadius + (float)Slider.this.mThumbBorderSize * (5.0f - progress * 5.0f);
                }
            }
            if (progress == 1.0f) {
                this.stopAnimation();
            }
            if (this.mRunning) {
                if (Slider.this.getHandler() != null) {
                    Slider.this.getHandler().postAtTime((Runnable)this, SystemClock.uptimeMillis() + 16L);
                } else {
                    this.stopAnimation();
                }
            }
            Slider.this.invalidate();
        }
    }

    class ThumbStrokeAnimator
    implements Runnable {
        boolean mRunning = false;
        long mStartTime;
        float mStartFillPercent;
        int mFillPercent;

        ThumbStrokeAnimator() {
        }

        public void resetAnimation() {
            this.mStartTime = SystemClock.uptimeMillis();
            this.mStartFillPercent = Slider.this.mThumbFillPercent;
        }

        public boolean startAnimation(int fillPercent) {
            if (Slider.this.mThumbFillPercent == (float)fillPercent) {
                return false;
            }
            this.mFillPercent = fillPercent;
            if (Slider.this.getHandler() != null) {
                this.resetAnimation();
                this.mRunning = true;
                Slider.this.getHandler().postAtTime((Runnable)this, SystemClock.uptimeMillis() + 16L);
                Slider.this.invalidate();
                return true;
            }
            Slider.this.mThumbFillPercent = this.mFillPercent;
            Slider.this.invalidate();
            return false;
        }

        public void stopAnimation() {
            this.mRunning = false;
            Slider.this.mThumbFillPercent = this.mFillPercent;
            if (Slider.this.getHandler() != null) {
                Slider.this.getHandler().removeCallbacks((Runnable)this);
            }
            Slider.this.invalidate();
        }

        @Override
        public void run() {
            long curTime = SystemClock.uptimeMillis();
            float progress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)Slider.this.mTransformAnimationDuration);
            float value = Slider.this.mInterpolator.getInterpolation(progress);
            Slider.this.mThumbFillPercent = ((float)this.mFillPercent - this.mStartFillPercent) * value + this.mStartFillPercent;
            if (progress == 1.0f) {
                this.stopAnimation();
            }
            if (this.mRunning) {
                if (Slider.this.getHandler() != null) {
                    Slider.this.getHandler().postAtTime((Runnable)this, SystemClock.uptimeMillis() + 16L);
                } else {
                    this.stopAnimation();
                }
            }
            Slider.this.invalidate();
        }
    }

    class ThumbRadiusAnimator
    implements Runnable {
        boolean mRunning = false;
        long mStartTime;
        float mStartRadius;
        int mRadius;

        ThumbRadiusAnimator() {
        }

        public void resetAnimation() {
            this.mStartTime = SystemClock.uptimeMillis();
            this.mStartRadius = Slider.this.mThumbCurrentRadius;
        }

        public boolean startAnimation(int radius) {
            if (Slider.this.mThumbCurrentRadius == (float)radius) {
                return false;
            }
            this.mRadius = radius;
            if (Slider.this.getHandler() != null) {
                this.resetAnimation();
                this.mRunning = true;
                Slider.this.getHandler().postAtTime((Runnable)this, SystemClock.uptimeMillis() + 16L);
                Slider.this.invalidate();
                return true;
            }
            Slider.this.mThumbCurrentRadius = this.mRadius;
            Slider.this.invalidate();
            return false;
        }

        public void stopAnimation() {
            this.mRunning = false;
            Slider.this.mThumbCurrentRadius = this.mRadius;
            if (Slider.this.getHandler() != null) {
                Slider.this.getHandler().removeCallbacks((Runnable)this);
            }
            Slider.this.invalidate();
        }

        @Override
        public void run() {
            long curTime = SystemClock.uptimeMillis();
            float progress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)Slider.this.mTransformAnimationDuration);
            float value = Slider.this.mInterpolator.getInterpolation(progress);
            Slider.this.mThumbCurrentRadius = ((float)this.mRadius - this.mStartRadius) * value + this.mStartRadius;
            if (progress == 1.0f) {
                this.stopAnimation();
            }
            if (this.mRunning) {
                if (Slider.this.getHandler() != null) {
                    Slider.this.getHandler().postAtTime((Runnable)this, SystemClock.uptimeMillis() + 16L);
                } else {
                    this.stopAnimation();
                }
            }
            Slider.this.invalidate();
        }
    }

    public static interface OnPositionChangeListener {
        public void onPositionChanged(Slider var1, boolean var2, float var3, float var4, int var5, int var6);
    }
}

