/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import com.rey.material.R;
import com.rey.material.drawable.CircularProgressDrawable;
import com.rey.material.drawable.LinearProgressDrawable;
import com.rey.material.util.ViewUtil;

public class ProgressView
extends View {
    private boolean mAutostart;
    private boolean mCircular;
    private int mProgressId;
    public static final int MODE_DETERMINATE = 0;
    public static final int MODE_INDETERMINATE = 1;
    public static final int MODE_BUFFER = 2;
    public static final int MODE_QUERY = 3;
    private Drawable mProgressDrawable;

    public ProgressView(Context context) {
        this(context, null, 0, 0);
    }

    public ProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, 0, 0);
    }

    public ProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=16)
    public ProgressView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
    }

    public void applyStyle(int resId) {
        this.applyStyle(this.getContext(), null, 0, resId);
    }

    private void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ProgressView, defStyleAttr, defStyleRes);
        this.mAutostart = a.getBoolean(R.styleable.ProgressView_pv_autostart, true);
        this.mCircular = a.getBoolean(R.styleable.ProgressView_pv_circular, true);
        this.mProgressId = a.getResourceId(R.styleable.ProgressView_pv_progressStyle, 0);
        if (this.mProgressId == 0) {
            int n = this.mProgressId = this.mCircular ? R.style.Material_Drawable_CircularProgress : R.style.Material_Drawable_LinearProgress;
        }
        if (this.mCircular) {
            this.mProgressDrawable = new CircularProgressDrawable.Builder(context, this.mProgressId).build();
            if (a.hasValue(R.styleable.ProgressView_pv_progressMode)) {
                ((CircularProgressDrawable)this.mProgressDrawable).setProgressMode(a.getInt(R.styleable.ProgressView_pv_progressMode, 1));
            }
        } else {
            this.mProgressDrawable = new LinearProgressDrawable.Builder(context, this.mProgressId).build();
            if (a.hasValue(R.styleable.ProgressView_pv_progressMode)) {
                ((LinearProgressDrawable)this.mProgressDrawable).setProgressMode(a.getInt(R.styleable.ProgressView_pv_progressMode, 1));
            }
        }
        if (a.hasValue(R.styleable.ProgressView_pv_progress)) {
            this.setProgress(a.getFloat(R.styleable.ProgressView_pv_progress, 0.0f));
        }
        if (a.hasValue(R.styleable.ProgressView_pv_secondaryProgress)) {
            this.setSecondaryProgress(a.getFloat(R.styleable.ProgressView_pv_secondaryProgress, 0.0f));
        }
        a.recycle();
        ViewUtil.setBackground(this, this.mProgressDrawable);
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (changedView != this) {
            return;
        }
        if (this.mAutostart) {
            if (visibility == 8 || visibility == 4) {
                this.stop();
            } else {
                this.start();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getVisibility() == 0 && this.mAutostart) {
            this.start();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mAutostart) {
            this.stop();
        }
        super.onDetachedFromWindow();
    }

    public int getProgressMode() {
        if (this.mCircular) {
            return ((CircularProgressDrawable)this.mProgressDrawable).getProgressMode();
        }
        return ((LinearProgressDrawable)this.mProgressDrawable).getProgressMode();
    }

    public float getProgress() {
        if (this.mCircular) {
            return ((CircularProgressDrawable)this.mProgressDrawable).getProgress();
        }
        return ((LinearProgressDrawable)this.mProgressDrawable).getProgress();
    }

    public float getSecondaryProgress() {
        if (this.mCircular) {
            return ((CircularProgressDrawable)this.mProgressDrawable).getSecondaryProgress();
        }
        return ((LinearProgressDrawable)this.mProgressDrawable).getSecondaryProgress();
    }

    public void setProgress(float percent) {
        if (this.mCircular) {
            ((CircularProgressDrawable)this.mProgressDrawable).setProgress(percent);
        } else {
            ((LinearProgressDrawable)this.mProgressDrawable).setProgress(percent);
        }
    }

    public void setSecondaryProgress(float percent) {
        if (this.mCircular) {
            ((CircularProgressDrawable)this.mProgressDrawable).setSecondaryProgress(percent);
        } else {
            ((LinearProgressDrawable)this.mProgressDrawable).setSecondaryProgress(percent);
        }
    }

    public void start() {
        if (this.mProgressDrawable != null) {
            ((Animatable)this.mProgressDrawable).start();
        }
    }

    public void stop() {
        if (this.mProgressDrawable != null) {
            ((Animatable)this.mProgressDrawable).stop();
        }
    }
}

