/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.rey.material.drawable.RippleDrawable;
import com.rey.material.widget.RippleManager;

public class ImageButton
extends android.widget.ImageButton {
    private RippleManager mRippleManager;

    public ImageButton(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public ImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public ImageButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public ImageButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
    }

    public void applyStyle(int resId) {
        this.applyStyle(this.getContext(), null, 0, resId);
    }

    private void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.getRippleManager().onCreate((View)this, context, attrs, defStyleAttr, defStyleRes);
    }

    public void setBackgroundDrawable(Drawable drawable) {
        Drawable background = this.getBackground();
        if (background instanceof RippleDrawable && !(drawable instanceof RippleDrawable)) {
            ((RippleDrawable)background).setBackgroundDrawable(drawable);
        } else {
            super.setBackgroundDrawable(drawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RippleManager getRippleManager() {
        if (this.mRippleManager != null) return this.mRippleManager;
        Class<RippleManager> clazz = RippleManager.class;
        synchronized (RippleManager.class) {
            if (this.mRippleManager != null) return this.mRippleManager;
            this.mRippleManager = new RippleManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mRippleManager;
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        RippleManager rippleManager = this.getRippleManager();
        if (l == rippleManager) {
            super.setOnClickListener(l);
        } else {
            rippleManager.setOnClickListener(l);
            this.setOnClickListener(rippleManager);
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        return this.getRippleManager().onTouchEvent(event) || result;
    }
}

