/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.rey.material.util.ViewUtil;

public class DividerDrawable
extends Drawable
implements Animatable {
    private boolean mRunning = false;
    private long mStartTime;
    private float mAnimProgress;
    private int mAnimDuration;
    private Paint mPaint;
    private ColorStateList mColorStateList;
    private int mHeight;
    private int mPrevColor;
    private int mCurColor;
    private boolean mEnable = true;
    private PathEffect mPathEffect;
    private Path mPath;
    private boolean mInEditMode = false;
    private boolean mAnimEnable = true;
    private int mPaddingLeft;
    private int mPaddingRight;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            DividerDrawable.this.update();
        }
    };

    public DividerDrawable(int height, ColorStateList colorStateList, int animDuration) {
        this(height, 0, 0, colorStateList, animDuration);
    }

    public DividerDrawable(int height, int paddingLeft, int paddingRight, ColorStateList colorStateList, int animDuration) {
        this.mHeight = height;
        this.mPaddingLeft = paddingLeft;
        this.mPaddingRight = paddingRight;
        this.mAnimDuration = animDuration;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mHeight);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPath = new Path();
        this.mAnimEnable = false;
        this.setColor(colorStateList);
        this.mAnimEnable = true;
    }

    public void setPadding(int left, int right) {
        if (this.mPaddingLeft != left || this.mPaddingRight != right) {
            this.mPaddingLeft = left;
            this.mPaddingRight = right;
            this.invalidateSelf();
        }
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    public void setInEditMode(boolean b) {
        this.mInEditMode = b;
    }

    public void setAnimEnable(boolean b) {
        this.mAnimEnable = b;
    }

    public void setColor(ColorStateList colorStateList) {
        this.mColorStateList = colorStateList;
        this.onStateChange(this.getState());
    }

    private PathEffect getPathEffect() {
        if (this.mPathEffect == null) {
            this.mPathEffect = new DashPathEffect(new float[]{0.2f, this.mHeight * 2}, 0.0f);
        }
        return this.mPathEffect;
    }

    public void draw(Canvas canvas) {
        if (this.mHeight == 0) {
            return;
        }
        Rect bounds = this.getBounds();
        float y = bounds.bottom - this.mHeight / 2;
        if (!this.isRunning()) {
            this.mPath.reset();
            this.mPath.moveTo((float)(bounds.left + this.mPaddingLeft), y);
            this.mPath.lineTo((float)(bounds.right - this.mPaddingRight), y);
            this.mPaint.setPathEffect(this.mEnable ? null : this.getPathEffect());
            this.mPaint.setColor(this.mCurColor);
            canvas.drawPath(this.mPath, this.mPaint);
        } else {
            float centerX = (float)(bounds.right + bounds.left - this.mPaddingRight + this.mPaddingLeft) / 2.0f;
            float start = centerX * (1.0f - this.mAnimProgress) + (float)(bounds.left + this.mPaddingLeft) * this.mAnimProgress;
            float end = centerX * (1.0f - this.mAnimProgress) + (float)(bounds.right + this.mPaddingRight) * this.mAnimProgress;
            this.mPaint.setPathEffect(null);
            if (this.mAnimProgress < 1.0f) {
                this.mPaint.setColor(this.mPrevColor);
                this.mPath.reset();
                this.mPath.moveTo((float)(bounds.left + this.mPaddingLeft), y);
                this.mPath.lineTo(start, y);
                this.mPath.moveTo((float)(bounds.right - this.mPaddingRight), y);
                this.mPath.lineTo(end, y);
                canvas.drawPath(this.mPath, this.mPaint);
            }
            this.mPaint.setColor(this.mCurColor);
            this.mPath.reset();
            this.mPath.moveTo(start, y);
            this.mPath.lineTo(end, y);
            canvas.drawPath(this.mPath, this.mPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public boolean isStateful() {
        return true;
    }

    protected boolean onStateChange(int[] state) {
        this.mEnable = ViewUtil.hasState(state, 16842910);
        int color = this.mColorStateList.getColorForState(state, this.mCurColor);
        if (this.mCurColor != color) {
            if (!this.mInEditMode && this.mAnimEnable && this.mEnable) {
                this.mPrevColor = this.isRunning() ? this.mPrevColor : this.mCurColor;
                this.mCurColor = color;
                this.start();
            } else {
                this.mPrevColor = color;
                this.mCurColor = color;
            }
            return true;
        }
        if (!this.isRunning()) {
            this.mPrevColor = color;
        }
        return false;
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mAnimProgress = 0.0f;
    }

    public void start() {
        this.resetAnimation();
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    public void stop() {
        this.mRunning = false;
        this.unscheduleSelf(this.mUpdater);
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void scheduleSelf(Runnable what, long when) {
        this.mRunning = true;
        super.scheduleSelf(what, when);
    }

    private void update() {
        long curTime = SystemClock.uptimeMillis();
        this.mAnimProgress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mAnimDuration);
        if (this.mAnimProgress == 1.0f) {
            this.mRunning = false;
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }
}

