/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import com.rey.material.R;
import com.rey.material.drawable.RippleDrawable;
import com.rey.material.util.ThemeUtil;
import com.rey.material.widget.CheckedTextView;

@TargetApi(value=16)
public class TabPageIndicator
extends HorizontalScrollView
implements ViewPager.OnPageChangeListener,
View.OnClickListener {
    private LinearLayout mTabContainer;
    private ViewPager mViewPager;
    private int mMode;
    private int mTabPadding;
    private int mTabRippleStyle;
    private int mTextApperance;
    private int mIndicatorOffset;
    private int mIndicatorWidth;
    private int mIndicatorHeight;
    private Paint mPaint;
    public static final int MODE_SCROLL = 0;
    public static final int MODE_FIXED = 1;
    private int mSelectedPosition;
    private boolean mScrolling = false;
    private Runnable mTabAnimSelector;
    private ViewPager.OnPageChangeListener mListener;
    private DataSetObserver mObserver = new DataSetObserver(){

        public void onChanged() {
            TabPageIndicator.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            TabPageIndicator.this.notifyDataSetInvalidated();
        }
    };

    public TabPageIndicator(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public TabPageIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public TabPageIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public TabPageIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.setHorizontalScrollBarEnabled(false);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mTabContainer = new LinearLayout(context);
        this.mTabContainer.setOrientation(0);
        this.mTabContainer.setGravity(17);
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
        if (this.isInEditMode()) {
            this.addTemporaryTab();
        }
    }

    public void applyStyle(int resId) {
        this.applyStyle(this.getContext(), null, 0, resId);
    }

    private void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabPageIndicator, defStyleAttr, defStyleRes);
        this.mTabPadding = a.getDimensionPixelSize(R.styleable.TabPageIndicator_tpi_tabPadding, ThemeUtil.dpToPx(context, 12));
        this.mTabRippleStyle = a.getResourceId(R.styleable.TabPageIndicator_tpi_tabRipple, 0);
        int indicatorColor = a.getColor(R.styleable.TabPageIndicator_tpi_indicatorColor, ThemeUtil.colorAccent(context, -1));
        this.mIndicatorHeight = a.getDimensionPixelSize(R.styleable.TabPageIndicator_tpi_indicatorHeight, ThemeUtil.dpToPx(context, 2));
        this.mTextApperance = a.getResourceId(R.styleable.TabPageIndicator_android_textAppearance, 0);
        this.mMode = a.getInteger(R.styleable.TabPageIndicator_tpi_mode, 0);
        a.recycle();
        this.removeAllViews();
        if (this.mMode == 0) {
            this.addView((View)this.mTabContainer, new ViewGroup.LayoutParams(-2, -1));
            this.setFillViewport(false);
        } else if (this.mMode == 1) {
            this.addView((View)this.mTabContainer, new ViewGroup.LayoutParams(-1, -1));
            this.setFillViewport(true);
        }
        this.mPaint.setColor(indicatorColor);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mTabAnimSelector != null) {
            this.post(this.mTabAnimSelector);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mTabAnimSelector != null) {
            this.removeCallbacks(this.mTabAnimSelector);
        }
    }

    private CheckedTextView getTabView(int position) {
        return (CheckedTextView)this.mTabContainer.getChildAt(position);
    }

    private void animateToTab(int position) {
        final CheckedTextView tv = this.getTabView(position);
        if (tv == null) {
            return;
        }
        if (this.mTabAnimSelector != null) {
            this.removeCallbacks(this.mTabAnimSelector);
        }
        this.mTabAnimSelector = new Runnable(){

            @Override
            public void run() {
                if (!TabPageIndicator.this.mScrolling) {
                    TabPageIndicator.this.updateIndicator(tv.getLeft(), tv.getWidth());
                }
                TabPageIndicator.this.smoothScrollTo(tv.getLeft() - (TabPageIndicator.this.getWidth() - tv.getWidth()) / 2 + TabPageIndicator.this.getPaddingLeft(), 0);
                TabPageIndicator.this.mTabAnimSelector = null;
            }
        };
        this.post(this.mTabAnimSelector);
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    public void setViewPager(ViewPager view) {
        PagerAdapter adapter;
        if (this.mViewPager == view) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
            adapter = view.getAdapter();
            if (adapter != null) {
                adapter.unregisterDataSetObserver(this.mObserver);
            }
        }
        if ((adapter = view.getAdapter()) == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        adapter.registerDataSetObserver(this.mObserver);
        this.mViewPager = view;
        view.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.notifyDataSetChanged();
    }

    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.setCurrentItem(initialPosition);
    }

    private void updateIndicator(int offset, int width) {
        this.mIndicatorOffset = offset;
        this.mIndicatorWidth = width;
        this.invalidate();
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        int x = this.mIndicatorOffset + this.getPaddingLeft();
        canvas.drawRect((float)x, (float)(this.getHeight() - this.mIndicatorHeight), (float)(x + this.mIndicatorWidth), (float)this.getHeight(), this.mPaint);
        if (this.isInEditMode()) {
            canvas.drawRect((float)this.getPaddingLeft(), (float)(this.getHeight() - this.mIndicatorHeight), (float)(this.getPaddingLeft() + this.mTabContainer.getChildAt(0).getWidth()), (float)this.getHeight(), this.mPaint);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            this.mScrolling = false;
            CheckedTextView tv = this.getTabView(this.mSelectedPosition);
            if (tv != null) {
                this.updateIndicator(tv.getLeft(), tv.getMeasuredWidth());
            }
        } else {
            this.mScrolling = true;
        }
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mListener != null) {
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
        CheckedTextView tv_scroll = this.getTabView(position);
        CheckedTextView tv_next = this.getTabView(position + 1);
        if (tv_scroll != null && tv_next != null) {
            int width_scroll = tv_scroll.getWidth();
            int width_next = tv_next.getWidth();
            float distance = (float)(width_scroll + width_next) / 2.0f;
            int width = (int)((float)width_scroll + (float)(width_next - width_scroll) * positionOffset + 0.5f);
            int offset = (int)((float)tv_scroll.getLeft() + (float)width_scroll / 2.0f + distance * positionOffset - (float)width / 2.0f + 0.5f);
            this.updateIndicator(offset, width);
        }
    }

    public void onPageSelected(int position) {
        this.setCurrentItem(position);
        if (this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
    }

    public void onClick(View v) {
        int position = (Integer)v.getTag();
        if (position == this.mSelectedPosition && this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
        this.mViewPager.setCurrentItem(position, true);
    }

    public void setCurrentItem(int position) {
        CheckedTextView tv;
        if (this.mSelectedPosition != position && (tv = this.getTabView(this.mSelectedPosition)) != null) {
            tv.setChecked(false);
        }
        this.mSelectedPosition = position;
        tv = this.getTabView(this.mSelectedPosition);
        if (tv != null) {
            tv.setChecked(true);
        }
        this.animateToTab(position);
    }

    private void notifyDataSetChanged() {
        this.mTabContainer.removeAllViews();
        PagerAdapter adapter = this.mViewPager.getAdapter();
        int count = adapter.getCount();
        if (this.mSelectedPosition > count) {
            this.mSelectedPosition = count - 1;
        }
        for (int i = 0; i < count; ++i) {
            CharSequence title = adapter.getPageTitle(i);
            if (title == null) {
                title = "NULL";
            }
            CheckedTextView tv = new CheckedTextView(this.getContext());
            tv.setCheckMarkDrawable(null);
            tv.setText(title);
            tv.setGravity(17);
            tv.setTextAppearance(this.getContext(), this.mTextApperance);
            tv.setSingleLine(true);
            tv.setEllipsize(TextUtils.TruncateAt.END);
            tv.setOnClickListener(this);
            tv.setTag(i);
            if (this.mTabRippleStyle > 0) {
                if (Build.VERSION.SDK_INT >= 16) {
                    tv.setBackground(new RippleDrawable.Builder(this.getContext(), this.mTabRippleStyle).build());
                } else {
                    tv.setBackgroundDrawable(new RippleDrawable.Builder(this.getContext(), this.mTabRippleStyle).build());
                }
            }
            if (this.mMode == 0) {
                tv.setPadding(this.mTabPadding, 0, this.mTabPadding, 0);
                this.mTabContainer.addView((View)tv, new ViewGroup.LayoutParams(-2, -1));
                continue;
            }
            if (this.mMode != 1) continue;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -1);
            params.weight = 1.0f;
            this.mTabContainer.addView((View)tv, (ViewGroup.LayoutParams)params);
        }
        this.setCurrentItem(this.mSelectedPosition);
        this.requestLayout();
    }

    private void notifyDataSetInvalidated() {
        PagerAdapter adapter = this.mViewPager.getAdapter();
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            CheckedTextView tv = this.getTabView(i);
            CharSequence title = adapter.getPageTitle(i);
            if (title == null) {
                title = "NULL";
            }
            tv.setText(title);
        }
        this.requestLayout();
    }

    private void addTemporaryTab() {
        for (int i = 0; i < 3; ++i) {
            String title = null;
            if (i == 0) {
                title = "TAB ONE";
            } else if (i == 1) {
                title = "TAB TWO";
            } else if (i == 2) {
                title = "TAB THREE";
            }
            CheckedTextView tv = new CheckedTextView(this.getContext());
            tv.setCheckMarkDrawable(null);
            tv.setText(title);
            tv.setGravity(17);
            tv.setTextAppearance(this.getContext(), this.mTextApperance);
            tv.setSingleLine(true);
            tv.setEllipsize(TextUtils.TruncateAt.END);
            tv.setTag(i);
            tv.setChecked(i == 0);
            if (this.mMode == 0) {
                tv.setPadding(this.mTabPadding, 0, this.mTabPadding, 0);
                this.mTabContainer.addView((View)tv, new ViewGroup.LayoutParams(-2, -1));
                continue;
            }
            if (this.mMode != 1) continue;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -1);
            params.weight = 1.0f;
            this.mTabContainer.addView((View)tv, (ViewGroup.LayoutParams)params);
        }
    }
}

