/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.rey.material.widget.RippleManager;

public class TextView
extends android.widget.TextView {
    private RippleManager mRippleManager = new RippleManager();
    private OnSelectionChangedListener mOnSelectionChangedListener;

    public TextView(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public TextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public TextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public TextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mRippleManager.onCreate((View)this, context, attrs, defStyleAttr, defStyleRes);
    }

    public void setOnClickListener(View.OnClickListener l) {
        if (l == this.mRippleManager) {
            super.setOnClickListener(l);
        } else {
            this.mRippleManager.setOnClickListener(l);
            this.setOnClickListener(this.mRippleManager);
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        return this.mRippleManager.onTouchEvent(event) || result;
    }

    public void setOnSelectionChangedListener(OnSelectionChangedListener listener) {
        this.mOnSelectionChangedListener = listener;
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (this.mOnSelectionChangedListener != null) {
            this.mOnSelectionChangedListener.onSelectionChanged((View)this, selStart, selEnd);
        }
    }

    public static interface OnSelectionChangedListener {
        public void onSelectionChanged(View var1, int var2, int var3);
    }
}

