/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.rey.material.util.ViewUtil;

public class CircleDrawable
extends Drawable
implements Animatable {
    private boolean mRunning = false;
    private long mStartTime;
    private float mAnimProgress;
    private int mAnimDuration = 1000;
    private Interpolator mInInterpolator = new DecelerateInterpolator();
    private Interpolator mOutInterpolator = new DecelerateInterpolator();
    private Paint mPaint;
    private float mX;
    private float mY;
    private float mRadius;
    private boolean mVisible;
    private boolean mInEditMode = false;
    private boolean mAnimEnable = true;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            CircleDrawable.this.update();
        }
    };

    public CircleDrawable() {
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void setInEditMode(boolean b) {
        this.mInEditMode = b;
    }

    public void setAnimEnable(boolean b) {
        this.mAnimEnable = b;
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
        this.invalidateSelf();
    }

    public void setAnimDuration(int duration) {
        this.mAnimDuration = duration;
    }

    public void setInterpolator(Interpolator in, Interpolator out) {
        this.mInInterpolator = in;
        this.mOutInterpolator = out;
    }

    public boolean isStateful() {
        return true;
    }

    protected boolean onStateChange(int[] state) {
        boolean visible;
        boolean bl = visible = ViewUtil.hasState(state, 0x10100A0) || ViewUtil.hasState(state, 16842919);
        if (this.mVisible != visible) {
            this.mVisible = visible;
            if (!this.mInEditMode && this.mAnimEnable) {
                this.start();
            }
            return true;
        }
        return false;
    }

    protected void onBoundsChange(Rect bounds) {
        this.mX = bounds.exactCenterX();
        this.mY = bounds.exactCenterY();
        this.mRadius = (float)Math.min(bounds.width(), bounds.height()) / 2.0f;
    }

    public void draw(Canvas canvas) {
        if (!this.mRunning) {
            if (this.mVisible) {
                canvas.drawCircle(this.mX, this.mY, this.mRadius, this.mPaint);
            }
        } else {
            float radius = this.mVisible ? this.mInInterpolator.getInterpolation(this.mAnimProgress) * this.mRadius : (1.0f - this.mOutInterpolator.getInterpolation(this.mAnimProgress)) * this.mRadius;
            canvas.drawCircle(this.mX, this.mY, radius, this.mPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mAnimProgress = 0.0f;
    }

    public void start() {
        this.resetAnimation();
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    public void stop() {
        this.mRunning = false;
        this.unscheduleSelf(this.mUpdater);
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void scheduleSelf(Runnable what, long when) {
        this.mRunning = true;
        super.scheduleSelf(what, when);
    }

    private void update() {
        long curTime = SystemClock.uptimeMillis();
        this.mAnimProgress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mAnimDuration);
        if (this.mAnimProgress == 1.0f) {
            this.mRunning = false;
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }
}

