/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.app;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import com.rey.material.R;
import com.rey.material.app.Dialog;
import com.rey.material.util.ThemeUtil;
import com.rey.material.widget.DatePicker;
import com.rey.material.widget.YearPicker;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class DatePickerDialog
extends Dialog {
    private DatePickerLayout mDatePickerLayout;
    private float mCornerRadius;
    private OnDateChangedListener mOnDateChangedListener;

    public DatePickerDialog(Context context) {
        super(context);
    }

    public DatePickerDialog(Context context, int style2) {
        super(context, style2);
    }

    @Override
    protected void onCreate() {
        this.mDatePickerLayout = new DatePickerLayout(this.getContext());
        this.contentView((View)this.mDatePickerLayout);
    }

    @Override
    public Dialog applyStyle(int resId) {
        super.applyStyle(resId);
        if (resId == 0) {
            return this;
        }
        this.mDatePickerLayout.applyStyle(resId);
        this.layoutParams(-1, -1);
        return this;
    }

    @Override
    public Dialog layoutParams(int width, int height) {
        return super.layoutParams(-1, -1);
    }

    @Override
    public Dialog cornerRadius(float radius) {
        this.mCornerRadius = radius;
        return super.cornerRadius(radius);
    }

    public DatePickerDialog dateRange(int minDay, int minMonth, int minYear, int maxDay, int maxMonth, int maxYear) {
        this.mDatePickerLayout.setDateRange(minDay, minMonth, minYear, maxDay, maxMonth, maxYear);
        return this;
    }

    public DatePickerDialog dateRange(long minTime, long maxTime) {
        this.mDatePickerLayout.setDateRange(minTime, maxTime);
        return this;
    }

    public DatePickerDialog date(int day, int month, int year) {
        this.mDatePickerLayout.setDate(day, month, year);
        return this;
    }

    public DatePickerDialog date(long time) {
        this.mDatePickerLayout.setDate(time);
        return this;
    }

    public DatePickerDialog onDateChangedListener(OnDateChangedListener listener) {
        this.mOnDateChangedListener = listener;
        return this;
    }

    public int getDay() {
        return this.mDatePickerLayout.getDay();
    }

    public int getMonth() {
        return this.mDatePickerLayout.getMonth();
    }

    public int getYear() {
        return this.mDatePickerLayout.getYear();
    }

    public long getDate() {
        Calendar cal = this.getCalendar();
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        cal.set(5, this.getDay());
        cal.set(2, this.getMonth());
        cal.set(1, this.getYear());
        return cal.getTimeInMillis();
    }

    public Calendar getCalendar() {
        return this.mDatePickerLayout.getCalendar();
    }

    public String getFormattedDate(DateFormat formatter) {
        return this.mDatePickerLayout.getFormattedDate(formatter);
    }

    public static class Builder
    extends Dialog.Builder
    implements OnDateChangedListener {
        private int mMinDay;
        private int mMinMonth;
        private int mMinYear;
        private int mMaxDay;
        private int mMaxMonth;
        private int mMaxYear;
        private int mDay;
        private int mMonth;
        private int mYear;
        private Calendar mCalendar;
        public static final Parcelable.Creator<Builder> CREATOR = new Parcelable.Creator<Builder>(){

            public Builder createFromParcel(Parcel in) {
                return new Builder(in);
            }

            public Builder[] newArray(int size) {
                return new Builder[size];
            }
        };

        public Builder() {
            this(0);
        }

        public Builder(int styleId) {
            super(styleId);
            Calendar cal = Calendar.getInstance();
            this.mDay = cal.get(5);
            this.mMonth = cal.get(2);
            this.mYear = cal.get(1);
            this.mMinDay = this.mDay;
            this.mMinMonth = this.mMonth;
            this.mMinYear = this.mYear - 12;
            this.mMaxDay = this.mDay;
            this.mMaxMonth = this.mMonth;
            this.mMaxYear = this.mYear + 12;
        }

        public Builder(int styleId, int minDay, int minMonth, int minYear, int maxDay, int maxMonth, int maxYear, int day, int month, int year) {
            super(styleId);
            this.mMinDay = minDay;
            this.mMinMonth = minMonth;
            this.mMinYear = minYear;
            this.mMaxDay = maxDay;
            this.mMaxMonth = maxMonth;
            this.mMaxYear = maxYear;
            this.mDay = day;
            this.mMonth = month;
            this.mYear = year;
        }

        public Builder dateRange(int minDay, int minMonth, int minYear, int maxDay, int maxMonth, int maxYear) {
            this.mMinDay = minDay;
            this.mMinMonth = minMonth;
            this.mMinYear = minYear;
            this.mMaxDay = maxDay;
            this.mMaxMonth = maxMonth;
            this.mMaxYear = maxYear;
            return this;
        }

        public Builder dateRange(long minTime, long maxTime) {
            if (this.mCalendar == null) {
                this.mCalendar = Calendar.getInstance();
            }
            this.mCalendar.setTimeInMillis(minTime);
            int minDay = this.mCalendar.get(5);
            int minMonth = this.mCalendar.get(2);
            int minYear = this.mCalendar.get(1);
            this.mCalendar.setTimeInMillis(maxTime);
            int maxDay = this.mCalendar.get(5);
            int maxMonth = this.mCalendar.get(2);
            int maxYear = this.mCalendar.get(1);
            return this.dateRange(minDay, minMonth, minYear, maxDay, maxMonth, maxYear);
        }

        public Builder date(int day, int month, int year) {
            this.mDay = day;
            this.mMonth = month;
            this.mYear = year;
            return this;
        }

        public Builder date(long time) {
            if (this.mCalendar == null) {
                this.mCalendar = Calendar.getInstance();
            }
            this.mCalendar.setTimeInMillis(time);
            int day = this.mCalendar.get(5);
            int month = this.mCalendar.get(2);
            int year = this.mCalendar.get(1);
            return this.date(day, month, year);
        }

        @Override
        public Dialog.Builder contentView(int layoutId) {
            return this;
        }

        @Override
        protected Dialog onBuild(Context context, int styleId) {
            DatePickerDialog dialog = new DatePickerDialog(context, styleId);
            dialog.dateRange(this.mMinDay, this.mMinMonth, this.mMinYear, this.mMaxDay, this.mMaxMonth, this.mMaxYear).date(this.mDay, this.mMonth, this.mYear).onDateChangedListener(this);
            return dialog;
        }

        @Override
        public void onDateChanged(int oldDay, int oldMonth, int oldYear, int newDay, int newMonth, int newYear) {
            this.date(newDay, newMonth, newYear);
        }

        protected Builder(Parcel in) {
            super(in);
        }

        @Override
        protected void onReadFromParcel(Parcel in) {
            this.mMinDay = in.readInt();
            this.mMinMonth = in.readInt();
            this.mMinYear = in.readInt();
            this.mMaxDay = in.readInt();
            this.mMaxMonth = in.readInt();
            this.mMaxYear = in.readInt();
            this.mDay = in.readInt();
            this.mMonth = in.readInt();
            this.mYear = in.readInt();
        }

        @Override
        protected void onWriteToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mMinDay);
            dest.writeInt(this.mMinMonth);
            dest.writeInt(this.mMinYear);
            dest.writeInt(this.mMaxDay);
            dest.writeInt(this.mMaxMonth);
            dest.writeInt(this.mMaxYear);
            dest.writeInt(this.mDay);
            dest.writeInt(this.mMonth);
            dest.writeInt(this.mYear);
        }
    }

    private class DatePickerLayout
    extends FrameLayout
    implements DatePicker.OnDateChangedListener,
    YearPicker.OnYearChangedListener {
        private YearPicker mYearPicker;
        private DatePicker mDatePicker;
        private int mHeaderPrimaryHeight;
        private int mHeaderPrimaryColor;
        private int mHeaderSecondaryHeight;
        private int mHeaderSecondaryColor;
        private int mHeaderPrimaryTextSize;
        private int mHeaderSecondaryTextSize;
        private int mTextHeaderColor;
        private Paint mPaint;
        private int mHeaderPrimaryRealHeight;
        private int mHeaderRealWidth;
        private RectF mRect;
        private Path mHeaderSecondaryBackground;
        private int mPadding;
        private boolean mDaySelectMode;
        private boolean mMonthFirst;
        private boolean mLocationDirty;
        private String mWeekDay;
        private String mMonth;
        private String mDay;
        private String mYear;
        private float mBaseX;
        private float mWeekDayY;
        private float mMonthY;
        private float mDayY;
        private float mYearY;
        private float mFirstWidth;
        private float mCenterY;
        private float mSecondWidth;
        private static final String BASE_TEXT = "0";
        private static final String DAY_FORMAT = "%02d";

        public DatePickerLayout(Context context) {
            super(context);
            this.mDaySelectMode = true;
            this.mMonthFirst = true;
            this.mLocationDirty = true;
            this.mPaint = new Paint(1);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setTextAlign(Paint.Align.CENTER);
            this.mRect = new RectF();
            this.mHeaderSecondaryBackground = new Path();
            this.mPadding = ThemeUtil.dpToPx(context, 8);
            this.mYearPicker = new YearPicker(context);
            this.mDatePicker = new DatePicker(context);
            this.mYearPicker.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
            this.mYearPicker.setOnYearChangedListener(this);
            this.mDatePicker.setContentPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
            this.mDatePicker.setOnDateChangedListener(this);
            this.addView((View)this.mDatePicker);
            this.addView((View)this.mYearPicker);
            this.mYearPicker.setVisibility(this.mDaySelectMode ? 8 : 0);
            this.mDatePicker.setVisibility(this.mDaySelectMode ? 0 : 8);
            this.mMonthFirst = this.isMonthFirst();
            this.setWillNotDraw(false);
        }

        private boolean isMonthFirst() {
            SimpleDateFormat format = (SimpleDateFormat)SimpleDateFormat.getDateInstance(0);
            String pattern = format.toLocalizedPattern();
            return pattern.indexOf("M") < pattern.indexOf("d");
        }

        public void setDateSelectMode(boolean enable) {
            if (this.mDaySelectMode != enable) {
                this.mDaySelectMode = enable;
                if (this.mDaySelectMode) {
                    this.mDatePicker.goTo(this.mDatePicker.getMonth(), this.mDatePicker.getYear());
                    this.animOut((View)this.mYearPicker);
                    this.animIn((View)this.mDatePicker);
                } else {
                    this.mYearPicker.goTo(this.mYearPicker.getYear());
                    this.animOut((View)this.mDatePicker);
                    this.animIn((View)this.mYearPicker);
                }
                this.invalidate(0, 0, this.mHeaderRealWidth, this.mHeaderPrimaryRealHeight + this.mHeaderSecondaryHeight);
            }
        }

        private void animOut(final View v) {
            AlphaAnimation anim = new AlphaAnimation(1.0f, 0.0f);
            anim.setDuration((long)this.getContext().getResources().getInteger(0x10E0001));
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    v.setVisibility(8);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            v.startAnimation((Animation)anim);
        }

        private void animIn(final View v) {
            AlphaAnimation anim = new AlphaAnimation(0.0f, 1.0f);
            anim.setDuration((long)this.getContext().getResources().getInteger(0x10E0001));
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    v.setVisibility(0);
                }

                public void onAnimationEnd(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            v.startAnimation((Animation)anim);
        }

        public void applyStyle(int resId) {
            this.mYearPicker.applyStyle(resId);
            this.mDatePicker.applyStyle(resId);
            Context context = this.getContext();
            TypedArray a = context.obtainStyledAttributes(resId, R.styleable.DatePickerDialog);
            this.mHeaderPrimaryHeight = a.getDimensionPixelOffset(R.styleable.DatePickerDialog_dp_headerPrimaryHeight, ThemeUtil.dpToPx(context, 144));
            this.mHeaderSecondaryHeight = a.getDimensionPixelSize(R.styleable.DatePickerDialog_dp_headerSecondaryHeight, ThemeUtil.dpToPx(context, 32));
            this.mHeaderPrimaryColor = a.getColor(R.styleable.DatePickerDialog_dp_headerPrimaryColor, this.mDatePicker.getSelectionColor());
            this.mHeaderSecondaryColor = a.getColor(R.styleable.DatePickerDialog_dp_headerSecondaryColor, this.mHeaderPrimaryColor);
            this.mHeaderPrimaryTextSize = a.getDimensionPixelSize(R.styleable.DatePickerDialog_dp_headerPrimaryTextSize, context.getResources().getDimensionPixelOffset(R.dimen.abc_text_size_display_2_material));
            this.mHeaderSecondaryTextSize = a.getDimensionPixelSize(R.styleable.DatePickerDialog_dp_headerSecondaryTextSize, context.getResources().getDimensionPixelOffset(R.dimen.abc_text_size_headline_material));
            this.mTextHeaderColor = a.getColor(R.styleable.DatePickerDialog_dp_textHeaderColor, -16777216);
            a.recycle();
            this.mPaint.setTypeface(this.mDatePicker.getTypeface());
        }

        public void setDateRange(int minDay, int minMonth, int minYear, int maxDay, int maxMonth, int maxYear) {
            this.mDatePicker.setDateRange(minDay, minMonth, minYear, maxDay, maxMonth, maxYear);
            this.mYearPicker.setYearRange(minYear, maxYear);
        }

        public void setDateRange(long minTime, long maxTime) {
            Calendar cal = this.mDatePicker.getCalendar();
            cal.setTimeInMillis(minTime);
            int minDay = cal.get(5);
            int minMonth = cal.get(2);
            int minYear = cal.get(1);
            cal.setTimeInMillis(maxTime);
            int maxDay = cal.get(5);
            int maxMonth = cal.get(2);
            int maxYear = cal.get(1);
            this.setDateRange(minDay, minMonth, minYear, maxDay, maxMonth, maxYear);
        }

        public void setDate(int day, int month, int year) {
            this.mDatePicker.setDate(day, month, year);
        }

        public void setDate(long time) {
            Calendar cal = this.mDatePicker.getCalendar();
            cal.setTimeInMillis(time);
            int day = cal.get(5);
            int month = cal.get(2);
            int year = cal.get(1);
            this.mDatePicker.setDate(day, month, year);
        }

        public int getDay() {
            return this.mDatePicker.getDay();
        }

        public int getMonth() {
            return this.mDatePicker.getMonth();
        }

        public int getYear() {
            return this.mDatePicker.getYear();
        }

        public String getFormattedDate(DateFormat formatter) {
            return this.mDatePicker.getFormattedDate(formatter);
        }

        public Calendar getCalendar() {
            return this.mDatePicker.getCalendar();
        }

        @Override
        public void onYearChanged(int oldYear, int newYear) {
            if (!this.mDaySelectMode) {
                this.mDatePicker.setDate(this.mDatePicker.getDay(), this.mDatePicker.getMonth(), newYear);
            }
        }

        @Override
        public void onDateChanged(int oldDay, int oldMonth, int oldYear, int newDay, int newMonth, int newYear) {
            if (this.mDaySelectMode) {
                this.mYearPicker.setYear(newYear);
            }
            if (newDay < 0 || newMonth < 0 || newYear < 0) {
                this.mWeekDay = null;
                this.mMonth = null;
                this.mDay = null;
                this.mYear = null;
            } else {
                Calendar cal = this.mDatePicker.getCalendar();
                cal.set(1, newYear);
                cal.set(2, newMonth);
                cal.set(5, newDay);
                this.mWeekDay = cal.getDisplayName(7, 2, Locale.getDefault());
                this.mMonth = cal.getDisplayName(2, 1, Locale.getDefault());
                this.mDay = String.format(DAY_FORMAT, newDay);
                this.mYear = String.valueOf(newYear);
                if (oldMonth != newMonth || oldYear != newYear) {
                    this.mDatePicker.goTo(newMonth, newYear);
                }
            }
            this.mLocationDirty = true;
            this.invalidate(0, 0, this.mHeaderRealWidth, this.mHeaderPrimaryRealHeight + this.mHeaderSecondaryHeight);
            if (DatePickerDialog.this.mOnDateChangedListener != null) {
                DatePickerDialog.this.mOnDateChangedListener.onDateChanged(oldDay, oldMonth, oldYear, newDay, newMonth, newYear);
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            boolean isPortrait;
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            boolean bl = isPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
            if (isPortrait) {
                if (heightMode == Integer.MIN_VALUE) {
                    int ws = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000);
                    int hs = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                    this.mDatePicker.measure(ws, hs);
                    this.mYearPicker.measure(ws, ws);
                } else {
                    int height = Math.max(heightSize - this.mHeaderSecondaryHeight - this.mHeaderPrimaryHeight, this.mDatePicker.getMeasuredHeight());
                    int ws = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000);
                    int hs = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
                    this.mDatePicker.measure(ws, hs);
                    this.mYearPicker.measure(ws, hs);
                }
                this.setMeasuredDimension(widthSize, heightSize);
            } else {
                if (heightMode == Integer.MIN_VALUE) {
                    int ws = View.MeasureSpec.makeMeasureSpec((int)(widthSize / 2), (int)0x40000000);
                    int hs = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                    this.mDatePicker.measure(ws, hs);
                    this.mYearPicker.measure(ws, ws);
                } else {
                    int height = Math.max(heightSize, this.mDatePicker.getMeasuredHeight());
                    int ws = View.MeasureSpec.makeMeasureSpec((int)(widthSize / 2), (int)0x40000000);
                    int hs = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
                    this.mDatePicker.measure(ws, hs);
                    this.mYearPicker.measure(ws, hs);
                }
                this.setMeasuredDimension(widthSize, heightSize);
            }
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            boolean isPortrait;
            boolean bl = isPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
            if (isPortrait) {
                this.mHeaderRealWidth = w;
                this.mHeaderPrimaryRealHeight = h - this.mHeaderSecondaryHeight - this.mDatePicker.getMeasuredHeight();
                this.mHeaderSecondaryBackground.reset();
                if (DatePickerDialog.this.mCornerRadius == 0.0f) {
                    this.mHeaderSecondaryBackground.addRect(0.0f, 0.0f, (float)this.mHeaderRealWidth, (float)this.mHeaderSecondaryHeight, Path.Direction.CW);
                } else {
                    this.mHeaderSecondaryBackground.moveTo(0.0f, (float)this.mHeaderSecondaryHeight);
                    this.mHeaderSecondaryBackground.lineTo(0.0f, DatePickerDialog.this.mCornerRadius);
                    this.mRect.set(0.0f, 0.0f, DatePickerDialog.this.mCornerRadius * 2.0f, DatePickerDialog.this.mCornerRadius * 2.0f);
                    this.mHeaderSecondaryBackground.arcTo(this.mRect, 180.0f, 90.0f, false);
                    this.mHeaderSecondaryBackground.lineTo((float)this.mHeaderRealWidth - DatePickerDialog.this.mCornerRadius, 0.0f);
                    this.mRect.set((float)this.mHeaderRealWidth - DatePickerDialog.this.mCornerRadius * 2.0f, 0.0f, (float)this.mHeaderRealWidth, DatePickerDialog.this.mCornerRadius * 2.0f);
                    this.mHeaderSecondaryBackground.arcTo(this.mRect, 270.0f, 90.0f, false);
                    this.mHeaderSecondaryBackground.lineTo((float)this.mHeaderRealWidth, (float)this.mHeaderSecondaryHeight);
                    this.mHeaderSecondaryBackground.close();
                }
            } else {
                this.mHeaderRealWidth = w - this.mDatePicker.getMeasuredWidth();
                this.mHeaderPrimaryRealHeight = h - this.mHeaderSecondaryHeight;
                this.mHeaderSecondaryBackground.reset();
                if (DatePickerDialog.this.mCornerRadius == 0.0f) {
                    this.mHeaderSecondaryBackground.addRect(0.0f, 0.0f, (float)this.mHeaderRealWidth, (float)this.mHeaderSecondaryHeight, Path.Direction.CW);
                } else {
                    this.mHeaderSecondaryBackground.moveTo(0.0f, (float)this.mHeaderSecondaryHeight);
                    this.mHeaderSecondaryBackground.lineTo(0.0f, DatePickerDialog.this.mCornerRadius);
                    this.mRect.set(0.0f, 0.0f, DatePickerDialog.this.mCornerRadius * 2.0f, DatePickerDialog.this.mCornerRadius * 2.0f);
                    this.mHeaderSecondaryBackground.arcTo(this.mRect, 180.0f, 90.0f, false);
                    this.mHeaderSecondaryBackground.lineTo((float)this.mHeaderRealWidth, 0.0f);
                    this.mHeaderSecondaryBackground.lineTo((float)this.mHeaderRealWidth, (float)this.mHeaderSecondaryHeight);
                    this.mHeaderSecondaryBackground.close();
                }
            }
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            boolean isPortrait;
            int childLeft = 0;
            int childTop = 0;
            int childRight = right - left;
            int childBottom = bottom - top;
            boolean bl = isPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
            if (isPortrait) {
                childTop += this.mHeaderPrimaryRealHeight + this.mHeaderSecondaryHeight;
            } else {
                childLeft += this.mHeaderRealWidth;
            }
            this.mDatePicker.layout(childLeft, childTop, childRight, childBottom);
            this.mYearPicker.layout(childLeft, childTop, childRight, childBottom);
        }

        private void measureHeaderText() {
            if (!this.mLocationDirty) {
                return;
            }
            if (this.mWeekDay == null) {
                this.mLocationDirty = false;
                return;
            }
            this.mBaseX = (float)this.mHeaderRealWidth / 2.0f;
            Rect bounds = new Rect();
            this.mPaint.setTextSize((float)this.mDatePicker.getTextSize());
            this.mPaint.getTextBounds(BASE_TEXT, 0, BASE_TEXT.length(), bounds);
            int height = bounds.height();
            this.mWeekDayY = (float)(this.mHeaderSecondaryHeight + height) / 2.0f;
            this.mPaint.setTextSize((float)this.mHeaderPrimaryTextSize);
            this.mPaint.getTextBounds(BASE_TEXT, 0, BASE_TEXT.length(), bounds);
            int primaryTextHeight = bounds.height();
            this.mFirstWidth = this.mMonthFirst ? this.mPaint.measureText(this.mDay, 0, this.mDay.length()) : this.mPaint.measureText(this.mMonth, 0, this.mMonth.length());
            this.mPaint.setTextSize((float)this.mHeaderSecondaryTextSize);
            this.mPaint.getTextBounds(BASE_TEXT, 0, BASE_TEXT.length(), bounds);
            int secondaryTextHeight = bounds.height();
            this.mFirstWidth = this.mMonthFirst ? Math.max(this.mFirstWidth, this.mPaint.measureText(this.mMonth, 0, this.mMonth.length())) : Math.max(this.mFirstWidth, this.mPaint.measureText(this.mDay, 0, this.mDay.length()));
            this.mSecondWidth = this.mPaint.measureText(this.mYear, 0, this.mYear.length());
            this.mCenterY = (float)this.mHeaderSecondaryHeight + (float)(this.mHeaderPrimaryRealHeight + primaryTextHeight) / 2.0f;
            float y = ((float)(this.mHeaderPrimaryRealHeight - primaryTextHeight) / 2.0f + (float)secondaryTextHeight) / 2.0f;
            float aboveY = (float)this.mHeaderSecondaryHeight + y;
            float belowY = this.mCenterY + y;
            if (this.mMonthFirst) {
                this.mDayY = this.mCenterY;
                this.mMonthY = aboveY;
            } else {
                this.mMonthY = this.mCenterY;
                this.mDayY = aboveY;
            }
            this.mYearY = belowY;
            this.mLocationDirty = false;
        }

        public void draw(Canvas canvas) {
            super.draw(canvas);
            this.mPaint.setColor(this.mHeaderSecondaryColor);
            canvas.drawPath(this.mHeaderSecondaryBackground, this.mPaint);
            this.mPaint.setColor(this.mHeaderPrimaryColor);
            canvas.drawRect(0.0f, (float)this.mHeaderSecondaryHeight, (float)this.mHeaderRealWidth, (float)(this.mHeaderPrimaryRealHeight + this.mHeaderSecondaryHeight), this.mPaint);
            this.measureHeaderText();
            if (this.mWeekDay == null) {
                return;
            }
            this.mPaint.setTextSize((float)this.mDatePicker.getTextSize());
            this.mPaint.setColor(this.mDatePicker.getTextHighlightColor());
            canvas.drawText(this.mWeekDay, 0, this.mWeekDay.length(), this.mBaseX, this.mWeekDayY, this.mPaint);
            this.mPaint.setColor(this.mDaySelectMode ? this.mDatePicker.getTextHighlightColor() : this.mTextHeaderColor);
            this.mPaint.setTextSize((float)this.mHeaderPrimaryTextSize);
            if (this.mMonthFirst) {
                canvas.drawText(this.mDay, 0, this.mDay.length(), this.mBaseX, this.mDayY, this.mPaint);
            } else {
                canvas.drawText(this.mMonth, 0, this.mMonth.length(), this.mBaseX, this.mMonthY, this.mPaint);
            }
            this.mPaint.setTextSize((float)this.mHeaderSecondaryTextSize);
            if (this.mMonthFirst) {
                canvas.drawText(this.mMonth, 0, this.mMonth.length(), this.mBaseX, this.mMonthY, this.mPaint);
            } else {
                canvas.drawText(this.mDay, 0, this.mDay.length(), this.mBaseX, this.mDayY, this.mPaint);
            }
            this.mPaint.setColor(this.mDaySelectMode ? this.mTextHeaderColor : this.mDatePicker.getTextHighlightColor());
            canvas.drawText(this.mYear, 0, this.mYear.length(), this.mBaseX, this.mYearY, this.mPaint);
        }

        private boolean isTouched(float left, float top, float right, float bottom, float x, float y) {
            return x >= left && x <= right && y >= top && y <= bottom;
        }

        public boolean onTouchEvent(MotionEvent event) {
            boolean handled = super.onTouchEvent(event);
            if (handled) {
                return handled;
            }
            switch (event.getAction()) {
                case 0: {
                    if (this.isTouched(this.mBaseX - this.mFirstWidth / 2.0f, this.mHeaderSecondaryHeight, this.mBaseX + this.mFirstWidth / 2.0f, this.mCenterY, event.getX(), event.getY())) {
                        return !this.mDaySelectMode;
                    }
                    if (!this.isTouched(this.mBaseX - this.mSecondWidth / 2.0f, this.mCenterY, this.mBaseX + this.mSecondWidth / 2.0f, this.mHeaderSecondaryHeight + this.mHeaderPrimaryRealHeight, event.getX(), event.getY())) break;
                    return this.mDaySelectMode;
                }
                case 1: {
                    if (this.isTouched(this.mBaseX - this.mFirstWidth / 2.0f, this.mHeaderSecondaryHeight, this.mBaseX + this.mFirstWidth / 2.0f, this.mCenterY, event.getX(), event.getY())) {
                        this.setDateSelectMode(true);
                        return true;
                    }
                    if (!this.isTouched(this.mBaseX - this.mSecondWidth / 2.0f, this.mCenterY, this.mBaseX + this.mSecondWidth / 2.0f, this.mHeaderSecondaryHeight + this.mHeaderPrimaryRealHeight, event.getX(), event.getY())) break;
                    this.setDateSelectMode(false);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

