/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.bigarray.internal.booleans;

import com.github.pyknic.bigarray.BooleanImmutableArray;
import com.github.pyknic.bigarray.internal.EmptyImmutableArray;
import com.github.pyknic.bigarray.internal.booleans.BooleanLargeImmutableArray;
import com.github.pyknic.bigarray.internal.booleans.BooleanSmallImmutableArray;
import com.github.pyknic.bigarray.internal.booleans.BooleanTinyImmutableArray;
import com.github.pyknic.bigarray.internal.booleans.BooleanVeryLargeImmutableArray;
import com.github.pyknic.bigarray.internal.util.MemoryUtil;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.LinkedList;

public final class BooleanImmutableArrayBuilder
implements BooleanImmutableArray.Builder {
    private final LinkedList<ShortBuffer> buffers = new LinkedList();
    private int outer = 0;
    private int inner = 0;
    private int bit = 0;

    @Override
    public BooleanImmutableArray.Builder append(boolean value) {
        ShortBuffer current;
        if (this.outer == this.buffers.size()) {
            current = ByteBuffer.allocateDirect(0x8000000).asShortBuffer();
            this.buffers.add(current);
        } else {
            current = this.buffers.getLast();
        }
        short bitmask = current.get(this.inner);
        bitmask = (short)(bitmask | 1 << this.bit);
        current.put(this.inner, bitmask);
        if (++this.bit == 16) {
            ++this.inner;
            this.bit = 0;
        }
        if (0x4000000 == this.inner) {
            this.inner = 0;
            ++this.outer;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BooleanImmutableArray build() {
        if (this.buffers.isEmpty()) {
            return new EmptyImmutableArray();
        }
        if (this.outer == 0) {
            ShortBuffer current = this.buffers.getFirst();
            long length = this.inner * 16 + this.bit;
            if (this.inner == 0 || this.inner == 1 && this.bit == 0) {
                try {
                    BooleanTinyImmutableArray booleanTinyImmutableArray = new BooleanTinyImmutableArray(current.get(0), this.inner * 16 + this.bit);
                    return booleanTinyImmutableArray;
                }
                finally {
                    MemoryUtil.clear(current);
                }
            }
            if (this.inner < Short.MIN_VALUE) {
                try {
                    short[] array = new short[this.inner];
                    for (int i = 0; i < this.inner; ++i) {
                        array[i] = current.get(i);
                    }
                    BooleanSmallImmutableArray booleanSmallImmutableArray = new BooleanSmallImmutableArray(array, length);
                    return booleanSmallImmutableArray;
                }
                finally {
                    MemoryUtil.clear(current);
                }
            }
            this.rescaleLastBuffer();
            return new BooleanLargeImmutableArray(current, length);
        }
        this.rescaleLastBuffer();
        return new BooleanVeryLargeImmutableArray(this.bufferArray(), (this.outer * 0x4000000 + this.inner) * 16 + this.bit);
    }

    private ShortBuffer[] bufferArray() {
        return this.buffers.toArray(new ShortBuffer[this.outer + 1]);
    }

    private void rescaleLastBuffer() {
        ShortBuffer last = this.buffers.removeLast();
        if (this.inner > 0) {
            if (this.inner < Short.MAX_VALUE) {
                short[] temp = new short[this.inner];
                last.get(temp);
                MemoryUtil.clear(last);
                this.buffers.add(ShortBuffer.wrap(temp));
            } else {
                ShortBuffer temp = ShortBuffer.allocate(this.inner);
                for (int i = 0; i < this.inner; ++i) {
                    temp.put(i, last.get(i));
                }
                MemoryUtil.clear(last);
                this.buffers.add(temp);
            }
        }
    }
}

