/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.swipe.library.rx2;

import android.view.MotionEvent;
import com.github.pwittchen.swipe.library.rx2.SwipeEvent;
import com.github.pwittchen.swipe.library.rx2.SwipeListener;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;

public class Swipe {
    public static final int DEFAULT_SWIPING_THRESHOLD = 20;
    public static final int DEFAULT_SWIPED_THRESHOLD = 100;
    private final int swipingThreshold;
    private final int swipedThreshold;
    private SwipeListener swipeListener;
    private ObservableEmitter<SwipeEvent> emitter;
    private float xDown;
    private float xUp;
    private float yDown;
    private float yUp;
    private float xMove;
    private float yMove;

    public Swipe() {
        this(20, 100);
    }

    public Swipe(int swipingThreshold, int swipedThreshold) {
        this.swipingThreshold = swipingThreshold;
        this.swipedThreshold = swipedThreshold;
    }

    public void setListener(SwipeListener swipeListener) {
        this.checkNotNull(swipeListener, "swipeListener == null");
        this.swipeListener = swipeListener;
    }

    public Observable<SwipeEvent> observe() {
        this.swipeListener = this.createReactiveSwipeListener();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<SwipeEvent>(){

            public void subscribe(ObservableEmitter<SwipeEvent> emitter) throws Exception {
                Swipe.this.emitter = emitter;
            }
        });
    }

    public void dispatchTouchEvent(MotionEvent event) {
        this.checkNotNull(event, "event == null");
        switch (event.getAction()) {
            case 0: {
                this.onActionDown(event);
                break;
            }
            case 1: {
                this.onActionUp(event);
                break;
            }
            case 2: {
                this.onActionMove(event);
                break;
            }
        }
    }

    private void onActionDown(MotionEvent event) {
        this.xDown = event.getX();
        this.yDown = event.getY();
    }

    private void onActionUp(MotionEvent event) {
        boolean swipedVertically;
        this.xUp = event.getX();
        this.yUp = event.getY();
        boolean swipedHorizontally = Math.abs(this.xUp - this.xDown) > (float)this.getSwipedThreshold();
        boolean bl = swipedVertically = Math.abs(this.yUp - this.yDown) > (float)this.getSwipedThreshold();
        if (swipedHorizontally) {
            boolean swipedLeft;
            boolean swipedRight = this.xUp > this.xDown;
            boolean bl2 = swipedLeft = this.xUp < this.xDown;
            if (swipedRight) {
                this.swipeListener.onSwipedRight(event);
            }
            if (swipedLeft) {
                this.swipeListener.onSwipedLeft(event);
            }
        }
        if (swipedVertically) {
            boolean swipedUp;
            boolean swipedDown = this.yDown < this.yUp;
            boolean bl3 = swipedUp = this.yDown > this.yUp;
            if (swipedDown) {
                this.swipeListener.onSwipedDown(event);
            }
            if (swipedUp) {
                this.swipeListener.onSwipedUp(event);
            }
        }
    }

    private void onActionMove(MotionEvent event) {
        boolean isSwipingVertically;
        this.xMove = event.getX();
        this.yMove = event.getY();
        boolean isSwipingHorizontally = Math.abs(this.xMove - this.xDown) > (float)this.getSwipingThreshold();
        boolean bl = isSwipingVertically = Math.abs(this.yMove - this.yDown) > (float)this.getSwipingThreshold();
        if (isSwipingHorizontally) {
            boolean isSwipingLeft;
            boolean isSwipingRight = this.xMove > this.xDown;
            boolean bl2 = isSwipingLeft = this.xMove < this.xDown;
            if (isSwipingRight) {
                this.swipeListener.onSwipingRight(event);
            }
            if (isSwipingLeft) {
                this.swipeListener.onSwipingLeft(event);
            }
        }
        if (isSwipingVertically) {
            boolean isSwipingUp;
            boolean isSwipingDown = this.yDown < this.yMove;
            boolean bl3 = isSwipingUp = this.yDown > this.yMove;
            if (isSwipingDown) {
                this.swipeListener.onSwipingDown(event);
            }
            if (isSwipingUp) {
                this.swipeListener.onSwipingUp(event);
            }
        }
    }

    private SwipeListener createReactiveSwipeListener() {
        return new SwipeListener(){

            @Override
            public void onSwipingLeft(MotionEvent event) {
                Swipe.this.onNextSafely(SwipeEvent.SWIPING_LEFT);
            }

            @Override
            public void onSwipedLeft(MotionEvent event) {
                Swipe.this.onNextSafely(SwipeEvent.SWIPED_LEFT);
            }

            @Override
            public void onSwipingRight(MotionEvent event) {
                Swipe.this.onNextSafely(SwipeEvent.SWIPING_RIGHT);
            }

            @Override
            public void onSwipedRight(MotionEvent event) {
                Swipe.this.onNextSafely(SwipeEvent.SWIPED_RIGHT);
            }

            @Override
            public void onSwipingUp(MotionEvent event) {
                Swipe.this.onNextSafely(SwipeEvent.SWIPING_UP);
            }

            @Override
            public void onSwipedUp(MotionEvent event) {
                Swipe.this.onNextSafely(SwipeEvent.SWIPED_UP);
            }

            @Override
            public void onSwipingDown(MotionEvent event) {
                Swipe.this.onNextSafely(SwipeEvent.SWIPING_DOWN);
            }

            @Override
            public void onSwipedDown(MotionEvent event) {
                Swipe.this.onNextSafely(SwipeEvent.SWIPED_DOWN);
            }
        };
    }

    private void onNextSafely(SwipeEvent swipingLeft) {
        if (this.emitter != null) {
            this.emitter.onNext((Object)swipingLeft);
        }
    }

    private void checkNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public int getSwipingThreshold() {
        return this.swipingThreshold;
    }

    public int getSwipedThreshold() {
        return this.swipedThreshold;
    }
}

