/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.strategy;

import com.github.pwittchen.reactivenetwork.library.rx2.Preconditions;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.InternetObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.error.ErrorHandler;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;

public class SocketInternetObservingStrategy
implements InternetObservingStrategy {
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_HOST = "www.google.com";
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTTPS_PROTOCOL = "https://";

    @Override
    public String getDefaultPingHost() {
        return DEFAULT_HOST;
    }

    @Override
    public Observable<Boolean> observeInternetConnectivity(int initialIntervalInMs, int intervalInMs, String host, final int port, final int timeoutInMs, final ErrorHandler errorHandler) {
        Preconditions.checkGreaterOrEqualToZero(initialIntervalInMs, "initialIntervalInMs is not a positive number");
        Preconditions.checkGreaterThanZero(intervalInMs, "intervalInMs is not a positive number");
        this.checkGeneralPreconditions(host, port, timeoutInMs, errorHandler);
        final String adjustedHost = this.adjustHost(host);
        return Observable.interval((long)initialIntervalInMs, (long)intervalInMs, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).map((Function)new Function<Long, Boolean>(){

            public Boolean apply(@NonNull Long tick) throws Exception {
                return SocketInternetObservingStrategy.this.isConnected(adjustedHost, port, timeoutInMs, errorHandler);
            }
        }).distinctUntilChanged();
    }

    @Override
    public Single<Boolean> checkInternetConnectivity(final String host, final int port, final int timeoutInMs, final ErrorHandler errorHandler) {
        this.checkGeneralPreconditions(host, port, timeoutInMs, errorHandler);
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<Boolean>(){

            public void subscribe(@NonNull SingleEmitter<Boolean> emitter) throws Exception {
                emitter.onSuccess((Object)SocketInternetObservingStrategy.this.isConnected(host, port, timeoutInMs, errorHandler));
            }
        });
    }

    protected String adjustHost(String host) {
        if (host.startsWith(HTTP_PROTOCOL)) {
            return host.replace(HTTP_PROTOCOL, EMPTY_STRING);
        }
        if (host.startsWith(HTTPS_PROTOCOL)) {
            return host.replace(HTTPS_PROTOCOL, EMPTY_STRING);
        }
        return host;
    }

    private void checkGeneralPreconditions(String host, int port, int timeoutInMs, ErrorHandler errorHandler) {
        Preconditions.checkNotNullOrEmpty(host, "host is null or empty");
        Preconditions.checkGreaterThanZero(port, "port is not a positive number");
        Preconditions.checkGreaterThanZero(timeoutInMs, "timeoutInMs is not a positive number");
        Preconditions.checkNotNull(errorHandler, "errorHandler is null");
    }

    protected boolean isConnected(String host, int port, int timeoutInMs, ErrorHandler errorHandler) {
        Socket socket = new Socket();
        return this.isConnected(socket, host, port, timeoutInMs, errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isConnected(Socket socket, String host, int port, int timeoutInMs, ErrorHandler errorHandler) {
        boolean isConnected;
        try {
            socket.connect(new InetSocketAddress(host, port), timeoutInMs);
            isConnected = socket.isConnected();
        }
        catch (IOException e) {
            isConnected = Boolean.FALSE;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException exception) {
                errorHandler.handleError(exception, "Could not close the socket");
            }
        }
        return isConnected;
    }
}

