/*
 * Decompiled with CFR 0.152.
 */
package reactiveairplanemode.pwittchen.github.com.library;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Looper;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.util.Log;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.functions.Action;

public class ReactiveAirplaneMode {
    protected static final String INTENT_EXTRA_STATE = "state";
    private static final String LOG_TAG = "ReactiveAirplaneMode";

    private ReactiveAirplaneMode() {
    }

    public static ReactiveAirplaneMode create() {
        return new ReactiveAirplaneMode();
    }

    public Observable<Boolean> getAndObserve(Context context) {
        return this.observe(context).startWith((Object)this.isAirplaneModeOn(context));
    }

    public Observable<Boolean> observe(final Context context) {
        this.checkContextIsNotNull(context);
        final IntentFilter filter = this.createIntentFilter();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Boolean>(){

            public void subscribe(@NonNull ObservableEmitter<Boolean> emitter) throws Exception {
                final BroadcastReceiver receiver = ReactiveAirplaneMode.this.createBroadcastReceiver(emitter);
                context.registerReceiver(receiver, filter);
                ReactiveAirplaneMode.this.disposeInUiThread(new Action(){

                    public void run() throws Exception {
                        ReactiveAirplaneMode.this.tryToUnregisterReceiver(receiver, context);
                    }
                });
            }
        });
    }

    @NonNull
    protected IntentFilter createIntentFilter() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.AIRPLANE_MODE");
        return filter;
    }

    @NonNull
    protected BroadcastReceiver createBroadcastReceiver(final @NonNull ObservableEmitter<Boolean> emitter) {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                boolean isAirplaneModeOn = intent.getBooleanExtra(ReactiveAirplaneMode.INTENT_EXTRA_STATE, false);
                emitter.onNext((Object)isAirplaneModeOn);
            }
        };
    }

    private Disposable disposeInUiThread(final Action dispose) {
        return Disposables.fromAction((Action)new Action(){

            public void run() throws Exception {
                if (Looper.getMainLooper() == Looper.myLooper()) {
                    dispose.run();
                } else {
                    final Scheduler.Worker inner = AndroidSchedulers.mainThread().createWorker();
                    inner.schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                dispose.run();
                            }
                            catch (Exception exception) {
                                ReactiveAirplaneMode.this.onError("Could not unregister receiver in UI Thread", exception);
                            }
                            inner.dispose();
                        }
                    });
                }
            }
        });
    }

    protected void tryToUnregisterReceiver(BroadcastReceiver receiver, Context context) {
        try {
            context.unregisterReceiver(receiver);
        }
        catch (Exception exception) {
            this.onError("receiver was already unregistered", exception);
        }
    }

    protected void onError(String message, Exception exception) {
        Log.e((String)LOG_TAG, (String)message, (Throwable)exception);
    }

    public Single<Boolean> get(final Context context) {
        this.checkContextIsNotNull(context);
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<Boolean>(){

            public void subscribe(@NonNull SingleEmitter<Boolean> emitter) throws Exception {
                emitter.onSuccess((Object)ReactiveAirplaneMode.this.isAirplaneModeOn(context));
            }
        });
    }

    public boolean isAirplaneModeOn(Context context) {
        this.checkContextIsNotNull(context);
        String airplaneModeOnSetting = this.isAtLeastAndroidJellyBeanMr1() ? this.getAirplaneModeOnSettingGlobal() : this.getAirplaneModeOnSettingSystem();
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)airplaneModeOnSetting, (int)0) == 1;
    }

    @TargetApi(value=17)
    private String getAirplaneModeOnSettingGlobal() {
        return "airplane_mode_on";
    }

    private String getAirplaneModeOnSettingSystem() {
        return "airplane_mode_on";
    }

    protected void checkContextIsNotNull(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
    }

    private boolean isAtLeastAndroidJellyBeanMr1() {
        return Build.VERSION.SDK_INT >= 17;
    }
}

