/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.servlet.extractor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.tiles.request.attribute.AttributeExtractor;

public class SessionScopeExtractor
implements AttributeExtractor {
    private HttpServletRequest request;

    public SessionScopeExtractor(HttpServletRequest request) {
        this.request = request;
    }

    public void setValue(String name, Object value) {
        this.request.getSession().setAttribute(name, value);
    }

    public void removeValue(String name) {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
    }

    public Enumeration<String> getKeys() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return session.getAttributeNames();
        }
        return Collections.enumeration(Collections.emptySet());
    }

    public Object getValue(String key) {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return session.getAttribute(key);
        }
        return null;
    }
}

