/*
 * Decompiled with CFR 0.152.
 */
package com.github.plexpt.chatgpt;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson2.JSON;
import com.github.plexpt.chatgpt.Chatbot;
import com.github.plexpt.chatgpt.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class ChatGTP {
    public static String getInput(String prompt) {
        System.out.print(prompt);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null && !line.isEmpty()) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines.stream().collect(Collectors.joining("\n"));
    }

    public static void main(String[] args) {
        block19: {
            System.out.println("ChatGPT - A command-line interface to OpenAI's ChatGPT (https://chat.openai.com/chat)");
            System.out.println("Repo: github.com/acheong08/ChatGPT");
            System.out.println("Type '!help' to show commands");
            System.out.println("Press enter twice to submit your question.\n");
            if (FileUtil.exist((String)"config.json")) {
                String configString = FileUtil.readUtf8String((File)new File("config.json"));
                Config config = (Config)JSON.parseObject((String)configString, Config.class);
                Chatbot chatbot = new Chatbot(config, null);
                block6: while (true) {
                    String prompt;
                    if ((prompt = ChatGTP.getInput("\nYou:\n")).startsWith("!")) {
                        if (prompt.equals("!help")) {
                            System.out.println("\n!help - Show this message");
                            System.out.println("!reset - Forget the current conversation");
                            System.out.println("!refresh - Refresh the session authentication");
                            System.out.println("!rollback - Rollback the conversation by 1 message");
                            System.out.println("!config - Show the current configuration");
                            System.out.println("!exit - Exit the program");
                            continue;
                        }
                        if (prompt.equals("!reset")) {
                            chatbot.resetChat();
                            System.out.println("Chat session reset.");
                            continue;
                        }
                        if (prompt.equals("!refresh")) {
                            chatbot.refreshSession();
                            System.out.println("Session refreshed.\n");
                            continue;
                        }
                        if (prompt.equals("!rollback")) {
                            chatbot.rollbackConversation();
                            System.out.println("Chat session rolled back.");
                            continue;
                        }
                        if (prompt.equals("!exit")) break block19;
                    }
                    if (Arrays.asList(args).contains("--text")) {
                        try {
                            System.out.println("Chatbot: ");
                            String out = "text";
                            Map<String, Object> message = chatbot.getChatResponse(prompt, out);
                            System.out.println(message.get("message"));
                        }
                        catch (Exception e) {
                            System.out.println("Something went wrong!");
                            e.printStackTrace();
                            System.out.println(e);
                        }
                        continue;
                    }
                    try {
                        String[] messageParts;
                        System.out.println("Chatbot: ");
                        Map<String, Object> message = chatbot.getChatResponse(prompt, "stream");
                        String[] stringArray = messageParts = message.get("message").toString().split("\n");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (true) {
                            String[] wrappedParts;
                            if (n2 >= n) continue block6;
                            String part = stringArray[n2];
                            for (String wrappedPart : wrappedParts = part.split("\n")) {
                                System.out.println(wrappedPart);
                            }
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Something went wrong!");
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            System.out.println("Please create and populate config.json to continue");
            if (!FileUtil.exist((String)"config.json")) {
                FileUtil.writeUtf8String((String)"", (String)"config.json");
            }
        }
    }
}

