/*
 * Decompiled with CFR 0.152.
 */
package com.github.pimvoeten.aws.beanstalk;

import com.github.pimvoeten.aws.core.AbstractAwsMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkClient;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkClientBuilder;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest;

@Mojo(name="EB-UpdateEnvironment")
public class UpdateEnvironmentMojo
extends AbstractAwsMojo<ElasticBeanstalkClient> {
    private ElasticBeanstalkClient elasticBeanstalkClient;
    @Parameter(property="versionLabel", required=true)
    private String versionLabel;
    @Parameter(property="applicationName", required=true)
    private String applicationName;
    @Parameter(property="environmentName")
    private String environmentName;

    @Override
    public void doExecute() throws MojoExecutionException {
        ElasticBeanstalkClient client = this.getClient();
        this.getLog().info((CharSequence)("Updating environment to: [" + this.applicationName + ", " + this.versionLabel + "]"));
        client.updateEnvironment((UpdateEnvironmentRequest)UpdateEnvironmentRequest.builder().environmentName(this.environmentName).applicationName(this.applicationName).versionLabel(this.versionLabel).build());
        this.getLog().info((CharSequence)"Updating environment finished");
    }

    @Override
    protected ElasticBeanstalkClient getClient() {
        if (this.elasticBeanstalkClient == null) {
            this.elasticBeanstalkClient = (ElasticBeanstalkClient)((ElasticBeanstalkClientBuilder)((ElasticBeanstalkClientBuilder)ElasticBeanstalkClient.builder().credentialsProvider((AwsCredentialsProvider)this.getAwsCredentialsProviderChain())).region(this.getRegion())).build();
        }
        return this.elasticBeanstalkClient;
    }
}

