/*
 * Decompiled with CFR 0.152.
 */
package com.github.pimvoeten.aws.beanstalk;

import com.github.pimvoeten.aws.core.AbstractAwsMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkClient;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkClientBuilder;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;

@Mojo(name="EB-CreateApplicationVersion")
public class CreateApplicationVersionMojo
extends AbstractAwsMojo<ElasticBeanstalkClient> {
    private ElasticBeanstalkClient elasticBeanstalkClient;
    @Parameter(property="versionLabel", required=true)
    private String versionLabel;
    @Parameter(property="bucket", required=true)
    private String bucket;
    @Parameter(property="key", required=true)
    private String key;
    @Parameter(property="applicationName", required=true)
    private String applicationName;
    @Parameter(property="description")
    private String description;

    @Override
    public void doExecute() throws MojoExecutionException {
        ElasticBeanstalkClient client = this.getClient();
        this.getLog().info((CharSequence)("Creating new application version: [" + this.applicationName + ", " + this.versionLabel + "]"));
        client.createApplicationVersion((CreateApplicationVersionRequest)CreateApplicationVersionRequest.builder().versionLabel(this.versionLabel).autoCreateApplication(Boolean.valueOf(false)).sourceBundle((S3Location)S3Location.builder().s3Bucket(this.bucket).s3Key(this.key).build()).applicationName(this.applicationName).description(this.description).build());
        this.getLog().info((CharSequence)"Creating new application version finished");
    }

    @Override
    protected ElasticBeanstalkClient getClient() {
        if (this.elasticBeanstalkClient == null) {
            this.elasticBeanstalkClient = (ElasticBeanstalkClient)((ElasticBeanstalkClientBuilder)((ElasticBeanstalkClientBuilder)ElasticBeanstalkClient.builder().credentialsProvider((AwsCredentialsProvider)this.getAwsCredentialsProviderChain())).region(this.getRegion())).build();
        }
        return this.elasticBeanstalkClient;
    }
}

