/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.rxandroidaudio;

import android.media.AudioRecord;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public final class StreamAudioRecorder {
    public static final int DEFAULT_SAMPLE_RATE = 44100;
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final String TAG = "StreamAudioRecorder";
    private final AtomicBoolean mIsRecording = new AtomicBoolean(false);
    private ExecutorService mExecutorService;

    private StreamAudioRecorder() {
    }

    public static StreamAudioRecorder getInstance() {
        return StreamAudioRecorderHolder.INSTANCE;
    }

    public synchronized boolean start(@NonNull AudioDataCallback audioDataCallback) {
        return this.start(44100, 16, 2, 2048, audioDataCallback);
    }

    public synchronized boolean start(int sampleRate, int channelConfig, int audioFormat, int bufferSize, @NonNull AudioDataCallback audioDataCallback) {
        this.stop();
        this.mExecutorService = Executors.newSingleThreadExecutor();
        if (this.mIsRecording.compareAndSet(false, true)) {
            this.mExecutorService.execute(new AudioRecordRunnable(sampleRate, channelConfig, audioFormat, bufferSize, audioDataCallback));
            return true;
        }
        return false;
    }

    public synchronized void stop() {
        this.mIsRecording.compareAndSet(true, false);
        if (this.mExecutorService != null) {
            this.mExecutorService.shutdown();
            this.mExecutorService = null;
        }
    }

    private class AudioRecordRunnable
    implements Runnable {
        private final AudioRecord mAudioRecord;
        private final AudioDataCallback mAudioDataCallback;
        private final byte[] mByteBuffer;
        private final short[] mShortBuffer;
        private final int mByteBufferSize;
        private final int mShortBufferSize;
        private final int mAudioFormat;

        AudioRecordRunnable(int sampleRate, int channelConfig, int audioFormat, @NonNull int byteBufferSize, AudioDataCallback audioDataCallback) {
            this.mAudioFormat = audioFormat;
            int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)this.mAudioFormat);
            this.mByteBufferSize = byteBufferSize;
            this.mShortBufferSize = this.mByteBufferSize / 2;
            this.mByteBuffer = new byte[this.mByteBufferSize];
            this.mShortBuffer = new short[this.mShortBufferSize];
            this.mAudioRecord = new AudioRecord(1, sampleRate, channelConfig, audioFormat, Math.max(minBufferSize, byteBufferSize));
            this.mAudioDataCallback = audioDataCallback;
        }

        @Override
        public void run() {
            if (this.mAudioRecord.getState() == 1) {
                try {
                    this.mAudioRecord.startRecording();
                }
                catch (IllegalStateException e) {
                    Log.w((String)StreamAudioRecorder.TAG, (String)("startRecording fail: " + e.getMessage()));
                    this.mAudioDataCallback.onError();
                    return;
                }
                while (StreamAudioRecorder.this.mIsRecording.get()) {
                    int ret;
                    if (this.mAudioFormat == 2) {
                        ret = this.mAudioRecord.read(this.mShortBuffer, 0, this.mShortBufferSize);
                        if (ret > 0) {
                            this.mAudioDataCallback.onAudioData(this.short2byte(this.mShortBuffer, ret, this.mByteBuffer), ret * 2);
                            continue;
                        }
                        this.onError(ret);
                        break;
                    }
                    ret = this.mAudioRecord.read(this.mByteBuffer, 0, this.mByteBufferSize);
                    if (ret > 0) {
                        this.mAudioDataCallback.onAudioData(this.mByteBuffer, ret);
                        continue;
                    }
                    this.onError(ret);
                    break;
                }
            }
            this.mAudioRecord.release();
        }

        private byte[] short2byte(short[] sData, int size, byte[] bData) {
            if (size > sData.length || size * 2 > bData.length) {
                Log.w((String)StreamAudioRecorder.TAG, (String)"short2byte: too long short data array");
            }
            for (int i = 0; i < size; ++i) {
                bData[i * 2] = (byte)(sData[i] & 0xFF);
                bData[i * 2 + 1] = (byte)(sData[i] >> 8);
            }
            return bData;
        }

        private void onError(int errorCode) {
            if (errorCode == -3) {
                Log.w((String)StreamAudioRecorder.TAG, (String)"record fail: ERROR_INVALID_OPERATION");
                this.mAudioDataCallback.onError();
            } else if (errorCode == -2) {
                Log.w((String)StreamAudioRecorder.TAG, (String)"record fail: ERROR_BAD_VALUE");
                this.mAudioDataCallback.onError();
            }
        }
    }

    private static final class StreamAudioRecorderHolder {
        private static final StreamAudioRecorder INSTANCE = new StreamAudioRecorder();

        private StreamAudioRecorderHolder() {
        }
    }

    public static interface AudioDataCallback {
        @WorkerThread
        public void onAudioData(byte[] var1, int var2);

        public void onError();
    }
}

