/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.rxandroidaudio;

import android.media.AudioTrack;
import android.util.Log;
import androidx.annotation.WorkerThread;

public final class StreamAudioPlayer {
    private static final String TAG = "StreamAudioPlayer";
    public static final int DEFAULT_SAMPLE_RATE = 44100;
    private AudioTrack mAudioTrack;

    private StreamAudioPlayer() {
    }

    public static StreamAudioPlayer getInstance() {
        return StreamAudioPlayerHolder.INSTANCE;
    }

    public synchronized void init() {
        this.init(44100, 4, 2, 2048);
    }

    public synchronized void init(int sampleRate, int channelConfig, int audioFormat, int bufferSize) {
        if (this.mAudioTrack != null) {
            this.mAudioTrack.release();
            this.mAudioTrack = null;
        }
        int minBufferSize = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat);
        this.mAudioTrack = new AudioTrack(3, sampleRate, channelConfig, audioFormat, Math.max(minBufferSize, bufferSize), 1);
        this.mAudioTrack.play();
    }

    @WorkerThread
    public synchronized boolean play(byte[] data, int size) {
        if (this.mAudioTrack != null) {
            try {
                int ret = this.mAudioTrack.write(data, 0, size);
                switch (ret) {
                    case -3: {
                        Log.w((String)TAG, (String)"play fail: ERROR_INVALID_OPERATION");
                        return false;
                    }
                    case -2: {
                        Log.w((String)TAG, (String)"play fail: ERROR_BAD_VALUE");
                        return false;
                    }
                    case -6: {
                        Log.w((String)TAG, (String)"play fail: ERROR_DEAD_OBJECT");
                        return false;
                    }
                }
                return true;
            }
            catch (IllegalStateException e) {
                Log.w((String)TAG, (String)("play fail: " + e.getMessage()));
                return false;
            }
        }
        Log.w((String)TAG, (String)"play fail: null mAudioTrack");
        return false;
    }

    public synchronized void release() {
        if (this.mAudioTrack != null) {
            this.mAudioTrack.release();
            this.mAudioTrack = null;
        }
    }

    private static final class StreamAudioPlayerHolder {
        private static final StreamAudioPlayer INSTANCE = new StreamAudioPlayer();

        private StreamAudioPlayerHolder() {
        }
    }
}

