/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.loader.fresco;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import com.facebook.binaryresource.FileBinaryResource;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.disk.FileCache;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.DraweeConfig;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.cache.DefaultCacheKeyFactory;
import com.facebook.imagepipeline.core.DefaultExecutorSupplier;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.imagepipeline.request.ImageRequest;
import com.github.piasy.biv.loader.ImageLoader;
import com.github.piasy.biv.loader.fresco.ImageDownloadSubscriber;
import com.github.piasy.biv.metadata.ImageInfoExtractor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class FrescoImageLoader
implements ImageLoader {
    private final Context mAppContext;
    private final DefaultExecutorSupplier mExecutorSupplier;
    private final Map<Integer, DataSource> mFlyingRequestSources = new HashMap<Integer, DataSource>(3);
    private final Map<Integer, File> mCacheMissTempFiles = new HashMap<Integer, File>(3);

    private FrescoImageLoader(Context appContext) {
        this.mAppContext = appContext;
        this.mExecutorSupplier = new DefaultExecutorSupplier(Runtime.getRuntime().availableProcessors());
    }

    public static FrescoImageLoader with(Context appContext) {
        return FrescoImageLoader.with(appContext, null, null);
    }

    public static FrescoImageLoader with(Context appContext, ImagePipelineConfig imagePipelineConfig) {
        return FrescoImageLoader.with(appContext, imagePipelineConfig, null);
    }

    public static FrescoImageLoader with(Context appContext, ImagePipelineConfig imagePipelineConfig, DraweeConfig draweeConfig) {
        Fresco.initialize((Context)appContext, (ImagePipelineConfig)imagePipelineConfig, (DraweeConfig)draweeConfig);
        return new FrescoImageLoader(appContext);
    }

    @SuppressLint(value={"WrongThread"})
    public void loadImage(final int requestId, Uri uri, final ImageLoader.Callback callback) {
        ImageRequest request = ImageRequest.fromUri((Uri)uri);
        final File localCache = this.getCacheFile(request);
        if (localCache.exists()) {
            this.mExecutorSupplier.forLocalStorageRead().execute(new Runnable(){

                @Override
                public void run() {
                    callback.onCacheHit(ImageInfoExtractor.getImageType((File)localCache), localCache);
                    callback.onSuccess(localCache);
                }
            });
        } else {
            callback.onStart();
            callback.onProgress(0);
            ImagePipeline pipeline = Fresco.getImagePipeline();
            DataSource source = pipeline.fetchEncodedImage(request, (Object)true);
            source.subscribe((DataSubscriber)new ImageDownloadSubscriber(this.mAppContext){

                @Override
                protected void onProgress(int progress) {
                    callback.onProgress(progress);
                }

                @Override
                protected void onSuccess(File image) {
                    FrescoImageLoader.this.rememberTempFile(requestId, image);
                    callback.onFinish();
                    callback.onCacheMiss(ImageInfoExtractor.getImageType((File)image), image);
                    callback.onSuccess(image);
                }

                @Override
                protected void onFail(Throwable t) {
                    t.printStackTrace();
                    callback.onFail((Exception)t);
                }
            }, this.mExecutorSupplier.forBackgroundTasks());
            this.cancel(requestId);
            this.rememberSource(requestId, source);
        }
    }

    public void prefetch(Uri uri) {
        ImagePipeline pipeline = Fresco.getImagePipeline();
        pipeline.prefetchToDiskCache(ImageRequest.fromUri((Uri)uri), (Object)false);
    }

    public synchronized void cancel(int requestId) {
        this.closeSource(this.mFlyingRequestSources.remove(requestId));
        this.deleteTempFile(this.mCacheMissTempFiles.remove(requestId));
    }

    public synchronized void cancelAll() {
        ArrayList<DataSource> sources = new ArrayList<DataSource>(this.mFlyingRequestSources.values());
        this.mFlyingRequestSources.clear();
        for (DataSource source : sources) {
            this.closeSource(source);
        }
        ArrayList<File> tempFiles = new ArrayList<File>(this.mCacheMissTempFiles.values());
        this.mCacheMissTempFiles.clear();
        for (File tempFile : tempFiles) {
            this.deleteTempFile(tempFile);
        }
    }

    private synchronized void rememberSource(int requestId, DataSource source) {
        this.mFlyingRequestSources.put(requestId, source);
    }

    private void closeSource(DataSource source) {
        if (source != null) {
            source.close();
        }
    }

    private synchronized void rememberTempFile(int requestId, File tempFile) {
        this.mCacheMissTempFiles.put(requestId, tempFile);
    }

    private void deleteTempFile(File tempFile) {
        if (tempFile != null) {
            tempFile.delete();
        }
    }

    private File getCacheFile(ImageRequest request) {
        FileCache mainFileCache = ImagePipelineFactory.getInstance().getMainFileCache();
        CacheKey cacheKey = DefaultCacheKeyFactory.getInstance().getEncodedCacheKey(request, (Object)false);
        File cacheFile = request.getSourceFile();
        if (mainFileCache.hasKey(cacheKey) && mainFileCache.getResource(cacheKey) != null) {
            cacheFile = ((FileBinaryResource)mainFileCache.getResource(cacheKey)).getFile();
        }
        return cacheFile;
    }
}

