/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.profiling.repository;

import java.io.Reader;
import java.io.StringReader;
import java.time.temporal.ChronoUnit;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

@RequestScoped
public class EventSearcher {
    private static final Logger log = Logger.getLogger(EventSearcher.class.getName());
    @Inject
    private Client client;
    @Inject
    @ConfigProperty(name="default.response.size", defaultValue="100")
    private int defaultResponseSize;

    @Timeout(value=5L, unit=ChronoUnit.SECONDS)
    @CircuitBreaker(failOn={NoNodeAvailableException.class}, requestVolumeThreshold=4, failureRatio=0.75, delay=5L, delayUnit=ChronoUnit.SECONDS)
    public Response search(String key, Object value, int size) {
        if (size < 0) {
            size = this.defaultResponseSize;
        }
        SearchResponse response = (SearchResponse)this.getSearchRequestBuilder(key, value, size).get();
        return this.handleSearchResponse(response);
    }

    private Response handleSearchResponse(SearchResponse response) {
        int status = response.status().getStatus();
        if (status == 200) {
            SearchHits hits = response.getHits();
            long numberOfHits = hits.totalHits;
            if (numberOfHits > 0L) {
                SearchHit[] hitsArray;
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                long took = response.getTook().getMillis();
                for (SearchHit hit : hitsArray = hits.getHits()) {
                    String json = hit.getSourceAsString();
                    JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));
                    JsonObject eventJson = jsonReader.readObject();
                    arrayBuilder.add((JsonValue)eventJson);
                }
                return Response.ok((Object)arrayBuilder.build()).header("x-number-of-hits", (Object)numberOfHits).header("x-time-took-ms", (Object)took).build();
            }
            return Response.serverError().build();
        }
        return Response.serverError().build();
    }

    private SearchRequestBuilder getSearchRequestBuilder(String key, Object value, int size) {
        SearchRequestBuilder srb = this.client.prepareSearch(new String[]{"profiling"}).setTypes(new String[]{"event"});
        srb = srb.setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        srb = srb.setQuery((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)value));
        srb = srb.addSort(SortBuilders.fieldSort((String)"timeOccured").order(SortOrder.DESC));
        srb = srb.setFrom(0).setSize(size);
        return srb;
    }
}

