/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.profiling.health;

import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.health.ClusterHealthStatus;

@Health
@ApplicationScoped
public class ProfilingHealthCheck
implements HealthCheck {
    private static final Logger log = Logger.getLogger(ProfilingHealthCheck.class.getName());
    @Inject
    private Client client;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)"profiling");
        try {
            ClusterHealthResponse clusterHealth = this.getHealthDetails();
            boolean up = this.isHealthy(clusterHealth);
            responseBuilder = responseBuilder.withData("clusterName", clusterHealth.getClusterName()).withData("numberOfDataNodes", (long)clusterHealth.getNumberOfDataNodes()).withData("numberOfNodes", (long)clusterHealth.getNumberOfNodes()).withData("status", clusterHealth.getStatus().name()).withData("activeShardsPercent", String.valueOf(clusterHealth.getActiveShardsPercent()) + "%");
            return responseBuilder.state(up).build();
        }
        catch (NoNodeAvailableException nnae) {
            responseBuilder = responseBuilder.withData("exception", nnae.getMessage());
            return responseBuilder.state(false).build();
        }
    }

    private ClusterHealthResponse getHealthDetails() {
        ClusterAdminClient clusterAdminClient = this.client.admin().cluster();
        return (ClusterHealthResponse)clusterAdminClient.prepareHealth(new String[0]).get();
    }

    private boolean isHealthy(ClusterHealthResponse clusterHealth) {
        ClusterHealthStatus status = clusterHealth.getStatus();
        return status.equals((Object)ClusterHealthStatus.GREEN) || status.equals((Object)ClusterHealthStatus.YELLOW);
    }
}

