/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.profiling;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;

@Schema(name="UserEvent", description="POJO that represents an event.")
public class UserEvent {
    @NotNull
    @Schema(required=true, description="Who did it ?", type=SchemaType.INTEGER)
    private int userId;
    @NotNull
    @Schema(required=true, description="When did this happen ?")
    private Date timeOccured;
    @NotNull
    @Schema(required=false, description="When did we hear about it ?")
    private Date timeReceived = new Date();
    @NotNull
    @Schema(required=true, description="What happened ?")
    private String eventName;
    @Schema(required=false, description="For how long ?", type=SchemaType.INTEGER)
    private int durationInMinutes;
    @Schema(required=false, description="Where did this happen ?")
    private String location;
    @Schema(required=false, description="At what partner did this happen ?")
    private String partnerName;
    @Schema(required=false, description="Anyting else we need to know ?")
    private Map<String, String> metadata = new HashMap();

    public void addMetadata(String key, String val) {
        this.metadata.put(key, val);
    }

    public int getUserId() {
        return this.userId;
    }

    public Date getTimeOccured() {
        return this.timeOccured;
    }

    public Date getTimeReceived() {
        return this.timeReceived;
    }

    public String getEventName() {
        return this.eventName;
    }

    public int getDurationInMinutes() {
        return this.durationInMinutes;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPartnerName() {
        return this.partnerName;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setTimeOccured(Date timeOccured) {
        this.timeOccured = timeOccured;
    }

    public void setTimeReceived(Date timeReceived) {
        this.timeReceived = timeReceived;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void setDurationInMinutes(int durationInMinutes) {
        this.durationInMinutes = durationInMinutes;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPartnerName(String partnerName) {
        this.partnerName = partnerName;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserEvent)) {
            return false;
        }
        UserEvent other = (UserEvent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getUserId() != other.getUserId()) {
            return false;
        }
        Date this$timeOccured = this.getTimeOccured();
        Date other$timeOccured = other.getTimeOccured();
        if (this$timeOccured == null ? other$timeOccured != null : !((Object)this$timeOccured).equals(other$timeOccured)) {
            return false;
        }
        Date this$timeReceived = this.getTimeReceived();
        Date other$timeReceived = other.getTimeReceived();
        if (this$timeReceived == null ? other$timeReceived != null : !((Object)this$timeReceived).equals(other$timeReceived)) {
            return false;
        }
        String this$eventName = this.getEventName();
        String other$eventName = other.getEventName();
        if (this$eventName == null ? other$eventName != null : !this$eventName.equals(other$eventName)) {
            return false;
        }
        if (this.getDurationInMinutes() != other.getDurationInMinutes()) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$partnerName = this.getPartnerName();
        String other$partnerName = other.getPartnerName();
        if (this$partnerName == null ? other$partnerName != null : !this$partnerName.equals(other$partnerName)) {
            return false;
        }
        Map this$metadata = this.getMetadata();
        Map other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUserId();
        Date $timeOccured = this.getTimeOccured();
        result = result * 59 + ($timeOccured == null ? 43 : ((Object)$timeOccured).hashCode());
        Date $timeReceived = this.getTimeReceived();
        result = result * 59 + ($timeReceived == null ? 43 : ((Object)$timeReceived).hashCode());
        String $eventName = this.getEventName();
        result = result * 59 + ($eventName == null ? 43 : $eventName.hashCode());
        result = result * 59 + this.getDurationInMinutes();
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $partnerName = this.getPartnerName();
        result = result * 59 + ($partnerName == null ? 43 : $partnerName.hashCode());
        Map $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "UserEvent(userId=" + this.getUserId() + ", timeOccured=" + this.getTimeOccured() + ", timeReceived=" + this.getTimeReceived() + ", eventName=" + this.getEventName() + ", durationInMinutes=" + this.getDurationInMinutes() + ", location=" + this.getLocation() + ", partnerName=" + this.getPartnerName() + ", metadata=" + this.getMetadata() + ")";
    }

    public UserEvent(int userId, Date timeOccured, Date timeReceived, String eventName, int durationInMinutes, String location, String partnerName, Map<String, String> metadata) {
        this.userId = userId;
        this.timeOccured = timeOccured;
        this.timeReceived = timeReceived;
        this.eventName = eventName;
        this.durationInMinutes = durationInMinutes;
        this.location = location;
        this.partnerName = partnerName;
        this.metadata = metadata;
    }

    public UserEvent() {
    }
}

