/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.IShiftAccumulator;

final class BitShiftAccumulator
implements IShiftAccumulator {
    private static final int SmallBitLength = 32;
    private int bitLeftmost;
    private int bitsAfterLeftmost;
    private EInteger shiftedBigInt;
    private FastInteger knownBitLength;
    private int shiftedSmall;
    private boolean isSmall;
    private FastInteger discardedBitCount;

    public final int getLastDiscardedDigit() {
        return this.bitLeftmost;
    }

    public final int getOlderDiscardedDigits() {
        return this.bitsAfterLeftmost;
    }

    public FastInteger GetDigitLength() {
        this.knownBitLength = this.knownBitLength == null ? this.CalcKnownBitLength() : this.knownBitLength;
        return FastInteger.Copy(this.knownBitLength);
    }

    public void ShiftToDigits(FastInteger bits) {
        if (bits.signum() < 0) {
            throw new IllegalArgumentException("bits's sign (" + bits.signum() + ") is less than 0");
        }
        if (bits.CanFitInInt32()) {
            this.ShiftToDigitsInt(bits.AsInt32());
        } else {
            this.knownBitLength = this.CalcKnownBitLength();
            EInteger bigintDiff = this.knownBitLength.AsBigInteger();
            EInteger bitsBig = bits.AsBigInteger();
            if ((bigintDiff = bigintDiff.Subtract(bitsBig)).signum() > 0) {
                this.ShiftRight(FastInteger.FromBig(bigintDiff));
            }
        }
    }

    public final EInteger getShiftedInt() {
        return this.isSmall ? EInteger.FromInt64(this.shiftedSmall) : this.shiftedBigInt;
    }

    public final FastInteger getShiftedIntFast() {
        return this.isSmall ? new FastInteger(this.shiftedSmall) : FastInteger.FromBig(this.shiftedBigInt);
    }

    public final FastInteger getDiscardedDigitCount() {
        return this.discardedBitCount;
    }

    public BitShiftAccumulator(EInteger bigint, int lastDiscarded, int olderDiscarded) {
        if (bigint.signum() < 0) {
            throw new IllegalArgumentException("bigint's sign (" + bigint.signum() + ") is less than 0");
        }
        if (bigint.CanFitInInt32()) {
            this.isSmall = true;
            this.shiftedSmall = bigint.AsInt32Checked();
        } else {
            this.shiftedBigInt = bigint;
        }
        this.discardedBitCount = new FastInteger(0);
        this.bitsAfterLeftmost = olderDiscarded != 0 ? 1 : 0;
        this.bitLeftmost = lastDiscarded != 0 ? 1 : 0;
    }

    public static BitShiftAccumulator FromInt32(int smallNumber) {
        if (smallNumber < 0) {
            throw new IllegalArgumentException("smallNumber (" + smallNumber + ") is less than 0");
        }
        BitShiftAccumulator bsa = new BitShiftAccumulator(EInteger.FromInt64(0L), 0, 0);
        bsa.shiftedSmall = smallNumber;
        bsa.discardedBitCount = new FastInteger(0);
        bsa.isSmall = true;
        return bsa;
    }

    public void TruncateRight(FastInteger fastint) {
        this.ShiftRight(fastint);
    }

    public void ShiftRight(FastInteger fastint) {
        if (fastint.signum() <= 0) {
            return;
        }
        if (fastint.CanFitInInt32()) {
            this.ShiftRightInt(fastint.AsInt32());
        } else {
            EInteger bi = fastint.AsBigInteger();
            while (bi.signum() > 0) {
                int count = 1000000;
                if (bi.compareTo(EInteger.FromInt64(1000000L)) < 0) {
                    count = bi.AsInt32Checked();
                }
                this.ShiftRightInt(count);
                bi = bi.Subtract(EInteger.FromInt64(count));
                if (!(this.isSmall ? this.shiftedSmall == 0 : this.shiftedBigInt.isZero())) continue;
                break;
            }
        }
    }

    private void ShiftRightBig(int bits) {
        if (bits <= 0) {
            return;
        }
        if (this.shiftedBigInt.isZero()) {
            this.discardedBitCount.AddInt(bits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            this.isSmall = true;
            this.shiftedSmall = 0;
            this.knownBitLength = new FastInteger(1);
            return;
        }
        this.knownBitLength = this.knownBitLength == null ? this.GetDigitLength() : this.knownBitLength;
        this.discardedBitCount.AddInt(bits);
        int cmp = this.knownBitLength.CompareToInt(bits);
        if (cmp < 0) {
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitsAfterLeftmost |= this.shiftedBigInt.isZero() ? 0 : 1;
            this.bitLeftmost = 0;
            this.isSmall = true;
            this.shiftedSmall = 0;
            this.knownBitLength = new FastInteger(1);
        } else {
            int bs = bits;
            this.knownBitLength.SubtractInt(bits);
            if (bs == 1) {
                boolean odd = !this.shiftedBigInt.isEven();
                this.shiftedBigInt = this.shiftedBigInt.ShiftRight(1);
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = odd ? 1 : 0;
            } else {
                this.bitsAfterLeftmost |= this.bitLeftmost;
                int lowestSetBit = this.shiftedBigInt.GetLowBit();
                if (lowestSetBit < bs - 1) {
                    this.bitsAfterLeftmost |= 1;
                    this.bitLeftmost = this.shiftedBigInt.GetSignedBit(bs - 1) ? 1 : 0;
                } else {
                    this.bitLeftmost = lowestSetBit > bs - 1 ? 0 : 1;
                }
                this.shiftedBigInt = this.shiftedBigInt.ShiftRight(bs);
            }
            if (this.knownBitLength.CompareToInt(32) < 0) {
                this.isSmall = true;
                this.shiftedSmall = this.shiftedBigInt.AsInt32Checked();
            }
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
        }
    }

    private FastInteger CalcKnownBitLength() {
        if (this.isSmall) {
            int kb = 32;
            for (int i = 31; i >= 0 && (this.shiftedSmall & 1 << i) == 0; --i) {
                --kb;
            }
            if (kb == 0) {
                ++kb;
            }
            return new FastInteger(kb);
        }
        return new FastInteger(this.shiftedBigInt.isZero() ? 1 : this.shiftedBigInt.GetSignedBitLength());
    }

    private void ShiftBigToBits(int bits) {
        if (this.knownBitLength != null && this.knownBitLength.CompareToInt(bits) <= 0) {
            return;
        }
        FastInteger fastInteger = this.knownBitLength = this.knownBitLength == null ? this.GetDigitLength() : this.knownBitLength;
        if (this.knownBitLength.CompareToInt(bits) <= 0) {
            return;
        }
        if (this.knownBitLength.CompareToInt(bits) > 0) {
            int bs = 0;
            if (this.knownBitLength.CanFitInInt32()) {
                bs = this.knownBitLength.AsInt32();
                bs -= bits;
            } else {
                FastInteger bitShift = FastInteger.Copy(this.knownBitLength).SubtractInt(bits);
                if (!bitShift.CanFitInInt32()) {
                    this.ShiftRight(bitShift);
                    return;
                }
                bs = bitShift.AsInt32();
            }
            this.knownBitLength.SetInt(bits);
            this.discardedBitCount.AddInt(bs);
            if (bs == 1) {
                boolean odd = !this.shiftedBigInt.isEven();
                this.shiftedBigInt = this.shiftedBigInt.ShiftRight(1);
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = odd ? 1 : 0;
            } else {
                this.bitsAfterLeftmost |= this.bitLeftmost;
                int lowestSetBit = this.shiftedBigInt.GetLowBit();
                if (lowestSetBit < bs - 1) {
                    this.bitsAfterLeftmost |= 1;
                    this.bitLeftmost = this.shiftedBigInt.GetSignedBit(bs - 1) ? 1 : 0;
                } else {
                    this.bitLeftmost = lowestSetBit > bs - 1 ? 0 : 1;
                }
                this.shiftedBigInt = this.shiftedBigInt.ShiftRight(bs);
            }
            if (bits < 32) {
                this.isSmall = true;
                this.shiftedSmall = this.shiftedBigInt.AsInt32Checked();
            }
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
        }
    }

    public void ShiftRightInt(int bits) {
        if (this.isSmall) {
            this.ShiftRightSmall(bits);
        } else {
            this.ShiftRightBig(bits);
        }
    }

    private void ShiftRightSmall(int bits) {
        if (bits <= 0) {
            return;
        }
        if (this.shiftedSmall == 0) {
            this.discardedBitCount.AddInt(bits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            this.knownBitLength = new FastInteger(1);
            return;
        }
        int kb = 32;
        for (int i = 31; i >= 0 && (this.shiftedSmall & 1 << i) == 0; --i) {
            --kb;
        }
        int shift = Math.min(kb, bits);
        boolean shiftingMoreBits = bits > kb;
        this.knownBitLength = new FastInteger(kb -= shift);
        this.discardedBitCount.AddInt(bits);
        this.bitsAfterLeftmost |= this.bitLeftmost;
        this.bitsAfterLeftmost |= shift > 1 && this.shiftedSmall << 32 - shift + 1 != 0 ? 1 : 0;
        this.bitLeftmost = this.shiftedSmall >> shift - 1 & 1;
        this.shiftedSmall >>= shift;
        if (shiftingMoreBits) {
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
        }
        this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
    }

    public void ShiftToDigitsInt(int bits) {
        if (bits < 0) {
            throw new IllegalArgumentException("bits (" + bits + ") is less than 0");
        }
        if (this.isSmall) {
            this.ShiftSmallToBits(bits);
        } else {
            this.ShiftBigToBits(bits);
        }
    }

    private void ShiftSmallToBits(int bits) {
        if (this.knownBitLength != null && this.knownBitLength.CompareToInt(bits) <= 0) {
            return;
        }
        FastInteger fastInteger = this.knownBitLength = this.knownBitLength == null ? this.GetDigitLength() : this.knownBitLength;
        if (this.knownBitLength.CompareToInt(bits) <= 0) {
            return;
        }
        int kbl = this.knownBitLength.AsInt32();
        if (kbl > bits) {
            int bitShift;
            int shift = bitShift = kbl - bits;
            this.knownBitLength = new FastInteger(bits);
            this.discardedBitCount.AddInt(bitShift);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitsAfterLeftmost |= shift > 1 && this.shiftedSmall << 32 - shift + 1 != 0 ? 1 : 0;
            this.bitLeftmost = this.shiftedSmall >> shift - 1 & 1;
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            this.shiftedSmall >>= shift;
        } else {
            this.knownBitLength = new FastInteger(kbl);
        }
    }
}

