/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.io;

import com.github.penfeizhou.animation.io.Reader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamReader
extends FilterInputStream
implements Reader {
    private int position;

    public StreamReader(InputStream in) {
        super(in);
        try {
            in.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public byte peek() throws IOException {
        byte ret = (byte)this.read();
        ++this.position;
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = super.read(b, off, len);
        this.position += Math.max(0, ret);
        return ret;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.position = 0;
    }

    @Override
    public long skip(long n) throws IOException {
        long ret = super.skip(n);
        this.position = (int)((long)this.position + ret);
        return ret;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public InputStream toInputStream() throws IOException {
        return this;
    }
}

