/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.github.penfeizhou.animation.decode.FrameSeqDecoder;
import com.github.penfeizhou.animation.loader.Loader;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class FrameAnimationDrawable<Decoder extends FrameSeqDecoder<?, ?>>
extends Drawable
implements Animatable2Compat,
FrameSeqDecoder.RenderListener {
    private static final String TAG = FrameAnimationDrawable.class.getSimpleName();
    private final Paint paint = new Paint();
    private final Decoder frameSeqDecoder;
    private final DrawFilter drawFilter = new PaintFlagsDrawFilter(0, 3);
    private final Matrix matrix = new Matrix();
    private final Set<Animatable2Compat.AnimationCallback> animationCallbacks = new HashSet<Animatable2Compat.AnimationCallback>();
    private Bitmap bitmap;
    private static final int MSG_ANIMATION_START = 1;
    private static final int MSG_ANIMATION_END = 2;
    private final Handler uiHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ArrayList callbacks = new ArrayList(FrameAnimationDrawable.this.animationCallbacks);
                    for (Animatable2Compat.AnimationCallback animationCallback : callbacks) {
                        animationCallback.onAnimationStart((Drawable)FrameAnimationDrawable.this);
                    }
                    break;
                }
                case 2: {
                    ArrayList callbacks = new ArrayList(FrameAnimationDrawable.this.animationCallbacks);
                    for (Animatable2Compat.AnimationCallback animationCallback : callbacks) {
                        animationCallback.onAnimationEnd((Drawable)FrameAnimationDrawable.this);
                    }
                    break;
                }
            }
        }
    };
    private final Runnable invalidateRunnable = new Runnable(){

        @Override
        public void run() {
            FrameAnimationDrawable.this.invalidateSelf();
        }
    };
    private boolean autoPlay = true;
    private final Set<WeakReference<Drawable.Callback>> obtainedCallbacks = new HashSet<WeakReference<Drawable.Callback>>();
    private boolean noMeasure = false;

    public FrameAnimationDrawable(Decoder frameSeqDecoder) {
        this.paint.setAntiAlias(true);
        this.frameSeqDecoder = frameSeqDecoder;
    }

    public FrameAnimationDrawable(Loader provider) {
        this.paint.setAntiAlias(true);
        this.frameSeqDecoder = this.createFrameSeqDecoder(provider, this);
    }

    public void setAutoPlay(boolean autoPlay) {
        this.autoPlay = autoPlay;
    }

    public void setNoMeasure(boolean noMeasure) {
        this.noMeasure = noMeasure;
    }

    protected abstract Decoder createFrameSeqDecoder(Loader var1, FrameSeqDecoder.RenderListener var2);

    public void setLoopLimit(int loopLimit) {
        ((FrameSeqDecoder)this.frameSeqDecoder).setLoopLimit(loopLimit);
    }

    public void reset() {
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            this.bitmap.eraseColor(0);
        }
        ((FrameSeqDecoder)this.frameSeqDecoder).reset();
    }

    public void pause() {
        ((FrameSeqDecoder)this.frameSeqDecoder).pause();
    }

    public void resume() {
        ((FrameSeqDecoder)this.frameSeqDecoder).resume();
    }

    public boolean isPaused() {
        return ((FrameSeqDecoder)this.frameSeqDecoder).isPaused();
    }

    public void start() {
        if (((FrameSeqDecoder)this.frameSeqDecoder).isRunning()) {
            ((FrameSeqDecoder)this.frameSeqDecoder).stop();
        }
        ((FrameSeqDecoder)this.frameSeqDecoder).reset();
        this.innerStart();
    }

    private void innerStart() {
        ((FrameSeqDecoder)this.frameSeqDecoder).addRenderListener(this);
        if (this.autoPlay) {
            ((FrameSeqDecoder)this.frameSeqDecoder).start();
        } else if (!((FrameSeqDecoder)this.frameSeqDecoder).isRunning()) {
            ((FrameSeqDecoder)this.frameSeqDecoder).start();
        }
    }

    public void stop() {
        this.innerStop();
    }

    private void innerStop() {
        ((FrameSeqDecoder)this.frameSeqDecoder).removeRenderListener(this);
        if (this.autoPlay) {
            ((FrameSeqDecoder)this.frameSeqDecoder).stop();
        } else {
            ((FrameSeqDecoder)this.frameSeqDecoder).stopIfNeeded();
        }
    }

    public boolean isRunning() {
        return ((FrameSeqDecoder)this.frameSeqDecoder).isRunning();
    }

    public void draw(Canvas canvas) {
        if (this.bitmap == null || this.bitmap.isRecycled()) {
            return;
        }
        canvas.setDrawFilter(this.drawFilter);
        canvas.drawBitmap(this.bitmap, this.matrix, this.paint);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        boolean sampleSizeChanged = ((FrameSeqDecoder)this.frameSeqDecoder).setDesiredSize(this.getBounds().width(), this.getBounds().height());
        this.matrix.setScale(1.0f * (float)this.getBounds().width() * (float)((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize() / (float)((FrameSeqDecoder)this.frameSeqDecoder).getBounds().width(), 1.0f * (float)this.getBounds().height() * (float)((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize() / (float)((FrameSeqDecoder)this.frameSeqDecoder).getBounds().height());
        if (sampleSizeChanged) {
            this.bitmap = Bitmap.createBitmap((int)(((FrameSeqDecoder)this.frameSeqDecoder).getBounds().width() / ((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize()), (int)(((FrameSeqDecoder)this.frameSeqDecoder).getBounds().height() / ((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    @Override
    public void onStart() {
        Message.obtain((Handler)this.uiHandler, (int)1).sendToTarget();
    }

    @Override
    public void onRender(ByteBuffer byteBuffer) {
        if (!this.isRunning()) {
            return;
        }
        if (this.bitmap == null || this.bitmap.isRecycled()) {
            this.bitmap = Bitmap.createBitmap((int)(((FrameSeqDecoder)this.frameSeqDecoder).getBounds().width() / ((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize()), (int)(((FrameSeqDecoder)this.frameSeqDecoder).getBounds().height() / ((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        byteBuffer.rewind();
        if (byteBuffer.remaining() < this.bitmap.getByteCount()) {
            Log.e((String)TAG, (String)"onRender:Buffer not large enough for pixels");
            return;
        }
        this.bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
        this.uiHandler.post(this.invalidateRunnable);
    }

    @Override
    public void onEnd() {
        Message.obtain((Handler)this.uiHandler, (int)2).sendToTarget();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        this.hookRecordCallbacks();
        if (this.autoPlay) {
            if (visible) {
                if (!this.isRunning()) {
                    this.innerStart();
                }
            } else if (this.isRunning()) {
                this.innerStop();
            }
        }
        return super.setVisible(visible, restart);
    }

    public int getIntrinsicWidth() {
        if (this.noMeasure) {
            return -1;
        }
        try {
            return ((FrameSeqDecoder)this.frameSeqDecoder).getBounds().width();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getIntrinsicHeight() {
        if (this.noMeasure) {
            return -1;
        }
        try {
            return ((FrameSeqDecoder)this.frameSeqDecoder).getBounds().height();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void registerAnimationCallback(@NonNull Animatable2Compat.AnimationCallback animationCallback) {
        this.animationCallbacks.add(animationCallback);
    }

    public boolean unregisterAnimationCallback(@NonNull Animatable2Compat.AnimationCallback animationCallback) {
        return this.animationCallbacks.remove(animationCallback);
    }

    public void clearAnimationCallbacks() {
        this.animationCallbacks.clear();
    }

    public int getMemorySize() {
        int size = ((FrameSeqDecoder)this.frameSeqDecoder).getMemorySize();
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            size = Build.VERSION.SDK_INT >= 19 ? (size += this.bitmap.getAllocationByteCount()) : (size += this.bitmap.getByteCount());
        }
        return Math.max(1, size);
    }

    @Nullable
    public Drawable.Callback getCallback() {
        return super.getCallback();
    }

    private void hookRecordCallbacks() {
        ArrayList<WeakReference> lost = new ArrayList<WeakReference>();
        Drawable.Callback callback = this.getCallback();
        boolean recorded = false;
        HashSet<WeakReference<Drawable.Callback>> temp = new HashSet<WeakReference<Drawable.Callback>>(this.obtainedCallbacks);
        for (WeakReference weakReference : temp) {
            Drawable.Callback cb = (Drawable.Callback)weakReference.get();
            if (cb == null) {
                lost.add(weakReference);
                continue;
            }
            if (cb == callback) {
                recorded = true;
                continue;
            }
            cb.invalidateDrawable((Drawable)this);
        }
        for (WeakReference weakReference : lost) {
            this.obtainedCallbacks.remove(weakReference);
        }
        if (!recorded) {
            this.obtainedCallbacks.add(new WeakReference<Drawable.Callback>(callback));
        }
    }

    public void invalidateSelf() {
        super.invalidateSelf();
        HashSet<WeakReference<Drawable.Callback>> temp = new HashSet<WeakReference<Drawable.Callback>>(this.obtainedCallbacks);
        for (WeakReference weakReference : temp) {
            Drawable.Callback callback = (Drawable.Callback)weakReference.get();
            if (callback == null || callback == this.getCallback()) continue;
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public Decoder getFrameSeqDecoder() {
        return this.frameSeqDecoder;
    }
}

