/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.apng.decode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.util.Log;
import com.github.penfeizhou.animation.apng.decode.ACTLChunk;
import com.github.penfeizhou.animation.apng.decode.APNGFrame;
import com.github.penfeizhou.animation.apng.decode.APNGParser;
import com.github.penfeizhou.animation.apng.decode.Chunk;
import com.github.penfeizhou.animation.apng.decode.FCTLChunk;
import com.github.penfeizhou.animation.apng.decode.FDATChunk;
import com.github.penfeizhou.animation.apng.decode.IDATChunk;
import com.github.penfeizhou.animation.apng.decode.IENDChunk;
import com.github.penfeizhou.animation.apng.decode.IHDRChunk;
import com.github.penfeizhou.animation.apng.decode.StillFrame;
import com.github.penfeizhou.animation.apng.io.APNGReader;
import com.github.penfeizhou.animation.apng.io.APNGWriter;
import com.github.penfeizhou.animation.decode.Frame;
import com.github.penfeizhou.animation.decode.FrameSeqDecoder;
import com.github.penfeizhou.animation.io.Reader;
import com.github.penfeizhou.animation.io.Writer;
import com.github.penfeizhou.animation.loader.Loader;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class APNGDecoder
extends FrameSeqDecoder<APNGReader, APNGWriter> {
    private static final String TAG = APNGDecoder.class.getSimpleName();
    private APNGWriter apngWriter;
    private int mLoopCount;
    private final Paint paint = new Paint();
    private final SnapShot snapShot = new SnapShot();

    public APNGDecoder(Loader loader, FrameSeqDecoder.RenderListener renderListener) {
        super(loader, renderListener);
        this.paint.setAntiAlias(true);
    }

    protected APNGWriter getWriter() {
        if (this.apngWriter == null) {
            this.apngWriter = new APNGWriter();
        }
        return this.apngWriter;
    }

    protected APNGReader getReader(Reader reader) {
        return new APNGReader(reader);
    }

    protected int getLoopCount() {
        return this.mLoopCount;
    }

    protected void release() {
        this.snapShot.byteBuffer = null;
        this.apngWriter = null;
    }

    protected Rect read(APNGReader reader) throws IOException {
        List<Chunk> chunks = APNGParser.parse(reader);
        ArrayList<Chunk> otherChunks = new ArrayList<Chunk>();
        boolean actl = false;
        Frame lastFrame = null;
        byte[] ihdrData = new byte[]{};
        int canvasWidth = 0;
        int canvasHeight = 0;
        for (Chunk chunk : chunks) {
            Frame frame;
            if (chunk instanceof IENDChunk) {
                Log.e((String)TAG, (String)"chunk read reach to end");
                break;
            }
            if (chunk instanceof ACTLChunk) {
                this.mLoopCount = ((ACTLChunk)chunk).num_plays;
                actl = true;
                continue;
            }
            if (chunk instanceof FCTLChunk) {
                frame = new APNGFrame(reader, (FCTLChunk)chunk);
                frame.prefixChunks = otherChunks;
                frame.ihdrData = ihdrData;
                this.frames.add(frame);
                lastFrame = frame;
                continue;
            }
            if (chunk instanceof FDATChunk) {
                if (lastFrame == null) continue;
                lastFrame.imageChunks.add(chunk);
                continue;
            }
            if (chunk instanceof IDATChunk) {
                if (!actl) {
                    frame = new StillFrame(reader);
                    frame.frameWidth = canvasWidth;
                    frame.frameHeight = canvasHeight;
                    this.frames.add(frame);
                    this.mLoopCount = 1;
                    break;
                }
                if (lastFrame == null) continue;
                lastFrame.imageChunks.add(chunk);
                continue;
            }
            if (chunk instanceof IHDRChunk) {
                canvasWidth = ((IHDRChunk)chunk).width;
                canvasHeight = ((IHDRChunk)chunk).height;
                ihdrData = ((IHDRChunk)chunk).data;
                continue;
            }
            if (chunk instanceof IENDChunk) continue;
            otherChunks.add(chunk);
        }
        this.frameBuffer = ByteBuffer.allocate((canvasWidth * canvasHeight / (this.sampleSize * this.sampleSize) + 1) * 4);
        this.snapShot.byteBuffer = ByteBuffer.allocate((canvasWidth * canvasHeight / (this.sampleSize * this.sampleSize) + 1) * 4);
        return new Rect(0, 0, canvasWidth, canvasHeight);
    }

    protected void renderFrame(Frame<APNGReader, APNGWriter> frame) {
        if (frame == null || this.fullRect == null) {
            return;
        }
        try {
            Bitmap bitmap = this.obtainBitmap(this.fullRect.width() / this.sampleSize, this.fullRect.height() / this.sampleSize);
            Canvas canvas = (Canvas)this.cachedCanvas.get(bitmap);
            if (canvas == null) {
                canvas = new Canvas(bitmap);
                this.cachedCanvas.put(bitmap, canvas);
            }
            if (frame instanceof APNGFrame) {
                this.frameBuffer.rewind();
                bitmap.copyPixelsFromBuffer((Buffer)this.frameBuffer);
                if (this.frameIndex == 0) {
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                } else {
                    canvas.save();
                    canvas.clipRect(this.snapShot.dstRect);
                    switch (this.snapShot.dispose_op) {
                        case 2: {
                            this.snapShot.byteBuffer.rewind();
                            bitmap.copyPixelsFromBuffer((Buffer)this.snapShot.byteBuffer);
                            break;
                        }
                        case 1: {
                            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                            break;
                        }
                    }
                    canvas.restore();
                }
                if (((APNGFrame)frame).dispose_op == 2 && this.snapShot.dispose_op != 2) {
                    this.snapShot.byteBuffer.rewind();
                    bitmap.copyPixelsToBuffer((Buffer)this.snapShot.byteBuffer);
                }
                this.snapShot.dispose_op = ((APNGFrame)frame).dispose_op;
                canvas.save();
                if (((APNGFrame)frame).blend_op == 0) {
                    canvas.clipRect(frame.frameX / this.sampleSize, frame.frameY / this.sampleSize, (frame.frameX + frame.frameWidth) / this.sampleSize, (frame.frameY + frame.frameHeight) / this.sampleSize);
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                }
                this.snapShot.dstRect.set(frame.frameX / this.sampleSize, frame.frameY / this.sampleSize, (frame.frameX + frame.frameWidth) / this.sampleSize, (frame.frameY + frame.frameHeight) / this.sampleSize);
                canvas.restore();
            }
            Bitmap inBitmap = this.obtainBitmap(frame.frameWidth, frame.frameHeight);
            this.recycleBitmap(frame.draw(canvas, this.paint, this.sampleSize, inBitmap, (Writer)this.getWriter()));
            this.recycleBitmap(inBitmap);
            this.frameBuffer.rewind();
            bitmap.copyPixelsToBuffer((Buffer)this.frameBuffer);
            this.recycleBitmap(bitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class SnapShot {
        byte dispose_op;
        Rect dstRect = new Rect();
        ByteBuffer byteBuffer;

        private SnapShot() {
        }
    }
}

