/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.escape.Escaper;
import com.google.devtools.common.options.Option;
import com.google.devtools.common.options.OptionsBase;
import com.google.devtools.common.options.OptionsParser;
import com.google.devtools.common.options.OptionsParserImpl;
import com.google.devtools.common.options.TriState;
import java.lang.reflect.Field;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class OptionsUsage {
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((char)'\n');
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");
    private static final Comparator<Field> BY_NAME = new Comparator<Field>(){

        @Override
        public int compare(Field left, Field right) {
            return left.getName().compareTo(right.getName());
        }
    };
    static final Comparator<Field> BY_CATEGORY = new Comparator<Field>(){

        @Override
        public int compare(Field left, Field right) {
            int r = left.getAnnotation(Option.class).category().compareTo(right.getAnnotation(Option.class).category());
            return r == 0 ? BY_NAME.compare(left, right) : r;
        }
    };

    OptionsUsage() {
    }

    static void getUsage(Class<? extends OptionsBase> optionsClass, StringBuilder usage) {
        ArrayList optionFields = Lists.newArrayList(OptionsParser.getAllAnnotatedFields(optionsClass));
        Collections.sort(optionFields, BY_NAME);
        for (Field optionField : optionFields) {
            OptionsUsage.getUsage(optionField, usage, OptionsParser.HelpVerbosity.LONG);
        }
    }

    static String paragraphFill(String in, int indent, int width) {
        String indentString = Strings.repeat((String)" ", (int)indent);
        StringBuilder out = new StringBuilder();
        String sep = "";
        for (String paragraph : NEWLINE_SPLITTER.split((CharSequence)in)) {
            BreakIterator boundary = BreakIterator.getLineInstance();
            boundary.setText(paragraph);
            out.append(sep).append(indentString);
            int cursor = indent;
            int start = boundary.first();
            int end = boundary.next();
            while (end != -1) {
                String word = paragraph.substring(start, end);
                if (word.length() + cursor > width) {
                    out.append('\n').append(indentString);
                    cursor = indent;
                }
                out.append(word);
                cursor += word.length();
                start = end;
                end = boundary.next();
            }
            sep = "\n";
        }
        return out.toString();
    }

    static void getUsage(Field optionField, StringBuilder usage, OptionsParser.HelpVerbosity helpVerbosity) {
        String flagName = OptionsUsage.getFlagName(optionField);
        String typeDescription = OptionsUsage.getTypeDescription(optionField);
        Option annotation = optionField.getAnnotation(Option.class);
        usage.append("  --" + flagName);
        if (helpVerbosity == OptionsParser.HelpVerbosity.SHORT) {
            usage.append('\n');
            return;
        }
        if (annotation.abbrev() != '\u0000') {
            usage.append(" [-").append(annotation.abbrev()).append(']');
        }
        if (!typeDescription.equals("")) {
            usage.append(" (" + typeDescription + "; ");
            if (annotation.allowMultiple()) {
                usage.append("may be used multiple times");
            } else {
                String defaultValueString = OptionsParserImpl.getDefaultOptionString(optionField);
                if (OptionsParserImpl.isSpecialNullDefault(defaultValueString, optionField)) {
                    usage.append("default: see description");
                } else {
                    usage.append("default: \"" + defaultValueString + "\"");
                }
            }
            usage.append(")");
        }
        usage.append("\n");
        if (helpVerbosity == OptionsParser.HelpVerbosity.MEDIUM) {
            return;
        }
        if (!annotation.help().equals("")) {
            usage.append(OptionsUsage.paragraphFill(annotation.help(), 4, 80));
            usage.append('\n');
        }
        if (annotation.expansion().length > 0) {
            StringBuilder expandsMsg = new StringBuilder("Expands to: ");
            for (String exp : annotation.expansion()) {
                expandsMsg.append(exp).append(" ");
            }
            usage.append(OptionsUsage.paragraphFill(expandsMsg.toString(), 4, 80));
            usage.append('\n');
        }
    }

    static void getUsageHtml(Field optionField, StringBuilder usage, Escaper escaper) {
        String plainFlagName = optionField.getAnnotation(Option.class).name();
        String flagName = OptionsUsage.getFlagName(optionField);
        String valueDescription = optionField.getAnnotation(Option.class).valueHelp();
        String typeDescription = OptionsUsage.getTypeDescription(optionField);
        Option annotation = optionField.getAnnotation(Option.class);
        usage.append("<dt><code><a name=\"flag--").append(plainFlagName).append("\"></a>--");
        usage.append(flagName);
        if (!OptionsParserImpl.isBooleanField(optionField) && !OptionsParserImpl.isVoidField(optionField)) {
            if (!valueDescription.isEmpty()) {
                usage.append("=").append(escaper.escape(valueDescription));
            } else if (!typeDescription.isEmpty()) {
                usage.append("=&lt;").append(escaper.escape(typeDescription)).append("&gt");
            }
        }
        usage.append("</code>");
        if (annotation.abbrev() != '\u0000') {
            usage.append(" [<code>-").append(annotation.abbrev()).append("</code>]");
        }
        if (annotation.allowMultiple()) {
            usage.append(" multiple uses are accumulated");
        } else {
            String defaultValueString = OptionsParserImpl.getDefaultOptionString(optionField);
            if (!OptionsParserImpl.isVoidField(optionField)) {
                if (OptionsParserImpl.isSpecialNullDefault(defaultValueString, optionField)) {
                    usage.append(" default: see description");
                } else {
                    usage.append(" default: \"").append(escaper.escape(defaultValueString)).append("\"");
                }
            }
        }
        usage.append("</dt>\n");
        usage.append("<dd>\n");
        if (!annotation.help().isEmpty()) {
            usage.append(OptionsUsage.paragraphFill(escaper.escape(annotation.help()), 0, 80));
            usage.append('\n');
        }
        if (annotation.expansion().length > 0) {
            usage.append("<br/>\n");
            StringBuilder expandsMsg = new StringBuilder("Expands to:<br/>\n");
            for (String exp : annotation.expansion()) {
                expandsMsg.append("&nbsp;&nbsp;<code>").append(escaper.escape(exp)).append("</code><br/>\n");
            }
            usage.append(expandsMsg.toString());
            usage.append('\n');
        }
        usage.append("</dd>\n");
    }

    static void getCompletion(Field field, StringBuilder builder) {
        String flagName = field.getAnnotation(Option.class).name();
        Class<?> fieldType = field.getType();
        builder.append("--").append(flagName);
        if (fieldType.equals(Boolean.TYPE)) {
            builder.append("\n");
            builder.append("--no").append(flagName).append("\n");
        } else if (fieldType.equals(TriState.class)) {
            builder.append("={auto,yes,no}\n");
            builder.append("--no").append(flagName).append("\n");
        } else if (fieldType.isEnum()) {
            builder.append("={").append(COMMA_JOINER.join((Object[])fieldType.getEnumConstants()).toLowerCase()).append("}\n");
        } else if (fieldType.getSimpleName().equals("Label")) {
            builder.append("=label\n");
        } else if (fieldType.getSimpleName().equals("PathFragment")) {
            builder.append("=path\n");
        } else if (Void.class.isAssignableFrom(fieldType)) {
            builder.append("\n");
        } else {
            builder.append("=\n");
        }
    }

    private static String getTypeDescription(Field optionsField) {
        return OptionsParserImpl.findConverter(optionsField).getTypeDescription();
    }

    static String getFlagName(Field field) {
        String name = field.getAnnotation(Option.class).name();
        return OptionsParserImpl.isBooleanField(field) ? "[no]" + name : name;
    }
}

