/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.escape.CharEscaperBuilder;
import com.google.common.escape.Escaper;
import com.google.devtools.common.options.OptionsParserImpl;
import java.util.List;
import java.util.Map;

public abstract class OptionsBase {
    private static final Escaper ESCAPER = new CharEscaperBuilder().addEscape('\\', "\\\\").addEscape('\"', "\\\"").toEscaper();

    protected OptionsBase() {
    }

    public final Map<String, Object> asMap() {
        return OptionsParserImpl.optionsAsMap(this);
    }

    public final String toString() {
        return this.getClass().getName() + this.asMap();
    }

    public final String cacheKey() {
        StringBuilder result = new StringBuilder(this.getClass().getName()).append("{");
        for (Map.Entry<String, Object> entry : this.asMap().entrySet()) {
            result.append(entry.getKey()).append("=");
            Object value = entry.getValue();
            if (value instanceof List && ((List)value).isEmpty()) {
                result.append("EMPTY");
            } else if (value == null) {
                result.append("NULL");
            } else {
                result.append('\"').append(ESCAPER.escape(value.toString())).append('\"');
            }
            result.append(", ");
        }
        return result.append("}").toString();
    }

    public final boolean equals(Object that) {
        return that != null && this.getClass() == that.getClass() && this.asMap().equals(((OptionsBase)that).asMap());
    }

    public final int hashCode() {
        return this.getClass().hashCode() + this.asMap().hashCode();
    }
}

