/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.paolorotolo.appintro.AppIntroBase;
import com.github.paolorotolo.appintro.R;

public abstract class AppIntro
extends AppIntroBase {
    private static final String TAG = "AppIntro";

    @Override
    protected int getLayoutId() {
        return R.layout.intro_layout;
    }

    public void setBarColor(@ColorInt int color) {
        LinearLayout bottomBar = (LinearLayout)this.findViewById(R.id.bottom);
        bottomBar.setBackgroundColor(color);
    }

    public void setNextArrowColor(@ColorInt int color) {
        ImageButton nextButton = (ImageButton)this.findViewById(R.id.next);
        nextButton.setColorFilter(color);
    }

    public void setSeparatorColor(@ColorInt int color) {
        TextView separator = (TextView)this.findViewById(R.id.bottom_separator);
        separator.setBackgroundColor(color);
    }

    public void setSkipText(@Nullable CharSequence text) {
        TextView skipText = (TextView)this.findViewById(R.id.skip);
        skipText.setText(text);
    }

    public void setDoneText(@Nullable CharSequence text) {
        TextView doneText = (TextView)this.findViewById(R.id.done);
        doneText.setText(text);
    }

    public void setColorDoneText(@ColorInt int colorDoneText) {
        TextView doneText = (TextView)this.findViewById(R.id.done);
        doneText.setTextColor(colorDoneText);
    }

    public void setColorSkipButton(@ColorInt int colorSkipButton) {
        TextView skip = (TextView)this.findViewById(R.id.skip);
        skip.setTextColor(colorSkipButton);
    }

    public void setImageNextButton(@DrawableRes Drawable imageNextButton) {
        ImageView nextButton = (ImageView)this.findViewById(R.id.next);
        nextButton.setImageDrawable(imageNextButton);
    }

    public void showSkipButton(boolean showButton) {
        this.skipButtonEnabled = showButton;
        this.setButtonState(this.skipButton, showButton);
    }

    @Deprecated
    public void showDoneButton(boolean showDone) {
        this.setProgressButtonEnabled(showDone);
    }
}

