/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Sensors;
import oshi.jna.platform.windows.PdhUtil;
import oshi.util.platform.windows.PerfDataUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsSensors
implements Sensors {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsSensors.class);
    private static final String BASE_SENSOR_CLASS = "Sensor";
    private static final String THERMAL_ZONE_INFO = "Thermal Zone Information";
    private static final WmiUtil.WmiQuery<OhmHardwareProperty> OHM_HARDWARE_QUERY = WmiUtil.createQuery("ROOT\\OpenHardwareMonitor", "Hardware WHERE HardwareType=\"CPU\"", OhmHardwareProperty.class);
    private static final WmiUtil.WmiQuery<OhmHardwareProperty> OHM_VOLTAGE_QUERY = WmiUtil.createQuery("ROOT\\OpenHardwareMonitor", "Hardware WHERE SensorType=\"Voltage\"", OhmHardwareProperty.class);
    private static final WmiUtil.WmiQuery<OhmSensorProperty> OHM_SENSOR_QUERY = WmiUtil.createQuery("ROOT\\OpenHardwareMonitor", null, OhmSensorProperty.class);
    private static final WmiUtil.WmiQuery<FanProperty> FAN_QUERY = WmiUtil.createQuery("Win32_Fan", FanProperty.class);
    private static final WmiUtil.WmiQuery<VoltProperty> VOLT_QUERY = WmiUtil.createQuery("Win32_Processor", VoltProperty.class);
    private String thermalZoneQueryString = "";

    public WindowsSensors() {
        try {
            PdhUtil.PdhEnumObjectItems objectItems = PdhUtil.PdhEnumObjectItems(null, null, THERMAL_ZONE_INFO, 100);
            if (!objectItems.getInstances().isEmpty()) {
                this.thermalZoneQueryString = objectItems.getInstances().get(0);
                for (String instance : objectItems.getInstances()) {
                    if (!instance.toLowerCase().contains("cpu")) continue;
                    this.thermalZoneQueryString = instance;
                }
            }
            if (!this.thermalZoneQueryString.isEmpty()) {
                this.thermalZoneQueryString = String.format("\\%s(%s)\\Temperature", THERMAL_ZONE_INFO, this.thermalZoneQueryString);
                PerfDataUtil.addCounter(this.thermalZoneQueryString);
            }
        }
        catch (PdhUtil.PdhException e) {
            LOG.warn("Unable to enumerate performance counter instances for Thermal Zone Information");
        }
    }

    @Override
    public double getCpuTemperature() {
        String cpuIdentifier;
        double tempC = 0.0;
        WmiUtil.WmiResult<OhmHardwareProperty> ohmHardware = WmiUtil.queryWMI(OHM_HARDWARE_QUERY);
        if (ohmHardware.getResultCount() > 0 && (cpuIdentifier = ohmHardware.getString(OhmHardwareProperty.IDENTIFIER, 0)).length() > 0) {
            StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
            sb.append(" WHERE Parent = \"").append(cpuIdentifier);
            sb.append("\" AND SensorType=\"Temperature\"");
            OHM_SENSOR_QUERY.setWmiClassName(sb.toString());
            WmiUtil.WmiResult<OhmSensorProperty> ohmSensors = WmiUtil.queryWMI(OHM_SENSOR_QUERY);
            if (ohmSensors.getResultCount() > 0) {
                double sum = 0.0;
                for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                    sum += (double)ohmSensors.getFloat(OhmSensorProperty.VALUE, i).floatValue();
                }
                tempC = sum / (double)ohmSensors.getResultCount();
            }
            return tempC;
        }
        if (PerfDataUtil.isCounter(this.thermalZoneQueryString)) {
            long tempK = PerfDataUtil.queryCounter(this.thermalZoneQueryString);
            if (tempK > 2732L) {
                tempC = (double)tempK / 10.0 - 273.15;
            } else if (tempK > 274L) {
                tempC = (double)tempK - 273.0;
            }
            if (tempC < 0.0) {
                tempC = 0.0;
            }
        }
        return tempC;
    }

    @Override
    public int[] getFanSpeeds() {
        WmiUtil.WmiResult<FanProperty> fan;
        String cpuIdentifier;
        WmiUtil.WmiResult<OhmHardwareProperty> ohmHardware = WmiUtil.queryWMI(OHM_HARDWARE_QUERY);
        if (ohmHardware.getResultCount() > 0 && (cpuIdentifier = ohmHardware.getString(OhmHardwareProperty.IDENTIFIER, 0)).length() > 0) {
            StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
            sb.append(" WHERE Parent = \"").append(cpuIdentifier);
            sb.append("\" AND SensorType=\"Fan\"");
            OHM_SENSOR_QUERY.setWmiClassName(sb.toString());
            WmiUtil.WmiResult<OhmSensorProperty> ohmSensors = WmiUtil.queryWMI(OHM_SENSOR_QUERY);
            if (ohmSensors.getResultCount() > 0) {
                int[] fanSpeeds = new int[ohmSensors.getResultCount()];
                for (int i = 0; i < ohmSensors.getResultCount(); ++i) {
                    fanSpeeds[i] = ohmSensors.getFloat(OhmSensorProperty.VALUE, i).intValue();
                }
                return fanSpeeds;
            }
        }
        if ((fan = WmiUtil.queryWMI(FAN_QUERY)).getResultCount() > 1) {
            int[] fanSpeeds = new int[fan.getResultCount()];
            for (int i = 0; i < fan.getResultCount(); ++i) {
                fanSpeeds[i] = fan.getInteger(FanProperty.DESIREDSPEED, i);
            }
            return fanSpeeds;
        }
        return new int[1];
    }

    @Override
    public double getCpuVoltage() {
        int decivolts;
        WmiUtil.WmiResult<VoltProperty> voltage;
        WmiUtil.WmiResult<OhmHardwareProperty> ohmHardware = WmiUtil.queryWMI(OHM_VOLTAGE_QUERY);
        if (ohmHardware.getResultCount() > 0) {
            String voltIdentifierStr = null;
            for (int i = 0; i < ohmHardware.getResultCount(); ++i) {
                String id = ohmHardware.getString(OhmHardwareProperty.IDENTIFIER, i);
                if (!id.toLowerCase().contains("cpu")) continue;
                voltIdentifierStr = id;
                break;
            }
            if (voltIdentifierStr == null) {
                voltIdentifierStr = ohmHardware.getString(OhmHardwareProperty.IDENTIFIER, 0);
            }
            StringBuilder sb = new StringBuilder(BASE_SENSOR_CLASS);
            sb.append(" WHERE Parent = \"").append(voltIdentifierStr);
            sb.append("\" AND SensorType=\"Voltage\"");
            OHM_SENSOR_QUERY.setWmiClassName(sb.toString());
            WmiUtil.WmiResult<OhmSensorProperty> ohmSensors = WmiUtil.queryWMI(OHM_SENSOR_QUERY);
            if (ohmSensors.getResultCount() > 0) {
                return ohmSensors.getFloat(OhmSensorProperty.VALUE, 0).floatValue();
            }
        }
        if ((voltage = WmiUtil.queryWMI(VOLT_QUERY)).getResultCount() > 1 && (decivolts = voltage.getInteger(VoltProperty.CURRENTVOLTAGE, 0).intValue()) > 0) {
            if ((decivolts & 0x80) == 0) {
                decivolts = voltage.getInteger(VoltProperty.VOLTAGECAPS, 0);
                if ((decivolts & 1) > 0) {
                    return 5.0;
                }
                if ((decivolts & 2) > 0) {
                    return 3.3;
                }
                if ((decivolts & 4) > 0) {
                    return 2.9;
                }
            } else {
                return (double)(decivolts & 0x7F) / 10.0;
            }
        }
        return 0.0;
    }

    static enum VoltProperty {
        CURRENTVOLTAGE,
        VOLTAGECAPS;

    }

    static enum FanProperty {
        DESIREDSPEED;

    }

    static enum OhmSensorProperty {
        VALUE;

    }

    static enum OhmHardwareProperty {
        IDENTIFIER;

    }
}

