/*
 * Decompiled with CFR 0.152.
 */
package oshi.jna.platform.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.List;
import oshi.jna.platform.windows.Pdh;

public abstract class PdhUtil {
    private static final int CHAR_TO_BYTES = Boolean.getBoolean("w32.ascii") ? 1 : Native.WCHAR_SIZE;
    private static final String ENGLISH_COUNTER_KEY = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Perflib\\009";
    private static final String ENGLISH_COUNTER_VALUE = "Counter";

    public static String PdhLookupPerfNameByIndex(String szMachineName, int dwNameIndex) {
        WinDef.DWORDByReference pcchNameBufferSize = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        Pdh.INSTANCE.PdhLookupPerfNameByIndex(szMachineName, dwNameIndex, null, pcchNameBufferSize);
        if (pcchNameBufferSize.getValue().intValue() < 1) {
            return "";
        }
        Memory mem = new Memory((long)(pcchNameBufferSize.getValue().intValue() * CHAR_TO_BYTES));
        Pdh.INSTANCE.PdhLookupPerfNameByIndex(szMachineName, dwNameIndex, (Pointer)mem, pcchNameBufferSize);
        if (CHAR_TO_BYTES == 1) {
            return mem.getString(0L);
        }
        return mem.getWideString(0L);
    }

    public static int PdhLookupPerfIndexByEnglishName(String szNameBuffer) {
        String[] counters = Advapi32Util.registryGetStringArray((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)ENGLISH_COUNTER_KEY, (String)ENGLISH_COUNTER_VALUE);
        for (int i = 1; i < counters.length; i += 2) {
            if (!counters[i].equals(szNameBuffer)) continue;
            try {
                return Integer.parseInt(counters[i - 1]);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public static List<String> PdhEnumObjectItemCounters(String szDataSource, String szMachineName, String szObjectName, int dwDetailLevel) {
        ArrayList<String> counters = new ArrayList<String>();
        WinDef.DWORDByReference pcchCounterListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        WinDef.DWORDByReference pcchInstanceListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, null, pcchCounterListLength, null, pcchInstanceListLength, dwDetailLevel, 0);
        if (pcchCounterListLength.getValue().intValue() < 1 || pcchInstanceListLength.getValue().intValue() < 1) {
            return counters;
        }
        Memory mszCounterList = new Memory((long)(pcchCounterListLength.getValue().intValue() * CHAR_TO_BYTES));
        Memory mszInstanceList = new Memory((long)(pcchInstanceListLength.getValue().intValue() * CHAR_TO_BYTES));
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, (Pointer)mszCounterList, pcchCounterListLength, (Pointer)mszInstanceList, pcchInstanceListLength, dwDetailLevel, 0);
        int offset = 0;
        while ((long)offset < mszCounterList.size()) {
            String s = null;
            s = CHAR_TO_BYTES == 1 ? mszCounterList.getString((long)offset) : mszCounterList.getWideString((long)offset);
            if (s.isEmpty()) break;
            counters.add(s);
            offset += (s.length() + 1) * CHAR_TO_BYTES;
        }
        return counters;
    }

    public static List<String> PdhEnumObjectItemInstances(String szDataSource, String szMachineName, String szObjectName, int dwDetailLevel) {
        ArrayList<String> instances = new ArrayList<String>();
        WinDef.DWORDByReference pcchCounterListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        WinDef.DWORDByReference pcchInstanceListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, null, pcchCounterListLength, null, pcchInstanceListLength, dwDetailLevel, 0);
        if (pcchCounterListLength.getValue().intValue() < 1 || pcchInstanceListLength.getValue().intValue() < 1) {
            return instances;
        }
        Memory mszCounterList = new Memory((long)(pcchCounterListLength.getValue().intValue() * CHAR_TO_BYTES));
        Memory mszInstanceList = new Memory((long)(pcchInstanceListLength.getValue().intValue() * CHAR_TO_BYTES));
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, (Pointer)mszCounterList, pcchCounterListLength, (Pointer)mszInstanceList, pcchInstanceListLength, dwDetailLevel, 0);
        int offset = 0;
        while ((long)offset < mszInstanceList.size()) {
            String s = null;
            s = CHAR_TO_BYTES == 1 ? mszInstanceList.getString((long)offset) : mszInstanceList.getWideString((long)offset);
            if (s.isEmpty()) break;
            instances.add(s);
            offset += (s.length() + 1) * CHAR_TO_BYTES;
        }
        return instances;
    }
}

