/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.jna.platform.windows.Cfgmgr32;
import oshi.jna.platform.windows.Cfgmgr32Util;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsUsbDevice
extends AbstractUsbDevice {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsUsbDevice.class);
    private static List<String> controllerDeviceIdList = new ArrayList<String>();
    private static final String PNPENTITY_BASE_CLASS = "Win32_PnPEntity";
    private static final WmiUtil.WmiQuery<PnPEntityProperty> PNPENTITY_QUERY;
    private static final String DISKDRIVE_BASE_CLASS = "Win32_DiskDrive";
    private static final WmiUtil.WmiQuery<DiskDriveProperty> DISKDRIVE_QUERY;
    private static final String PHYSICALMEDIA_BASE_CLASS = "Win32_PhysicalMedia";
    private static final WmiUtil.WmiQuery<DiskDriveProperty> PHYSICALMEDIA_QUERY;
    private static final Pattern VENDOR_PRODUCT_ID;
    private static Map<String, WindowsUsbDevice> usbDeviceCache;
    private static Set<String> devicesToAdd;
    private static Set<String> devicesToRemove;
    private static Map<String, List<String>> deviceTreeMap;

    public WindowsUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, UsbDevice[] connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, connectedDevices);
    }

    public static UsbDevice[] getUsbDevices(boolean tree) {
        UsbDevice[] devices = WindowsUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList.toArray(new UsbDevice[deviceList.size()]);
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, UsbDevice[] connectedDevices) {
        for (UsbDevice device : connectedDevices) {
            deviceList.add(new WindowsUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), new UsbDevice[0]));
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static UsbDevice[] getUsbDevices() {
        deviceTreeMap.clear();
        devicesToAdd.clear();
        devicesToRemove = new HashSet<String>(usbDeviceCache.keySet());
        ArrayList<WindowsUsbDevice> controllerDevices = new ArrayList<WindowsUsbDevice>();
        for (String controllerDeviceId : controllerDeviceIdList) {
            WindowsUsbDevice.putChildrenInDeviceTree(controllerDeviceId, 0);
            WindowsUsbDevice.updateDeviceCache();
            controllerDevices.add(WindowsUsbDevice.getDeviceAndChildren(controllerDeviceId, "0000", "0000"));
        }
        return controllerDevices.toArray(new WindowsUsbDevice[controllerDevices.size()]);
    }

    private static void updateDeviceCache() {
        for (String deviceID : devicesToRemove) {
            usbDeviceCache.remove(deviceID);
            LOG.debug("Removing {} from USB device cache.", (Object)deviceID);
        }
        devicesToRemove.clear();
        if (!devicesToAdd.isEmpty()) {
            WindowsUsbDevice device;
            String pnpDeviceID;
            int i;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String deviceID : devicesToAdd) {
                if (first) {
                    sb.append(" WHERE (PnPDeviceID=\"");
                    first = false;
                } else {
                    sb.append(" OR (PnPDeviceID=\"");
                }
                sb.append(deviceID).append("\")");
            }
            String whereClause = sb.toString();
            PNPENTITY_QUERY.setWmiClassName(PNPENTITY_BASE_CLASS + whereClause);
            WmiUtil.WmiResult<PnPEntityProperty> pnpEntity = WmiUtil.queryWMI(PNPENTITY_QUERY);
            for (int i2 = 0; i2 < pnpEntity.getResultCount(); ++i2) {
                String pnpDeviceID2 = (String)pnpEntity.get(PnPEntityProperty.PNPDEVICEID).get(i2);
                String name = (String)pnpEntity.get(PnPEntityProperty.NAME).get(i2);
                String vendor = (String)pnpEntity.get(PnPEntityProperty.MANUFACTURER).get(i2);
                WindowsUsbDevice device2 = new WindowsUsbDevice(name, vendor, null, null, "", new WindowsUsbDevice[0]);
                usbDeviceCache.put(pnpDeviceID2, device2);
                LOG.debug("Adding {} to USB device cache.", (Object)pnpDeviceID2);
            }
            DISKDRIVE_QUERY.setWmiClassName(DISKDRIVE_BASE_CLASS + whereClause);
            WmiUtil.WmiResult<DiskDriveProperty> serialNumber = WmiUtil.queryWMI(DISKDRIVE_QUERY);
            for (i = 0; i < serialNumber.getResultCount(); ++i) {
                pnpDeviceID = (String)serialNumber.get(DiskDriveProperty.PNPDEVICEID).get(i);
                if (!usbDeviceCache.containsKey(pnpDeviceID)) continue;
                device = usbDeviceCache.get(pnpDeviceID);
                device.serialNumber = ParseUtil.hexStringToString((String)serialNumber.get(DiskDriveProperty.SERIALNUMBER).get(i));
            }
            PHYSICALMEDIA_QUERY.setWmiClassName(PHYSICALMEDIA_BASE_CLASS + whereClause);
            serialNumber = WmiUtil.queryWMI(PHYSICALMEDIA_QUERY);
            for (i = 0; i < serialNumber.getResultCount(); ++i) {
                pnpDeviceID = (String)serialNumber.get(DiskDriveProperty.PNPDEVICEID).get(i);
                if (!usbDeviceCache.containsKey(pnpDeviceID)) continue;
                device = usbDeviceCache.get(pnpDeviceID);
                device.serialNumber = ParseUtil.hexStringToString((String)serialNumber.get(DiskDriveProperty.SERIALNUMBER).get(i));
            }
        }
    }

    private static void putChildrenInDeviceTree(String deviceId, int deviceInstance) {
        IntByReference child;
        int devInst;
        devicesToRemove.remove(deviceId);
        if (!usbDeviceCache.containsKey(deviceId)) {
            devicesToAdd.add(deviceId);
        }
        if ((devInst = deviceInstance) == 0) {
            IntByReference pdnDevInst = new IntByReference();
            Cfgmgr32.INSTANCE.CM_Locate_DevNode(pdnDevInst, deviceId, 0);
            devInst = pdnDevInst.getValue();
        }
        if (0 == Cfgmgr32.INSTANCE.CM_Get_Child(child = new IntByReference(), devInst, 0)) {
            ArrayList<String> childList = new ArrayList<String>();
            String childId = Cfgmgr32Util.CM_Get_Device_ID(child.getValue());
            childList.add(childId);
            deviceTreeMap.put(deviceId, childList);
            WindowsUsbDevice.putChildrenInDeviceTree(childId, child.getValue());
            IntByReference sibling = new IntByReference();
            while (0 == Cfgmgr32.INSTANCE.CM_Get_Sibling(sibling, child.getValue(), 0)) {
                String siblingId = Cfgmgr32Util.CM_Get_Device_ID(sibling.getValue());
                deviceTreeMap.get(deviceId).add(siblingId);
                WindowsUsbDevice.putChildrenInDeviceTree(siblingId, sibling.getValue());
                child = sibling;
            }
        }
    }

    private static WindowsUsbDevice getDeviceAndChildren(String hubDeviceId, String vid, String pid) {
        String vendorId = vid;
        String productId = pid;
        Matcher m = VENDOR_PRODUCT_ID.matcher(hubDeviceId);
        if (m.matches()) {
            vendorId = m.group(1).toLowerCase();
            productId = m.group(2).toLowerCase();
        }
        List pnpDeviceIds = MapUtil.getOrDefault(deviceTreeMap, hubDeviceId, new ArrayList());
        ArrayList<WindowsUsbDevice> usbDevices = new ArrayList<WindowsUsbDevice>();
        for (String pnpDeviceId : pnpDeviceIds) {
            usbDevices.add(WindowsUsbDevice.getDeviceAndChildren(pnpDeviceId, vendorId, productId));
        }
        Collections.sort(usbDevices);
        WindowsUsbDevice device = usbDeviceCache.get(hubDeviceId);
        if (device.name.isEmpty()) {
            device.name = vendorId + ":" + productId;
        }
        device.vendorId = vendorId;
        device.productId = productId;
        device.connectedDevices = usbDevices.toArray(new WindowsUsbDevice[usbDevices.size()]);
        return device;
    }

    static {
        WmiUtil.WmiQuery<USBControllerProperty> usbControllerQuery = WmiUtil.createQuery("Win32_USBController", USBControllerProperty.class);
        WmiUtil.WmiResult<USBControllerProperty> usbController = WmiUtil.queryWMI(usbControllerQuery);
        for (int i = 0; i < usbController.getResultCount(); ++i) {
            controllerDeviceIdList.add((String)usbController.get(USBControllerProperty.PNPDEVICEID).get(i));
        }
        PNPENTITY_QUERY = WmiUtil.createQuery(null, PnPEntityProperty.class);
        DISKDRIVE_QUERY = WmiUtil.createQuery(null, DiskDriveProperty.class);
        PHYSICALMEDIA_QUERY = WmiUtil.createQuery(null, DiskDriveProperty.class);
        VENDOR_PRODUCT_ID = Pattern.compile(".*(?:VID|VEN)_(\\p{XDigit}{4})&(?:PID|DEV)_(\\p{XDigit}{4}).*");
        usbDeviceCache = new HashMap<String, WindowsUsbDevice>();
        devicesToAdd = new HashSet<String>();
        devicesToRemove = new HashSet<String>();
        deviceTreeMap = new HashMap<String, List<String>>();
    }

    static enum DiskDriveProperty implements WmiUtil.WmiProperty
    {
        PNPDEVICEID(WmiUtil.ValueType.STRING),
        SERIALNUMBER(WmiUtil.ValueType.STRING);

        private WmiUtil.ValueType type;

        private DiskDriveProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }

    static enum PnPEntityProperty implements WmiUtil.WmiProperty
    {
        NAME(WmiUtil.ValueType.STRING),
        MANUFACTURER(WmiUtil.ValueType.STRING),
        PNPDEVICEID(WmiUtil.ValueType.STRING);

        private WmiUtil.ValueType type;

        private PnPEntityProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }

    static enum USBControllerProperty implements WmiUtil.WmiProperty
    {
        PNPDEVICEID(WmiUtil.ValueType.STRING);

        private WmiUtil.ValueType type;

        private USBControllerProperty(WmiUtil.ValueType type) {
            this.type = type;
        }

        @Override
        public WmiUtil.ValueType getType() {
            return this.type;
        }
    }
}

