/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.Serializable;
import oshi.jna.platform.linux.Udev;
import oshi.util.ParseUtil;

public class LinuxBlockDevStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String device;
    public final long read_ops;
    public final long read_merged;
    public final long read_512bytes;
    public final long read_waits_ms;
    public final long write_ops;
    public final long write_merged;
    public final long write_512bytes;
    public final long write_waits_ms;
    public final long in_flight;
    public final long active_ms;
    public final long waits_ms;

    public LinuxBlockDevStats(String device, Udev.UdevDevice disk) {
        String devstat = Udev.INSTANCE.udev_device_get_sysattr_value(disk, "stat");
        String[] splitstats = ParseUtil.whitespaces.split(devstat);
        if (splitstats.length < 11) {
            throw new IllegalStateException("Unexpected length of array: " + splitstats.length);
        }
        int startIndex = splitstats.length - 11;
        this.device = device;
        this.read_ops = ParseUtil.parseLongOrDefault(splitstats[startIndex + 0], 0L);
        this.read_merged = ParseUtil.parseLongOrDefault(splitstats[startIndex + 1], 0L);
        this.read_512bytes = ParseUtil.parseLongOrDefault(splitstats[startIndex + 2], 0L);
        this.read_waits_ms = ParseUtil.parseLongOrDefault(splitstats[startIndex + 3], 0L);
        this.write_ops = ParseUtil.parseLongOrDefault(splitstats[startIndex + 4], 0L);
        this.write_merged = ParseUtil.parseLongOrDefault(splitstats[startIndex + 5], 0L);
        this.write_512bytes = ParseUtil.parseLongOrDefault(splitstats[startIndex + 6], 0L);
        this.write_waits_ms = ParseUtil.parseLongOrDefault(splitstats[startIndex + 7], 0L);
        this.in_flight = ParseUtil.parseLongOrDefault(splitstats[startIndex + 8], 0L);
        this.active_ms = ParseUtil.parseLongOrDefault(splitstats[startIndex + 9], 0L);
        this.waits_ms = ParseUtil.parseLongOrDefault(splitstats[startIndex + 10], 0L);
    }
}

