/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.software.os.impl;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.software.os.NetworkParams;
import oshi.json.util.PropertiesUtil;

public class NetworkParamsImpl
extends AbstractOshiJsonObject
implements NetworkParams {
    private static final long serialVersionUID = 1L;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.software.os.NetworkParams networkParams;

    public NetworkParamsImpl(oshi.software.os.NetworkParams networkParams) {
        this.networkParams = networkParams;
    }

    @Override
    public String getHostName() {
        return this.networkParams.getHostName();
    }

    @Override
    public String getDomainName() {
        return this.networkParams.getDomainName();
    }

    @Override
    public String[] getDnsServers() {
        return this.networkParams.getDnsServers();
    }

    @Override
    public String getIpv4DefaultGateway() {
        return this.networkParams.getIpv4DefaultGateway();
    }

    @Override
    public String getIpv6DefaultGateway() {
        return this.networkParams.getIpv6DefaultGateway();
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.networkParams.hostName")) {
            json.add("hostName", this.getHostName());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.networkParams.domainName")) {
            json.add("domainName", this.getDomainName());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.networkParams.dnsServers")) {
            JsonArrayBuilder nameServerArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (String server : this.getDnsServers()) {
                nameServerArrayBuilder.add(server);
            }
            json.add("dnsServers", (JsonValue)nameServerArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.networkParams.ipv4DefaultGateway")) {
            json.add("ipv4DefaultGateway", this.getIpv4DefaultGateway());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.networkParams.ipv6DefaultGateway")) {
            json.add("ipv6DefaultGateway", this.getIpv6DefaultGateway());
        }
        return json.build();
    }
}

