/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.data.windows.PerfCounterQuery;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.util.MapUtil;

public class WindowsGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsGlobalMemory.class);
    private long lastUpdate = 0L;
    private transient PerfCounterQuery<PageSwapProperty> memoryPerfCounters = new PerfCounterQuery<PageSwapProperty>(PageSwapProperty.class, "Memory", "Win32_PerfRawData_PerfOS_Memory");
    private transient PerfCounterQuery<PagingPercentProperty> pagingPerfCounters = new PerfCounterQuery<PagingPercentProperty>(PagingPercentProperty.class, "Paging File", "Win32_PerfRawData_PerfOS_PagingFile");

    @Override
    protected void updateMeminfo() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate > 100L) {
            if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
                LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
                return;
            }
            this.pageSize = perfInfo.PageSize.longValue();
            this.memAvailable = this.pageSize * perfInfo.PhysicalAvailable.longValue();
            this.memTotal = this.pageSize * perfInfo.PhysicalTotal.longValue();
            this.swapTotal = this.pageSize * (perfInfo.CommitLimit.longValue() - perfInfo.PhysicalTotal.longValue());
            if (this.swapTotal > 0L) {
                this.updateSwapCounters();
            }
            this.lastUpdate = now;
        }
    }

    private void updateSwapCounters() {
        Map<PageSwapProperty, Long> valueMap = this.memoryPerfCounters.queryValues();
        this.swapPagesIn = MapUtil.getOrDefault(valueMap, PageSwapProperty.PAGESINPUTPERSEC, 0L);
        this.swapPagesOut = MapUtil.getOrDefault(valueMap, PageSwapProperty.PAGESOUTPUTPERSEC, 0L);
    }

    @Override
    protected void updateSwap() {
        this.updateMeminfo();
        Map<PagingPercentProperty, Long> valueMap = this.pagingPerfCounters.queryValues();
        this.swapUsed = MapUtil.getOrDefault(valueMap, PagingPercentProperty.PERCENTUSAGE, 0L);
    }

    static enum PagingPercentProperty implements PerfCounterQuery.PdhCounterProperty
    {
        PERCENTUSAGE("_Total", "% Usage");

        private final String instance;
        private final String counter;

        private PagingPercentProperty(String instance, String counter) {
            this.instance = instance;
            this.counter = counter;
        }

        @Override
        public String getInstance() {
            return this.instance;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }

    public static enum PageSwapProperty implements PerfCounterQuery.PdhCounterProperty
    {
        PAGESINPUTPERSEC(null, "Pages Input/sec"),
        PAGESOUTPUTPERSEC(null, "Pages Output/sec");

        private final String instance;
        private final String counter;

        private PageSwapProperty(String instance, String counter) {
            this.instance = instance;
            this.counter = counter;
        }

        @Override
        public String getInstance() {
            return this.instance;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }
}

