/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.hardware;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.platform.linux.LinuxDisks;
import oshi.hardware.platform.mac.MacDisks;
import oshi.hardware.platform.unix.freebsd.FreeBsdDisks;
import oshi.hardware.platform.unix.solaris.SolarisDisks;
import oshi.hardware.platform.windows.WindowsDisks;
import oshi.json.SystemInfo;
import oshi.json.hardware.HWPartition;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.util.PropertiesUtil;

public class HWDiskStore
extends AbstractOshiJsonObject
implements Comparable<HWDiskStore> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HWDiskStore.class);
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.hardware.HWDiskStore diskStore;

    public HWDiskStore() {
        this.diskStore = new oshi.hardware.HWDiskStore();
    }

    public HWDiskStore(oshi.hardware.HWDiskStore diskStore) {
        this.diskStore = new oshi.hardware.HWDiskStore(diskStore);
    }

    public boolean updateDiskStats() {
        boolean diskFound = false;
        switch (SystemInfo.getCurrentPlatformEnum()) {
            case WINDOWS: {
                diskFound = WindowsDisks.updateDiskStats(this.diskStore);
                break;
            }
            case LINUX: {
                diskFound = LinuxDisks.updateDiskStats(this.diskStore);
                break;
            }
            case MACOSX: {
                diskFound = MacDisks.updateDiskStats(this.diskStore);
                break;
            }
            case SOLARIS: {
                diskFound = SolarisDisks.updateDiskStats(this.diskStore);
                break;
            }
            case FREEBSD: {
                diskFound = FreeBsdDisks.updateDiskStats(this.diskStore);
                break;
            }
            default: {
                LOG.error("Unsupported platform. No update performed.");
            }
        }
        return diskFound;
    }

    public String getName() {
        return this.diskStore.getName();
    }

    public String getModel() {
        return this.diskStore.getModel();
    }

    public String getSerial() {
        return this.diskStore.getSerial();
    }

    public long getSize() {
        return this.diskStore.getSize();
    }

    public long getReads() {
        return this.diskStore.getReads();
    }

    public long getReadBytes() {
        return this.diskStore.getReadBytes();
    }

    public long getWrites() {
        return this.diskStore.getWrites();
    }

    public long getWriteBytes() {
        return this.diskStore.getWriteBytes();
    }

    public long getCurrentQueueLength() {
        return this.diskStore.getCurrentQueueLength();
    }

    public long getTransferTime() {
        return this.diskStore.getTransferTime();
    }

    public HWPartition[] getPartitions() {
        HWPartition[] partitions = new HWPartition[this.diskStore.getPartitions().length];
        for (int i = 0; i < partitions.length; ++i) {
            partitions[i] = new HWPartition(this.diskStore.getPartitions()[i].getIdentification(), this.diskStore.getPartitions()[i].getName(), this.diskStore.getPartitions()[i].getType(), this.diskStore.getPartitions()[i].getUuid(), this.diskStore.getPartitions()[i].getSize(), this.diskStore.getPartitions()[i].getMajor(), this.diskStore.getPartitions()[i].getMinor(), this.diskStore.getPartitions()[i].getMountPoint());
        }
        return partitions;
    }

    public long getTimeStamp() {
        return this.diskStore.getTimeStamp();
    }

    public void setName(String name) {
        this.diskStore.setName(name);
    }

    public void setModel(String model) {
        this.diskStore.setModel(model);
    }

    public void setSerial(String serial) {
        this.diskStore.setSerial(serial);
    }

    public void setSize(long size) {
        this.diskStore.setSize(size);
    }

    public void setReads(long reads) {
        this.diskStore.setReads(reads);
    }

    public void setReadBytes(long readBytes) {
        this.diskStore.setReadBytes(readBytes);
    }

    public void setWrites(long writes) {
        this.diskStore.setWrites(writes);
    }

    public void setWriteBytes(long writeBytes) {
        this.diskStore.setWriteBytes(writeBytes);
    }

    public void setCurrentQueueLength(long currentQueueLength) {
        this.diskStore.setCurrentQueueLength(currentQueueLength);
    }

    public void setTransferTime(long transferTime) {
        this.diskStore.setTransferTime(transferTime);
    }

    public void setPartitions(HWPartition[] partitions) {
        oshi.hardware.HWPartition[] parts = new oshi.hardware.HWPartition[partitions.length];
        for (int i = 0; i < partitions.length; ++i) {
            parts[i] = new oshi.hardware.HWPartition(partitions[i].getIdentification(), partitions[i].getName(), partitions[i].getType(), partitions[i].getUuid(), partitions[i].getSize(), partitions[i].getMajor(), partitions[i].getMinor(), partitions[i].getMountPoint());
        }
        this.diskStore.setPartitions(parts);
    }

    public void setTimeStamp(long timeStamp) {
        this.diskStore.setTimeStamp(timeStamp);
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.name")) {
            json.add("name", this.diskStore.getName());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.model")) {
            json.add("model", this.diskStore.getModel());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.serial")) {
            json.add("serial", this.diskStore.getSerial());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.size")) {
            json.add("size", this.diskStore.getSize());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.reads")) {
            json.add("reads", this.diskStore.getReads());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.readBytes")) {
            json.add("readBytes", this.diskStore.getReadBytes());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.writes")) {
            json.add("writes", this.diskStore.getWrites());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.writeBytes")) {
            json.add("writeBytes", this.diskStore.getWriteBytes());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.queueLength")) {
            json.add("currentQueueLength", this.diskStore.getCurrentQueueLength());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.transferTime")) {
            json.add("transferTime", this.diskStore.getTransferTime());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.partitions")) {
            JsonArrayBuilder partitionArrayBuilder = this.jsonFactory.createArrayBuilder();
            for (HWPartition partition : this.getPartitions()) {
                partitionArrayBuilder.add((JsonValue)partition.toJSON(properties));
            }
            json.add("partitions", (JsonValue)partitionArrayBuilder.build());
        }
        if (PropertiesUtil.getBoolean(properties, "hardware.disks.timeStamp")) {
            json.add("timeStamp", this.diskStore.getTimeStamp());
        }
        return json.build();
    }

    @Override
    public int compareTo(HWDiskStore store) {
        return this.diskStore.compareTo(store.diskStore);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.diskStore == null ? 0 : this.diskStore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HWDiskStore)) {
            return false;
        }
        HWDiskStore other = (HWDiskStore)obj;
        return !(this.diskStore == null ? other.diskStore != null : !this.diskStore.equals(other.diskStore));
    }
}

