/*
 * Decompiled with CFR 0.152.
 */
package oshi.demo.gui;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.text.DefaultCaret;
import oshi.SystemInfo;
import oshi.demo.gui.OshiJPanel;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.UsbDevice;

public class UsbPanel
extends OshiJPanel {
    private static final long serialVersionUID = 1L;
    private static final String USB_DEVICES = "USB Devices";

    public UsbPanel(SystemInfo si) {
        this.init(si.getHardware());
    }

    private void init(HardwareAbstractionLayer hal) {
        JLabel usb = new JLabel(USB_DEVICES);
        this.add((Component)usb, "North");
        JTextArea usbArea = new JTextArea(60, 20);
        JScrollPane scrollV = new JScrollPane(usbArea);
        scrollV.setVerticalScrollBarPolicy(20);
        DefaultCaret caret = (DefaultCaret)usbArea.getCaret();
        caret.setUpdatePolicy(1);
        usbArea.setText(UsbPanel.getUsbString(hal));
        this.add((Component)scrollV, "Center");
        Timer timer = new Timer(5000, e -> usbArea.setText(UsbPanel.getUsbString(hal)));
        timer.start();
    }

    private static String getUsbString(HardwareAbstractionLayer hal) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (UsbDevice usbDevice : hal.getUsbDevices(true)) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(String.valueOf(usbDevice));
        }
        return sb.toString();
    }
}

