/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.PerfCounterWildcardQuery;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

public class WindowsFileSystem
implements FileSystem {
    private static final int BUFSIZE = 255;
    private static final int SEM_FAILCRITICALERRORS = 1;
    private final WbemcliUtil.WmiQuery<LogicalDiskProperty> logicalDiskQuery = new WbemcliUtil.WmiQuery("Win32_LogicalDisk", LogicalDiskProperty.class);
    private final WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();
    private final PerfCounterWildcardQuery<HandleCountProperty> handlePerfCounters = new PerfCounterWildcardQuery<HandleCountProperty>(HandleCountProperty.class, "Process", "Win32_Process");
    private static final long MAX_WINDOWS_HANDLES = System.getenv("ProgramFiles(x86)") == null ? 0xFF8000L : 0xFF0000L;

    public WindowsFileSystem() {
        Kernel32.INSTANCE.SetErrorMode(1);
    }

    @Override
    public OSFileStore[] getFileStores() {
        ArrayList<OSFileStore> result = this.getLocalVolumes(null);
        HashMap<String, OSFileStore> volumeMap = new HashMap<String, OSFileStore>();
        for (OSFileStore volume : result) {
            volumeMap.put(volume.getMount(), volume);
        }
        for (OSFileStore wmiVolume : this.getWmiVolumes(null)) {
            if (volumeMap.containsKey(wmiVolume.getMount())) {
                ((OSFileStore)volumeMap.get(wmiVolume.getMount())).setName(wmiVolume.getName());
                continue;
            }
            result.add(wmiVolume);
        }
        return result.toArray(new OSFileStore[0]);
    }

    private ArrayList<OSFileStore> getLocalVolumes(String nameToMatch) {
        boolean retVal;
        ArrayList<OSFileStore> fs = new ArrayList<OSFileStore>();
        char[] aVolume = new char[255];
        WinNT.HANDLE hVol = Kernel32.INSTANCE.FindFirstVolume(aVolume, 255);
        if (hVol == WinBase.INVALID_HANDLE_VALUE) {
            return fs;
        }
        do {
            char[] fstype = new char[16];
            char[] name = new char[255];
            char[] mount = new char[255];
            WinNT.LARGE_INTEGER userFreeBytes = new WinNT.LARGE_INTEGER(0L);
            WinNT.LARGE_INTEGER totalBytes = new WinNT.LARGE_INTEGER(0L);
            WinNT.LARGE_INTEGER systemFreeBytes = new WinNT.LARGE_INTEGER(0L);
            String volume = new String(aVolume).trim();
            Kernel32.INSTANCE.GetVolumeInformation(volume, name, 255, null, null, null, fstype, 16);
            Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(volume, mount, 255, null);
            String strMount = new String(mount).trim();
            String strName = new String(name).trim();
            String strFsType = new String(fstype).trim();
            String osName = String.format("%s (%s)", strName, strMount);
            if (nameToMatch != null && !nameToMatch.equals(osName)) continue;
            Kernel32.INSTANCE.GetDiskFreeSpaceEx(volume, userFreeBytes, totalBytes, systemFreeBytes);
            String uuid = ParseUtil.parseUuidOrDefault(volume, "");
            if (strMount.isEmpty()) continue;
            OSFileStore osStore = new OSFileStore();
            osStore.setName(osName);
            osStore.setVolume(volume);
            osStore.setMount(strMount);
            osStore.setDescription(this.getDriveType(strMount));
            osStore.setType(strFsType);
            osStore.setUUID(uuid);
            osStore.setFreeSpace(systemFreeBytes.getValue());
            osStore.setUsableSpace(userFreeBytes.getValue());
            osStore.setTotalSpace(totalBytes.getValue());
            fs.add(osStore);
        } while (retVal = Kernel32.INSTANCE.FindNextVolume(hVol, aVolume, 255));
        Kernel32.INSTANCE.FindVolumeClose(hVol);
        return fs;
    }

    private List<OSFileStore> getWmiVolumes(String nameToMatch) {
        ArrayList<OSFileStore> fs = new ArrayList<OSFileStore>();
        String wmiClassName = this.logicalDiskQuery.getWmiClassName();
        if (nameToMatch != null) {
            this.logicalDiskQuery.setWmiClassName(wmiClassName + " WHERE Name=\"" + nameToMatch + "\"");
        }
        WbemcliUtil.WmiResult<LogicalDiskProperty> drives = this.wmiQueryHandler.queryWMI(this.logicalDiskQuery);
        if (nameToMatch != null) {
            this.logicalDiskQuery.setWmiClassName(wmiClassName);
        }
        for (int i = 0; i < drives.getResultCount(); ++i) {
            String volume;
            long free = WmiUtil.getUint64(drives, LogicalDiskProperty.FREESPACE, i);
            long total = WmiUtil.getUint64(drives, LogicalDiskProperty.SIZE, i);
            String description = WmiUtil.getString(drives, LogicalDiskProperty.DESCRIPTION, i);
            String name = WmiUtil.getString(drives, LogicalDiskProperty.NAME, i);
            int type = WmiUtil.getUint32(drives, LogicalDiskProperty.DRIVETYPE, i);
            if (type != 4) {
                char[] chrVolume = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(name + "\\", chrVolume, 255);
                volume = new String(chrVolume).trim();
            } else {
                volume = WmiUtil.getString(drives, LogicalDiskProperty.PROVIDERNAME, i);
                String[] split = volume.split("\\\\");
                if (split.length > 1 && split[split.length - 1].length() > 0) {
                    description = split[split.length - 1];
                }
            }
            OSFileStore osStore = new OSFileStore();
            osStore.setName(String.format("%s (%s)", description, name));
            osStore.setVolume(volume);
            osStore.setMount(name + "\\");
            osStore.setDescription(this.getDriveType(name));
            osStore.setType(WmiUtil.getString(drives, LogicalDiskProperty.FILESYSTEM, i));
            osStore.setUUID("");
            osStore.setFreeSpace(free);
            osStore.setUsableSpace(free);
            osStore.setTotalSpace(total);
            fs.add(osStore);
        }
        return fs;
    }

    private String getDriveType(String drive) {
        switch (Kernel32.INSTANCE.GetDriveType(drive)) {
            case 2: {
                return "Removable drive";
            }
            case 3: {
                return "Fixed drive";
            }
            case 4: {
                return "Network drive";
            }
            case 5: {
                return "CD-ROM";
            }
            case 6: {
                return "RAM drive";
            }
        }
        return "Unknown drive type";
    }

    @Override
    public long getOpenFileDescriptors() {
        Map<HandleCountProperty, List<Long>> valueListMap = this.handlePerfCounters.queryValuesWildcard();
        List<Long> valueList = valueListMap.get(HandleCountProperty.HANDLECOUNT);
        long descriptors = 0L;
        if (valueList != null) {
            for (int i = 0; i < valueList.size(); ++i) {
                descriptors += valueList.get(i).longValue();
            }
        }
        return descriptors;
    }

    @Override
    public long getMaxFileDescriptors() {
        return MAX_WINDOWS_HANDLES;
    }

    public static boolean updateFileStoreStats(OSFileStore osFileStore) {
        WindowsFileSystem wfs = new WindowsFileSystem();
        List<OSFileStore> volumes = wfs.getLocalVolumes(osFileStore.getName());
        if (volumes.isEmpty()) {
            volumes = wfs.getWmiVolumes(osFileStore.getName());
        }
        for (OSFileStore fileStore : volumes) {
            if (!osFileStore.getVolume().equals(fileStore.getVolume()) || !osFileStore.getMount().equals(fileStore.getMount())) continue;
            osFileStore.setLogicalVolume(fileStore.getLogicalVolume());
            osFileStore.setDescription(fileStore.getDescription());
            osFileStore.setType(fileStore.getType());
            osFileStore.setFreeSpace(fileStore.getFreeSpace());
            osFileStore.setUsableSpace(fileStore.getUsableSpace());
            osFileStore.setTotalSpace(fileStore.getTotalSpace());
            osFileStore.setFreeInodes(fileStore.getFreeInodes());
            osFileStore.setTotalInodes(fileStore.getTotalInodes());
            return true;
        }
        return false;
    }

    static enum HandleCountProperty implements PerfCounterWildcardQuery.PdhCounterWildcardProperty
    {
        NAME("_Total"),
        HANDLECOUNT("Handle Count");

        private final String counter;

        private HandleCountProperty(String counter) {
            this.counter = counter;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }

    static enum LogicalDiskProperty {
        DESCRIPTION,
        DRIVETYPE,
        FILESYSTEM,
        FREESPACE,
        NAME,
        PROVIDERNAME,
        SIZE;

    }
}

