/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.common.AbstractVirtualMemory;
import oshi.util.platform.windows.PerfCounterQuery;

public class WindowsVirtualMemory
extends AbstractVirtualMemory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsVirtualMemory.class);
    private transient long pageSize;
    private transient PerfCounterQuery<PageSwapProperty> memoryPerfCounters = new PerfCounterQuery<PageSwapProperty>(PageSwapProperty.class, "Memory", "Win32_PerfRawData_PerfOS_Memory");
    private transient PerfCounterQuery<PagingPercentProperty> pagingPerfCounters = new PerfCounterQuery<PagingPercentProperty>(PagingPercentProperty.class, "Paging File", "Win32_PerfRawData_PerfOS_PagingFile");
    private transient long lastSwapUpdateNanos = 0L;

    public WindowsVirtualMemory(long pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public long getSwapUsed() {
        Map<PagingPercentProperty, Long> valueMap = this.pagingPerfCounters.queryValues();
        return valueMap.getOrDefault(PagingPercentProperty.PERCENTUSAGE, 0L) * this.pageSize;
    }

    @Override
    public long getSwapTotal() {
        if (this.swapTotal < 0L) {
            Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
            if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
                LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
                return 0L;
            }
            this.swapTotal = this.pageSize * (perfInfo.CommitLimit.longValue() - perfInfo.PhysicalTotal.longValue());
        }
        return this.swapTotal;
    }

    @Override
    public long getSwapPagesIn() {
        this.updateSwapInOut();
        return this.swapPagesIn;
    }

    @Override
    public long getSwapPagesOut() {
        this.updateSwapInOut();
        return this.swapPagesOut;
    }

    private void updateSwapInOut() {
        if (System.nanoTime() - this.lastSwapUpdateNanos > 300000000L) {
            Map<PageSwapProperty, Long> valueMap = this.memoryPerfCounters.queryValues();
            this.swapPagesIn = valueMap.getOrDefault(PageSwapProperty.PAGESINPUTPERSEC, 0L);
            this.swapPagesOut = valueMap.getOrDefault(PageSwapProperty.PAGESOUTPUTPERSEC, 0L);
            this.lastSwapUpdateNanos = System.nanoTime();
        }
    }

    public static enum PageSwapProperty implements PerfCounterQuery.PdhCounterProperty
    {
        PAGESINPUTPERSEC(null, "Pages Input/sec"),
        PAGESOUTPUTPERSEC(null, "Pages Output/sec");

        private final String instance;
        private final String counter;

        private PageSwapProperty(String instance, String counter) {
            this.instance = instance;
            this.counter = counter;
        }

        @Override
        public String getInstance() {
            return this.instance;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }

    static enum PagingPercentProperty implements PerfCounterQuery.PdhCounterProperty
    {
        PERCENTUSAGE("_Total", "% Usage");

        private final String instance;
        private final String counter;

        private PagingPercentProperty(String instance, String counter) {
            this.instance = instance;
            this.counter = counter;
        }

        @Override
        public String getInstance() {
            return this.instance;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }
}

