/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import oshi.hardware.common.AbstractFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

final class FreeBsdFirmware
extends AbstractFirmware {
    private static final long serialVersionUID = 1L;

    FreeBsdFirmware() {
    }

    @Override
    public String getManufacturer() {
        if (this.manufacturer == null) {
            this.readDmiDecode();
        }
        return super.getManufacturer();
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.readDmiDecode();
        }
        return super.getVersion();
    }

    @Override
    public String getReleaseDate() {
        if (this.releaseDate == null) {
            this.readDmiDecode();
        }
        return super.getReleaseDate();
    }

    private void readDmiDecode() {
        String manufacturerMarker = "Vendor:";
        String versionMarker = "Version:";
        String releaseDateMarker = "Release Date:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t bios")) {
            if (checkLine.contains("Vendor:")) {
                String manufacturer = checkLine.split("Vendor:")[1].trim();
                this.manufacturer = manufacturer.isEmpty() ? "unknown" : manufacturer;
                continue;
            }
            if (checkLine.contains("Version:")) {
                String version = checkLine.split("Version:")[1].trim();
                this.version = version.isEmpty() ? "unknown" : version;
                continue;
            }
            if (!checkLine.contains("Release Date:")) continue;
            String releaseDate = checkLine.split("Release Date:")[1].trim();
            this.releaseDate = releaseDate.isEmpty() ? "unknown" : ParseUtil.parseMmDdYyyyToYyyyMmDD(releaseDate);
        }
    }
}

