/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import java.util.regex.Pattern;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.mac.MacBaseboard;
import oshi.hardware.platform.mac.MacFirmware;
import oshi.jna.platform.mac.IOKit;
import oshi.util.ExecutingCommand;
import oshi.util.platform.mac.IOKitUtil;

final class MacComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;

    MacComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = "Apple Inc.";
        }
        return super.getManufacturer();
    }

    @Override
    public String getModel() {
        if (this.model == null) {
            this.profileSystem();
        }
        return super.getModel();
    }

    @Override
    public String getSerialNumber() {
        if (this.serialNumber == null) {
            this.profileSystem();
        }
        return super.getSerialNumber();
    }

    @Override
    public Firmware getFirmware() {
        if (this.firmware == null) {
            this.firmware = this.initFirmware();
        }
        return this.firmware;
    }

    @Override
    public Baseboard getBaseboard() {
        if (this.baseboard == null) {
            this.baseboard = this.initBaseboard();
        }
        return this.baseboard;
    }

    private void profileSystem() {
        String modelNameMarker = "Model Name:";
        String modelIdMarker = "Model Identifier:";
        String modelName = "";
        String modelIdentifier = "";
        for (String checkLine : ExecutingCommand.runNative("system_profiler SPHardwareDataType")) {
            if (checkLine.contains("Model Name:")) {
                modelName = checkLine.split("Model Name:")[1].trim();
                continue;
            }
            if (checkLine.contains("Model Identifier:")) {
                modelIdentifier = checkLine.split("Model Identifier:")[1].trim();
                continue;
            }
            this.setVersionAndSerialNumber(checkLine);
        }
        this.setModelNameAndIdentifier(modelName, modelIdentifier);
    }

    private void setVersionAndSerialNumber(String checkLine) {
        String smcVersion;
        String bootRomVersion;
        String serialNumMarker = "Serial Number (system):";
        String smcMarker = "SMC Version (system):";
        String bootRomMarker = "Boot ROM Version:";
        if (checkLine.contains("Boot ROM Version:") && !(bootRomVersion = checkLine.split("Boot ROM Version:")[1].trim()).isEmpty()) {
            ((MacFirmware)this.getFirmware()).setVersion(bootRomVersion);
        }
        if (checkLine.contains("SMC Version (system):") && !(smcVersion = checkLine.split(Pattern.quote("SMC Version (system):"))[1].trim()).isEmpty()) {
            ((MacBaseboard)this.getBaseboard()).setVersion(smcVersion);
        }
        if (checkLine.contains("Serial Number (system):")) {
            String serialNumberSystem = checkLine.split(Pattern.quote("Serial Number (system):"))[1].trim();
            this.serialNumber = serialNumberSystem.isEmpty() ? this.getIORegistryPlatformSerialNumber() : serialNumberSystem;
            ((MacBaseboard)this.getBaseboard()).setSerialNumber(this.serialNumber);
        }
    }

    private MacFirmware initFirmware() {
        MacFirmware firmware = new MacFirmware();
        firmware.setManufacturer(this.getManufacturer());
        firmware.setName("EFI");
        return firmware;
    }

    private MacBaseboard initBaseboard() {
        MacBaseboard baseboard = new MacBaseboard();
        baseboard.setManufacturer(this.getManufacturer());
        baseboard.setModel("SMC");
        return baseboard;
    }

    private void setModelNameAndIdentifier(String modelName, String modelIdentifier) {
        this.model = modelName.isEmpty() && !modelIdentifier.isEmpty() ? modelIdentifier : (!modelName.isEmpty() && !modelIdentifier.isEmpty() ? modelName + " (" + modelIdentifier + ")" : (modelName.isEmpty() ? "unknown" : modelName));
    }

    private String getIORegistryPlatformSerialNumber() {
        String serialNumber = null;
        int service = IOKitUtil.getMatchingService("IOPlatformExpertDevice");
        if (service != 0) {
            serialNumber = IOKitUtil.getIORegistryStringProperty(service, "IOPlatformSerialNumber");
            IOKit.INSTANCE.IOObjectRelease(service);
        }
        return serialNumber;
    }
}

