/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

public class LinuxPowerSource
extends AbstractPowerSource {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxPowerSource.class);
    private static final String PS_PATH = "/sys/class/power_supply/";

    public LinuxPowerSource(String newName, double newRemainingCapacity, double newTimeRemaining) {
        super(newName, newRemainingCapacity, newTimeRemaining);
        LOG.debug("Initialized LinuxPowerSource");
    }

    public static PowerSource[] getPowerSources() {
        File f = new File(PS_PATH);
        String[] psNames = f.list();
        if (psNames == null) {
            psNames = new String[]{};
        }
        ArrayList<LinuxPowerSource> psList = new ArrayList<LinuxPowerSource>(psNames.length);
        for (String psName : psNames) {
            List<String> psInfo;
            if (psName.startsWith("ADP") || psName.startsWith("AC") || (psInfo = FileUtil.readFile(PS_PATH + psName + "/uevent", false)).isEmpty()) continue;
            boolean isPresent = false;
            boolean isCharging = false;
            String name = "Unknown";
            int energyNow = 0;
            int energyFull = 1;
            int powerNow = 1;
            for (String checkLine : psInfo) {
                String[] psSplit;
                if (checkLine.startsWith("POWER_SUPPLY_PRESENT")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length > 1) {
                        boolean bl = isPresent = ParseUtil.parseIntOrDefault(psSplit[1], 0) > 0;
                    }
                    if (isPresent) continue;
                    break;
                }
                if (checkLine.startsWith("POWER_SUPPLY_NAME")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1) continue;
                    name = psSplit[1];
                    continue;
                }
                if (checkLine.startsWith("POWER_SUPPLY_ENERGY_NOW") || checkLine.startsWith("POWER_SUPPLY_CHARGE_NOW")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1) continue;
                    energyNow = ParseUtil.parseIntOrDefault(psSplit[1], 0);
                    continue;
                }
                if (checkLine.startsWith("POWER_SUPPLY_ENERGY_FULL") || checkLine.startsWith("POWER_SUPPLY_CHARGE_FULL")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1 || (energyFull = ParseUtil.parseIntOrDefault(psSplit[1], 1)) >= 1) continue;
                    energyFull = 1;
                    continue;
                }
                if (checkLine.startsWith("POWER_SUPPLY_STATUS")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1 || !"Charging".equals(psSplit[1])) continue;
                    isCharging = true;
                    continue;
                }
                if (!checkLine.startsWith("POWER_SUPPLY_POWER_NOW") && !checkLine.startsWith("POWER_SUPPLY_CURRENT_NOW")) continue;
                psSplit = checkLine.split("=");
                if (psSplit.length > 1) {
                    powerNow = ParseUtil.parseIntOrDefault(psSplit[1], 1);
                }
                if (powerNow >= true) continue;
                isCharging = true;
            }
            if (!isPresent) continue;
            psList.add(new LinuxPowerSource(name, (double)energyNow / (double)energyFull, isCharging ? -2.0 : 3600.0 * (double)energyNow / (double)powerNow));
        }
        return psList.toArray(new LinuxPowerSource[0]);
    }

    @Override
    public void updateAttributes() {
        PowerSource[] psArr;
        for (PowerSource ps : psArr = LinuxPowerSource.getPowerSources()) {
            if (!ps.getName().equals(this.name)) continue;
            this.remainingCapacity = ps.getRemainingCapacity();
            this.timeRemaining = ps.getTimeRemaining();
            return;
        }
        this.remainingCapacity = 0.0;
        this.timeRemaining = -1.0;
    }
}

