/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import com.sun.jna.Native;
import com.sun.jna.platform.linux.LibC;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.VirtualMemory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.hardware.platform.linux.LinuxVirtualMemory;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;

public class LinuxGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxGlobalMemory.class);

    @Override
    public long getAvailable() {
        this.updateMemInfo();
        return this.memAvailable;
    }

    @Override
    public long getTotal() {
        if (this.memTotal < 0L) {
            this.readSysinfo();
        }
        return this.memTotal;
    }

    @Override
    public long getPageSize() {
        if (this.pageSize < 0L) {
            this.readSysinfo();
        }
        return this.pageSize;
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        if (this.virtualMemory == null) {
            this.virtualMemory = new LinuxVirtualMemory();
        }
        return this.virtualMemory;
    }

    private void readSysinfo() {
        try {
            LibC.Sysinfo info = new LibC.Sysinfo();
            if (0 == LibC.INSTANCE.sysinfo(info)) {
                this.memTotal = info.totalram.longValue();
                this.pageSize = info.mem_unit;
            } else {
                LOG.error("Failed to get sysinfo. Error code: {}", (Object)Native.getLastError());
            }
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            LOG.error("Failed to get sysinfo. {}", (Throwable)e);
            this.pageSize = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("getconf PAGE_SIZE"), 4096L);
            this.updateMemInfo();
        }
    }

    private void updateMemInfo() {
        long memFree = 0L;
        long activeFile = 0L;
        long inactiveFile = 0L;
        long sReclaimable = 0L;
        List<String> memInfo = FileUtil.readFile(ProcUtil.getProcPath() + "/meminfo");
        for (String checkLine : memInfo) {
            String[] memorySplit = ParseUtil.whitespaces.split(checkLine);
            if (memorySplit.length <= 1) continue;
            switch (memorySplit[0]) {
                case "MemTotal:": {
                    this.memTotal = this.parseMeminfo(memorySplit);
                    break;
                }
                case "MemAvailable:": {
                    this.memAvailable = this.parseMeminfo(memorySplit);
                    return;
                }
                case "MemFree:": {
                    memFree = this.parseMeminfo(memorySplit);
                    break;
                }
                case "Active(file):": {
                    activeFile = this.parseMeminfo(memorySplit);
                    break;
                }
                case "Inactive(file):": {
                    inactiveFile = this.parseMeminfo(memorySplit);
                    break;
                }
                case "SReclaimable:": {
                    sReclaimable = this.parseMeminfo(memorySplit);
                    break;
                }
            }
        }
        this.memAvailable = memFree + activeFile + inactiveFile + sReclaimable;
    }

    private long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && "kB".equals(memorySplit[2])) {
            memory *= 1024L;
        }
        return memory;
    }
}

