/*
 * Decompiled with CFR 0.152.
 */
package com.ok2c.hc.android.logging;

import android.util.Log;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

final class AndroidLogger
extends MarkerIgnoringBase {
    AndroidLogger(String tag) {
        this.name = tag;
    }

    boolean isLoggable(int priority) {
        return Log.isLoggable((String)this.name, (int)priority);
    }

    private void log(int priority, String message, Throwable throwable) {
        Log.println((int)priority, (String)this.name, (String)(throwable != null ? message + '\n' + Log.getStackTraceString((Throwable)throwable) : message));
    }

    void logFormatted(int priority, String format, Object ... argArray) {
        if (this.isLoggable(priority)) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.log(priority, ft.getMessage(), ft.getThrowable());
        }
    }

    void logMessage(int priority, String message, Throwable throwable) {
        if (this.isLoggable(priority)) {
            this.log(priority, message, throwable);
        }
    }

    public boolean isTraceEnabled() {
        return this.isLoggable(2);
    }

    public void trace(String msg) {
        this.logMessage(2, msg, null);
    }

    public void trace(String format, Object arg) {
        this.logFormatted(2, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logFormatted(2, format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.logFormatted(2, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.logMessage(2, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(3);
    }

    public void debug(String msg) {
        this.logMessage(3, msg, null);
    }

    public void debug(String format, Object arg) {
        this.logFormatted(3, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logFormatted(3, format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.logFormatted(3, format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.logMessage(3, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isLoggable(4);
    }

    public void info(String msg) {
        this.logMessage(4, msg, null);
    }

    public void info(String format, Object arg) {
        this.logFormatted(4, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logFormatted(4, format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.logFormatted(4, format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.logMessage(4, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isLoggable(5);
    }

    public void warn(String msg) {
        this.logMessage(5, msg, null);
    }

    public void warn(String format, Object arg) {
        this.logFormatted(5, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logFormatted(5, format, arg1, arg2);
    }

    public void warn(String format, Object ... arguments) {
        this.logFormatted(5, format, arguments);
    }

    public void warn(String msg, Throwable t) {
        this.logMessage(5, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isLoggable(6);
    }

    public void error(String msg) {
        this.logMessage(6, msg, null);
    }

    public void error(String format, Object arg) {
        this.logFormatted(6, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logFormatted(6, format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.logFormatted(6, format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.logMessage(6, msg, t);
    }
}

