/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.socketio.client;

import com.github.nkzawa.emitter.Emitter;
import com.github.nkzawa.hasbinarydata.HasBinaryData;
import com.github.nkzawa.socketio.client.Ack;
import com.github.nkzawa.socketio.client.Manager;
import com.github.nkzawa.socketio.client.On;
import com.github.nkzawa.socketio.parser.Packet;
import com.github.nkzawa.thread.EventThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class Socket
extends Emitter {
    private static final Logger logger = Logger.getLogger(Socket.class.getName());
    public static final String EVENT_CONNECT = "connect";
    public static final String EVENT_DISCONNECT = "disconnect";
    public static final String EVENT_ERROR = "error";
    public static final String EVENT_MESSAGE = "message";
    private static Map<String, Integer> events = new HashMap<String, Integer>(){
        {
            this.put(Socket.EVENT_CONNECT, 1);
            this.put(Socket.EVENT_DISCONNECT, 1);
            this.put(Socket.EVENT_ERROR, 1);
        }
    };
    private boolean connected;
    private boolean disconnected = true;
    private int ids;
    private String nsp;
    Manager io;
    private Map<Integer, Ack> acks = new HashMap<Integer, Ack>();
    private Queue<On.Handle> subs;
    private final Queue<List<Object>> buffer = new LinkedList<List<Object>>();

    public Socket(Manager io, String nsp) {
        this.io = io;
        this.nsp = nsp;
    }

    public Socket open() {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Socket.this.connected) {
                    return;
                }
                final Manager io = Socket.this.io;
                io.open();
                Socket.this.subs = new LinkedList<On.Handle>(){
                    {
                        this.add(On.on(io, "open", new Emitter.Listener(){

                            public void call(Object ... args) {
                                Socket.this.onopen();
                            }
                        }));
                        this.add(On.on(io, Socket.EVENT_ERROR, new Emitter.Listener(){

                            public void call(Object ... args) {
                                Socket.this.onerror(args.length > 0 ? (Exception)args[0] : null);
                            }
                        }));
                        this.add(On.on(io, "packet", new Emitter.Listener(){

                            public void call(Object ... args) {
                                Socket.this.onpacket((Packet)args[0]);
                            }
                        }));
                        this.add(On.on(io, "close", new Emitter.Listener(){

                            public void call(Object ... args) {
                                Socket.this.onclose(args.length > 0 ? (String)args[0] : null);
                            }
                        }));
                    }
                };
                if (Manager.ReadyState.OPEN == Socket.this.io.readyState) {
                    Socket.this.onopen();
                }
            }
        });
        return this;
    }

    public Socket connect() {
        return this.open();
    }

    public Socket send(final Object ... args) {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                Socket.this.emit(Socket.EVENT_MESSAGE, args);
            }
        });
        return this;
    }

    public Emitter emit(final String event, final Object ... args) {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (events.containsKey(event)) {
                    Socket.super.emit(event, args);
                    return;
                }
                ArrayList<Object> _args = new ArrayList<Object>(args.length + 1);
                _args.add(event);
                _args.addAll(Arrays.asList(args));
                JSONArray jsonArgs = new JSONArray();
                for (Object e : _args) {
                    jsonArgs.put(e);
                }
                int parserType = 2;
                if (HasBinaryData.hasBinary(jsonArgs)) {
                    parserType = 5;
                }
                Packet<JSONArray> packet = new Packet<JSONArray>(parserType, jsonArgs);
                if (_args.get(_args.size() - 1) instanceof Ack) {
                    logger.fine(String.format("emitting packet with ack id %d", Socket.this.ids));
                    Socket.this.acks.put(Socket.this.ids, (Ack)_args.remove(_args.size() - 1));
                    packet.id = Socket.this.ids++;
                }
                Socket.this.packet(packet);
            }
        });
        return this;
    }

    public Emitter emit(final String event, final Object[] args, final Ack ack) {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                ArrayList<Object> _args = new ArrayList<Object>(){
                    {
                        this.add(event);
                        if (args != null) {
                            this.addAll(Arrays.asList(args));
                        }
                    }
                };
                Packet<JSONArray> packet = new Packet<JSONArray>(2, new JSONArray((Collection)_args));
                logger.fine(String.format("emitting packet with ack id %d", Socket.this.ids));
                Socket.this.acks.put(Socket.this.ids, ack);
                packet.id = Socket.this.ids++;
                Socket.this.packet(packet);
            }
        });
        return this;
    }

    private void packet(Packet packet) {
        packet.nsp = this.nsp;
        this.io.packet(packet);
    }

    private void onerror(Exception err) {
        this.emit(EVENT_ERROR, err);
    }

    private void onopen() {
        logger.fine("transport is open - connecting");
        if (!"/".equals(this.nsp)) {
            this.packet(new Packet(0));
        }
    }

    private void onclose(String reason) {
        logger.fine(String.format("close (%s)", reason));
        this.connected = false;
        this.disconnected = true;
        this.emit(EVENT_DISCONNECT, reason);
    }

    private void onpacket(Packet packet) {
        if (!this.nsp.equals(packet.nsp)) {
            return;
        }
        switch (packet.type) {
            case 0: {
                this.onconnect();
                break;
            }
            case 2: {
                this.onevent(packet);
                break;
            }
            case 5: {
                this.onevent(packet);
                break;
            }
            case 3: {
                this.onack(packet);
                break;
            }
            case 1: {
                this.ondisconnect();
                break;
            }
            case 4: {
                this.emit(EVENT_ERROR, packet.data);
            }
        }
    }

    private void onevent(Packet<JSONArray> packet) {
        ArrayList<Object> args = new ArrayList<Object>(Arrays.asList(Socket.toArray((JSONArray)packet.data)));
        logger.fine(String.format("emitting event %s", args));
        if (packet.id >= 0) {
            logger.fine("attaching ack callback to event");
            args.add(this.ack(packet.id));
        }
        if (this.connected) {
            String event = (String)args.remove(0);
            super.emit(event, args.toArray());
        } else {
            this.buffer.add(args);
        }
    }

    private Ack ack(final int id) {
        final Socket self = this;
        final boolean[] sent = new boolean[]{false};
        return new Ack(){

            @Override
            public synchronized void call(Object ... args) {
                if (sent[0]) {
                    return;
                }
                sent[0] = true;
                logger.fine(String.format("sending ack %s", args));
                Packet<JSONArray> packet = new Packet<JSONArray>(3, new JSONArray((Object)args));
                packet.id = id;
                self.packet(packet);
            }
        };
    }

    private void onack(Packet<JSONArray> packet) {
        logger.fine(String.format("calling ack %s with %s", packet.id, packet.data));
        Ack fn = this.acks.remove(packet.id);
        fn.call(Socket.toArray((JSONArray)packet.data));
    }

    private void onconnect() {
        this.connected = true;
        this.disconnected = false;
        this.emit(EVENT_CONNECT, new Object[0]);
        this.emitBuffered();
    }

    private void emitBuffered() {
        List<Object> data;
        while ((data = this.buffer.poll()) != null) {
            String event = (String)data.get(0);
            super.emit(event, data.toArray());
        }
    }

    private void ondisconnect() {
        logger.fine(String.format("server disconnect (%s)", this.nsp));
        this.destroy();
        this.onclose("io server disconnect");
    }

    private void destroy() {
        for (On.Handle sub : this.subs) {
            sub.destroy();
        }
        this.io.destroy(this);
    }

    public Socket close() {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!Socket.this.connected) {
                    return;
                }
                logger.fine(String.format("performing disconnect (%s)", Socket.this.nsp));
                Socket.this.packet(new Packet(1));
                Socket.this.destroy();
                Socket.this.onclose("io client disconnect");
            }
        });
        return this;
    }

    public Socket disconnect() {
        return this.close();
    }

    private static Object[] toArray(JSONArray array) {
        int length = array.length();
        Object[] data = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object v = array.get(i);
            data[i] = v == JSONObject.NULL ? null : v;
        }
        return data;
    }
}

