/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.engineio.client.transports;

import com.github.nkzawa.engineio.client.Transport;
import com.github.nkzawa.engineio.parser.Packet;
import com.github.nkzawa.engineio.parser.Parser;
import com.github.nkzawa.parseqs.ParseQS;
import com.github.nkzawa.thread.EventThread;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.SSLSocketFactory;
import okio.Buffer;
import okio.BufferedSource;

public class WebSocket
extends Transport {
    public static final String NAME = "websocket";
    private com.squareup.okhttp.ws.WebSocket ws;
    private WebSocketCall wsCall;

    public WebSocket(Transport.Options opts) {
        super(opts);
        this.name = NAME;
    }

    @Override
    protected void doOpen() {
        TreeMap headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.emit("requestHeaders", headers);
        final WebSocket self = this;
        OkHttpClient client = new OkHttpClient();
        if (this.sslContext != null) {
            SSLSocketFactory factory = this.sslContext.getSocketFactory();
            client.setSslSocketFactory(factory);
        }
        if (this.hostnameVerifier != null) {
            client.setHostnameVerifier(this.hostnameVerifier);
        }
        Request.Builder builder = new Request.Builder().url(this.uri());
        for (Map.Entry entry : headers.entrySet()) {
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        Request request = builder.build();
        this.wsCall = WebSocketCall.create((OkHttpClient)client, (Request)request);
        this.wsCall.enqueue(new WebSocketListener(){

            public void onOpen(com.squareup.okhttp.ws.WebSocket webSocket, Response response) {
                WebSocket.this.ws = webSocket;
                final TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                Headers responseHeaders = response.headers();
                int size = responseHeaders.size();
                for (int i = 0; i < size; ++i) {
                    headers.put(responseHeaders.name(i), responseHeaders.value(i));
                }
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        self.emit("responseHeaders", headers);
                        self.onOpen();
                    }
                });
            }

            public void onMessage(BufferedSource payload, final WebSocket.PayloadType type) throws IOException {
                Object data = null;
                switch (type) {
                    case TEXT: {
                        data = payload.readUtf8();
                        break;
                    }
                    case BINARY: {
                        data = payload.readByteArray();
                        break;
                    }
                    default: {
                        EventThread.exec(new Runnable(){

                            @Override
                            public void run() {
                                self.onError("Unknown payload type: " + type, new IllegalStateException());
                            }
                        });
                    }
                }
                payload.close();
                final Object finalData = data;
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        if (finalData == null) {
                            return;
                        }
                        if (finalData instanceof String) {
                            self.onData((String)finalData);
                        } else {
                            self.onData((byte[])finalData);
                        }
                    }
                });
            }

            public void onPong(Buffer payload) {
            }

            public void onClose(int code, String reason) {
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        self.onClose();
                    }
                });
            }

            public void onFailure(final IOException e, Response response) {
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        self.onError("websocket error", e);
                    }
                });
            }
        });
        client.getDispatcher().getExecutorService().shutdown();
    }

    @Override
    protected void write(Packet[] packets) {
        final WebSocket self = this;
        this.writable = false;
        for (Packet packet : packets) {
            Parser.encodePacket(packet, new Parser.EncodeCallback(){

                public void call(Object packet) {
                    try {
                        if (packet instanceof String) {
                            self.ws.sendMessage(WebSocket.PayloadType.TEXT, new Buffer().writeUtf8((String)packet));
                        } else if (packet instanceof byte[]) {
                            self.ws.sendMessage(WebSocket.PayloadType.BINARY, new Buffer().write((byte[])packet));
                        }
                    }
                    catch (IOException e) {
                        self.onError("websocket error", e);
                    }
                }
            });
        }
        Runnable ondrain = new Runnable(){

            @Override
            public void run() {
                self.writable = true;
                self.emit("drain", new Object[0]);
            }
        };
        EventThread.nextTick(ondrain);
    }

    @Override
    protected void onClose() {
        super.onClose();
    }

    @Override
    protected void doClose() {
        if (this.wsCall != null) {
            this.wsCall.cancel();
            this.wsCall = null;
        }
        if (this.ws != null) {
            try {
                this.ws.close(1000, "");
            }
            catch (IOException e) {
                this.onError("websocket error", e);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.ws = null;
        }
    }

    protected String uri() {
        String _query;
        HashMap<String, String> query = this.query;
        if (query == null) {
            query = new HashMap<String, String>();
        }
        String schema = this.secure ? "wss" : "ws";
        String port = "";
        if (this.port > 0 && ("wss".equals(schema) && this.port != 443 || "ws".equals(schema) && this.port != 80)) {
            port = ":" + this.port;
        }
        if (this.timestampRequests) {
            query.put(this.timestampParam, String.valueOf(new Date().getTime()));
        }
        if ((_query = ParseQS.encode(query)).length() > 0) {
            _query = "?" + _query;
        }
        return schema + "://" + this.hostname + port + this.path + _query;
    }
}

