/*
 * Decompiled with CFR 0.152.
 */
package org.jglfont.impl.format;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jglfont.impl.format.JGLAbstractFontData;
import org.jglfont.impl.format.JGLFontGlyphInfo;
import org.jglfont.spi.JGLFontRenderer;
import org.jglfont.spi.ResourceLoader;

public class JGLAwtFontData
extends JGLAbstractFontData {
    private Font font;
    private FontMetrics fontMetrics;
    private Graphics2D glyphGraphics;
    private BufferedImage glyphImage;
    private int glyphSide;
    private int glyphWidth;
    private int glyphHeight;

    public JGLAwtFontData(JGLFontRenderer renderer, ResourceLoader resourceLoader, Font font, int glyphSide) {
        super(renderer, resourceLoader);
        this.font = font;
        this.glyphSide = glyphSide;
        this.glyphImage = new BufferedImage(glyphSide, glyphSide, 10);
        this.glyphGraphics = this.createGraphics();
        this.fontMetrics = this.glyphGraphics.getFontMetrics(font);
        this.glyphWidth = this.fontMetrics.getMaxAdvance();
        this.glyphHeight = this.fontMetrics.getHeight();
        this.setLineHeight(this.glyphHeight);
        this.setBitmapWidth(this.glyphWidth * 16);
        this.setBitmapHeight(this.glyphHeight * 16);
    }

    public Graphics2D createGraphics() {
        Graphics2D glyphGraphics = this.glyphImage.createGraphics();
        glyphGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        glyphGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        glyphGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        glyphGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        glyphGraphics.setComposite(AlphaComposite.Clear);
        glyphGraphics.fillRect(0, 0, this.glyphSide, this.glyphSide);
        glyphGraphics.setFont(this.font);
        glyphGraphics.setComposite(AlphaComposite.SrcOver);
        glyphGraphics.setColor(Color.black);
        glyphGraphics.fillRect(0, 0, this.glyphSide, this.glyphSide);
        return glyphGraphics;
    }

    @Override
    public void init() {
    }

    private void loadPage(int page) {
        int ch;
        int i;
        ByteBuffer texture = ByteBuffer.allocateDirect(this.getBitmapWidth() * this.getBitmapHeight() * 4);
        texture.order(ByteOrder.LITTLE_ENDIAN);
        String bitmapId = this.font.getName() + "-" + this.font.getSize() + "-" + this.font.getStyle() + "-" + this.glyphSide + "-" + page;
        for (i = 0; i < 256; ++i) {
            ch = page * 256 + i;
            char[] codepoint = Character.toChars(ch);
            GlyphVector glyphVector = this.font.layoutGlyphVector(this.glyphGraphics.getFontRenderContext(), codepoint, 0, codepoint.length, 0);
            this.glyphGraphics.setBackground(new Color(255, 255, 255, 0));
            this.glyphGraphics.clearRect(0, 0, this.glyphSide, this.glyphSide);
            this.glyphGraphics.setColor(Color.white);
            String chrd = new String(codepoint);
            this.glyphGraphics.drawString(chrd, 0, this.fontMetrics.getHeight() - this.fontMetrics.getDescent());
            Rectangle bounds = glyphVector.getGlyphLogicalBounds(0).getBounds();
            int xPos = i % 16;
            int yPos = i / 16;
            int x = xPos * this.glyphWidth;
            int y = yPos * this.glyphHeight;
            int w = this.glyphWidth;
            int h = this.glyphHeight;
            JGLFontGlyphInfo info = new JGLFontGlyphInfo();
            info.setPage(bitmapId);
            info.setX(x);
            info.setY(y);
            info.setWidth(w);
            info.setHeight(h);
            info.setXadvance((int)glyphVector.getGlyphMetrics(0).getAdvanceX());
            info.setXoffset(0);
            info.setYoffset(0);
            this.characters.put(ch, info);
            WritableRaster raster = this.glyphImage.getRaster();
            byte[] row = new byte[this.glyphWidth];
            for (int m = 0; m < this.glyphHeight; ++m) {
                raster.getDataElements(0, m, this.glyphWidth, 1, row);
                for (int n = 0; n < this.glyphWidth; ++n) {
                    byte b = row[n];
                    int pos = (y + m) * this.getBitmapWidth() + (x + n);
                    texture.put(pos * 4, (byte)-1);
                    texture.put(pos * 4 + 1, (byte)-1);
                    texture.put(pos * 4 + 2, (byte)-1);
                    texture.put(pos * 4 + 3, b);
                }
            }
        }
        try {
            this.getRenderer().registerBitmap(bitmapId, texture, this.getBitmapWidth(), this.getBitmapHeight(), bitmapId);
            for (i = 0; i < 256; ++i) {
                ch = page * 256 + i;
                JGLFontGlyphInfo info = (JGLFontGlyphInfo)this.characters.get(ch);
                this.getRenderer().registerGlyph(info.getPage(), ch, info.getXoffset(), info.getYoffset(), info.getWidth(), info.getHeight(), (float)info.getX() / (float)this.getBitmapWidth(), (float)info.getY() / (float)this.getBitmapHeight(), (float)(info.getX() + info.getWidth()) / (float)this.getBitmapWidth(), (float)(info.getY() + info.getHeight()) / (float)this.getBitmapHeight());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void preProcessGlyph(Integer codepoint) {
        if (!this.characters.containsKey(codepoint)) {
            int page = codepoint / 256;
            this.loadPage(page);
        }
    }
}

